/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;

public class AwaitingBootstrapState
extends BaseMessageProcessingState {
    public AwaitingBootstrapState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.AUTHENTICATED;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return command.getCommandType() == MenuCommandType.HEARTBEAT;
    }

    @Override
    protected void processTimeout() {
        this.context.close();
        this.context.changeState(AuthStatus.CONNECTION_FAILED);
        this.markDone();
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (this.checkIfThereIsAnHbEnd(cmd)) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.CHANGE_INT_FIELD) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.BOOTSTRAP) {
            MenuBootstrapCommand bs = (MenuBootstrapCommand)cmd;
            this.markDone();
            if (bs.getBootType() == MenuBootstrapCommand.BootType.START) {
                this.context.changeState(AuthStatus.BOOTSTRAPPING);
            } else {
                this.logger.log(System.Logger.Level.ERROR, "Received a boot end without start", this.context.getConnectionName());
                this.context.close();
            }
            return true;
        }
        return false;
    }
}

