/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.auth;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class PreDefinedAuthenticator
implements MenuAuthenticator {
    private final List<AuthenticationToken> authenticationItems = new CopyOnWriteArrayList<AuthenticationToken>();
    private final boolean alwaysAllow;
    private final String securePasscode;

    public PreDefinedAuthenticator(boolean alwaysAllow) {
        this.alwaysAllow = alwaysAllow;
        this.securePasscode = null;
    }

    public PreDefinedAuthenticator(String securePasscode, List<AuthenticationToken> upfrontTokens) {
        this.alwaysAllow = false;
        this.securePasscode = securePasscode;
        this.authenticationItems.addAll(upfrontTokens);
    }

    @Override
    public CompletableFuture<Boolean> addAuthentication(String name, UUID uuid, boolean needsApproval) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public void removeAuthentication(String user) {
        Optional<AuthenticationToken> maybeAuth = this.authenticationItems.stream().filter(auth -> auth.name.equals(user)).findFirst();
        maybeAuth.ifPresent(this.authenticationItems::remove);
    }

    @Override
    public boolean authenticate(String user, UUID uuid) {
        if (this.authenticationItems.isEmpty()) {
            return this.alwaysAllow;
        }
        for (AuthenticationToken auth : this.authenticationItems) {
            if (!auth.doesMatch(user, uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesPasscodeMatch(String passcode) {
        if (this.securePasscode == null) {
            return this.alwaysAllow;
        }
        return this.securePasscode.equals(passcode);
    }

    @Override
    public MenuAuthenticator.ManagementCapabilities managementCapabilities() {
        return this.alwaysAllow ? MenuAuthenticator.ManagementCapabilities.NOT_EDITABLE : MenuAuthenticator.ManagementCapabilities.CAN_REMOVE_ADD;
    }

    @Override
    public List<String> getAllNames() {
        return this.authenticationItems.stream().map(auth -> auth.name).collect(Collectors.toList());
    }

    public static class AuthenticationToken {
        private final String name;
        private final String uuid;

        public AuthenticationToken(String name, String uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        public boolean doesMatch(String name, UUID uuid) {
            if (name == null || uuid == null) {
                return false;
            }
            return this.name.equals(name) && this.uuid.equalsIgnoreCase(uuid.toString());
        }
    }
}

