/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class SafeBundleLoader {
    private static final String PROPERTIES_DEFAULT_FILE_HEADER = "# Created by TcMenu to hold menu translations, will always be written in UTF-8";
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final Path location;
    private final String baseName;
    private final URLClassLoader classLoader;

    public SafeBundleLoader(Path location, String baseName) {
        boolean unsuitableDirectory;
        this.location = location;
        this.baseName = baseName;
        try {
            unsuitableDirectory = Files.walk(location, 2, FileVisitOption.FOLLOW_LINKS).anyMatch(p -> Files.isRegularFile(p, new LinkOption[0]) && !p.toString().endsWith(".properties"));
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unable to determine if properties dir is safe", (Throwable)e);
            unsuitableDirectory = true;
        }
        if (unsuitableDirectory) {
            throw new IllegalArgumentException("Directory is not safe for properties classpath");
        }
        try {
            this.classLoader = new URLClassLoader(new URL[]{location.toUri().toURL()});
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Class loader for resource bundle was not created", (Throwable)e);
            throw new IllegalArgumentException("Class loader on properties failed", e);
        }
    }

    public ResourceBundle getBundleForLocale(Locale locale) {
        return ResourceBundle.getBundle(this.baseName, locale, this.classLoader);
    }

    public Path getLocation() {
        return this.location;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Map<String, String> loadResourceBundleAsMap(Locale locale) throws IOException {
        List<Object> lines;
        Path resolvedPath = this.getPathForLocale(locale);
        try {
            this.logger.log(System.Logger.Level.DEBUG, "Loading properties as UTF-8 " + resolvedPath);
            lines = Files.readAllLines(resolvedPath, StandardCharsets.UTF_8).stream().map(PropertiesFileLine::new).filter(line -> line.getLineType() == PropertiesLineType.HAS_KEY_AND_VALUE).collect(Collectors.toList());
        }
        catch (MalformedInputException | UnmappableCharacterException ex) {
            this.logger.log(System.Logger.Level.DEBUG, "Properties not UTF-8, fall back to ASCII: " + resolvedPath + " - " + ex.getMessage());
            lines = Files.readAllLines(resolvedPath, StandardCharsets.ISO_8859_1).stream().map(PropertiesFileLine::new).filter(line -> line.getLineType() == PropertiesLineType.HAS_KEY_AND_VALUE).collect(Collectors.toList());
        }
        catch (FileNotFoundException | FileSystemNotFoundException | NoSuchFileException ex) {
            this.logger.log(System.Logger.Level.DEBUG, "Properties file doesn't exist: " + resolvedPath + " - " + ex.getMessage());
            lines = new ArrayList();
        }
        HashMap<String, String> mapToReturn = new HashMap<String, String>(lines.size() + 20);
        for (PropertiesFileLine propertiesFileLine : lines) {
            mapToReturn.put(propertiesFileLine.getKey(), propertiesFileLine.getValue());
        }
        return mapToReturn;
    }

    public void saveChangesKeepingFormatting(Locale locale, Map<String, String> allValues) {
        this.saveChangesKeepingFormatting(locale, allValues, null);
    }

    public void saveChangesKeepingFormatting(Locale locale, Map<String, String> allValues, BiConsumer<Path, String> saveListener) {
        Path resolvedPath = this.getPathForLocale(locale);
        try {
            List<PropertiesFileLine> lines;
            if (Files.exists(resolvedPath, new LinkOption[0])) {
                lines = Files.readAllLines(resolvedPath, StandardCharsets.UTF_8).stream().map(PropertiesFileLine::new).collect(Collectors.toCollection(ArrayList::new));
            } else {
                lines = new ArrayList<PropertiesFileLine>();
                lines.add(new PropertiesFileLine(PROPERTIES_DEFAULT_FILE_HEADER, true));
            }
            for (Map.Entry<String, String> value : allValues.entrySet()) {
                PropertiesFileLine line = this.findLine(lines, value.getKey());
                if (line != null) {
                    line.setValue(value.getValue());
                    continue;
                }
                lines.add(new PropertiesFileLine(value.getKey(), value.getValue()));
            }
            String lineSeparator = System.getProperty("line.separator");
            if (lines.stream().noneMatch(PropertiesFileLine::isChanged)) {
                return;
            }
            String toWrite = lines.stream().map(PropertiesFileLine::outputLine).collect(Collectors.joining(lineSeparator)) + lineSeparator;
            Files.writeString(resolvedPath, (CharSequence)toWrite, new OpenOption[0]);
            if (saveListener != null) {
                saveListener.accept(resolvedPath, toWrite);
            }
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unable to save " + resolvedPath, (Throwable)e);
        }
    }

    public Path getPathForLocale(Locale locale) {
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return this.location.resolve(this.baseName + ".properties");
        }
        return this.location.resolve(this.baseName + "_" + locale + ".properties");
    }

    private PropertiesFileLine findLine(List<PropertiesFileLine> lines, String key) {
        for (PropertiesFileLine line : lines) {
            if (line.getLineType() != PropertiesLineType.HAS_KEY_AND_VALUE || !line.getKey().equals(key)) continue;
            return line;
        }
        return null;
    }

    static class PropertiesFileLine {
        private final String line;
        private final PropertiesLineType lineType;
        private String key = null;
        private String value = null;
        private boolean needsSave = false;

        public PropertiesFileLine(String key, String value) {
            this.line = key + "=" + value;
            this.lineType = PropertiesLineType.HAS_KEY_AND_VALUE;
            this.key = key;
            this.value = value;
            this.needsSave = true;
        }

        public PropertiesFileLine(String line, boolean needsSave) {
            this(line);
            this.needsSave = needsSave;
        }

        public PropertiesFileLine(String line) {
            this.line = line.trim();
            if (line.isEmpty()) {
                this.lineType = PropertiesLineType.BLANK;
            } else if (line.startsWith("#") || line.startsWith("!")) {
                this.lineType = PropertiesLineType.COMMENT;
            } else {
                String[] parts = line.split("\\s*=\\s*");
                if (parts.length > 1) {
                    this.key = parts[0].trim();
                    this.lineType = PropertiesLineType.HAS_KEY_AND_VALUE;
                    this.value = parts[1];
                } else if (line.trim().endsWith("=")) {
                    this.key = parts[0].trim();
                    this.lineType = PropertiesLineType.HAS_KEY_AND_VALUE;
                    this.value = "";
                } else {
                    this.lineType = PropertiesLineType.UNKNOWN;
                }
            }
        }

        PropertiesLineType getLineType() {
            return this.lineType;
        }

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        void setValue(String replacementValue) {
            if (replacementValue.equals(this.value)) {
                return;
            }
            this.value = replacementValue;
            this.needsSave = true;
        }

        boolean isChanged() {
            return this.needsSave;
        }

        String outputLine() {
            if (!this.needsSave) {
                return this.line;
            }
            if (this.lineType == PropertiesLineType.HAS_KEY_AND_VALUE) {
                return this.key + "=" + this.value;
            }
            return this.line;
        }
    }

    static enum PropertiesLineType {
        BLANK,
        COMMENT,
        HAS_KEY_AND_VALUE,
        UNKNOWN;

    }
}

