/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import com.thecoderscorner.menu.remote.protocol.MessageField;
import java.util.Objects;
import java.util.UUID;

public class MenuJoinCommand
implements MenuCommand {
    private final String myName;
    private final int apiVer;
    private final ApiPlatform platform;
    private final UUID appUuid;
    private final int serialNumber;

    public MenuJoinCommand(UUID uuid, String myName, ApiPlatform platform, int apiVer, int serialNo) {
        this.myName = myName;
        this.appUuid = uuid;
        this.apiVer = apiVer;
        this.platform = platform;
        this.serialNumber = serialNo;
    }

    public String getMyName() {
        return this.myName;
    }

    public UUID getAppUuid() {
        return this.appUuid;
    }

    public int getApiVersion() {
        return this.apiVer;
    }

    public ApiPlatform getPlatform() {
        return this.platform;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public MessageField getCommandType() {
        return MenuCommandType.JOIN;
    }

    public String toString() {
        return "MenuJoinCommand{myName='" + this.myName + "', apiVer=" + this.apiVer + ", platform=" + this.platform + "', uuid=" + this.appUuid + " (S/N=" + this.serialNumber + ")}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuJoinCommand that = (MenuJoinCommand)o;
        return this.apiVer == that.apiVer && Objects.equals(this.getMyName(), that.getMyName()) && this.getPlatform() == that.getPlatform();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMyName(), this.apiVer, this.getPlatform()});
    }
}

