/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BaseMessageProcessingState
implements RemoteConnectorState {
    protected final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final AtomicBoolean taskDone = new AtomicBoolean(false);
    protected final RemoteConnectorContext context;
    protected AtomicInteger disconnectInterval = new AtomicInteger(5000);
    protected AtomicLong lastReception = new AtomicLong(0L);

    protected BaseMessageProcessingState(RemoteConnectorContext context) {
        this.context = context;
    }

    @Override
    public void enterState() {
        this.lastReception.set(this.context.getClock().millis());
    }

    @Override
    public void runLoop() {
        while (this.context.isDeviceConnected() && !this.taskDone.get() && !Thread.currentThread().isInterrupted()) {
            if (this.context.getClock().millis() - this.lastReception.get() > (long)this.disconnectInterval.get()) {
                this.logger.log(System.Logger.Level.INFO, "Connection timeout recorded " + this.context.getConnectionName());
                this.processTimeout();
            }
            try {
                MenuCommand cmd = this.context.readCommandFromStream();
                if (cmd == null) continue;
                this.lastReception.set(this.context.getClock().millis());
                if (this.processMessage(cmd)) continue;
                this.logger.log(System.Logger.Level.WARNING, "Unexpected msg, resetting with HB close for " + this.context.getConnectionName());
                this.context.sendHeartbeat(5000, MenuHeartbeatCommand.HeartbeatMode.END);
                this.context.changeState(AuthStatus.CONNECTION_FAILED);
            }
            catch (Exception e) {
                this.markDone();
                this.logger.log(System.Logger.Level.ERROR, "Exception while processing connection start on " + this.context.getConnectionName(), (Throwable)e);
                this.context.changeState(AuthStatus.CONNECTION_FAILED);
                return;
            }
        }
        this.taskDone.set(true);
    }

    protected abstract void processTimeout();

    protected abstract boolean processMessage(MenuCommand var1);

    protected void markDone() {
        this.taskDone.set(true);
    }

    @Override
    public void exitState(RemoteConnectorState nextState) {
        if (!this.taskDone.get()) {
            this.taskDone.set(true);
            this.logger.log(System.Logger.Level.INFO, "Force closing connection " + this.context.getConnectionName());
        }
    }

    protected boolean checkIfThereIsAnHbEnd(MenuCommand cmd) {
        MenuHeartbeatCommand hb;
        if (cmd.getCommandType() == MenuCommandType.HEARTBEAT && (hb = (MenuHeartbeatCommand)cmd).getMode() == MenuHeartbeatCommand.HeartbeatMode.END) {
            this.logger.log(System.Logger.Level.ERROR, "Received a remote end message during boot");
            this.processTimeout();
            return true;
        }
        return false;
    }
}

