/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class EditableTextMenuItem
extends MenuItem {
    private final int textLength;
    private final EditItemType itemType;

    public EditableTextMenuItem() {
        super("", null, -1, -1, null, false, false, true, false);
        this.textLength = 0;
        this.itemType = EditItemType.PLAIN_TEXT;
    }

    public EditableTextMenuItem(String name, String varName, int id, int eepromAddress, String functionName, int length, EditItemType itemType, boolean readOnly, boolean localOnly, boolean visible, boolean staticInRam) {
        super(name, varName, id, eepromAddress, functionName, readOnly, localOnly, visible, staticInRam);
        this.textLength = length;
        this.itemType = itemType;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public EditItemType getItemType() {
        return this.itemType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditableTextMenuItem that = (EditableTextMenuItem)o;
        return this.getTextLength() == that.getTextLength() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.getItemType() == that.getItemType() && this.isVisible() == that.isVisible() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName()) && Objects.equals(this.getVariableName(), that.getVariableName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTextLength(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.getItemType(), this.getVariableName()});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

