/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import com.thecoderscorner.menu.persist.ReleaseType;
import java.util.Objects;

public class VersionInfo {
    public static final VersionInfo ERROR_VERSION = new VersionInfo("0.0.0");
    private final int major;
    private final int minor;
    private final int patch;
    private final ReleaseType releaseType;

    public VersionInfo(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.patch = 0;
        this.releaseType = ReleaseType.STABLE;
    }

    public VersionInfo(String ver) {
        String[] verSplit = ver.split("[-.]");
        if (verSplit.length < 2) {
            this.patch = 0;
            this.minor = 0;
            this.major = 0;
            this.releaseType = ReleaseType.STABLE;
        } else {
            ReleaseType r;
            int pat;
            int min;
            int maj;
            try {
                maj = Integer.parseInt(verSplit[0]);
                min = Integer.parseInt(verSplit[1]);
                pat = verSplit.length > 2 ? Integer.parseInt(verSplit[2]) : 0;
                r = verSplit.length > 3 ? this.fromReleaseSpecifier(verSplit[3]) : ReleaseType.STABLE;
            }
            catch (Exception ex) {
                pat = -1;
                min = -1;
                maj = -1;
                r = ReleaseType.STABLE;
            }
            this.major = maj;
            this.minor = min;
            this.patch = pat;
            this.releaseType = r;
        }
    }

    private ReleaseType fromReleaseSpecifier(String s) {
        switch (s.toLowerCase()) {
            case "patch": {
                return ReleaseType.PATCH;
            }
            case "snapshot": 
            case "beta": 
            case "rc": {
                return ReleaseType.BETA;
            }
            case "previous": {
                return ReleaseType.PREVIOUS;
            }
        }
        return ReleaseType.STABLE;
    }

    public static VersionInfo fromString(String sel) {
        try {
            return new VersionInfo(sel);
        }
        catch (Exception e) {
            return ERROR_VERSION;
        }
    }

    public boolean isSameOrNewerThan(VersionInfo other) {
        if (this.major > other.major) {
            return true;
        }
        if (this.major < other.major) {
            return false;
        }
        if (this.minor > other.minor) {
            return true;
        }
        if (this.minor < other.minor) {
            return false;
        }
        return this.patch >= other.patch;
    }

    public String toString() {
        if (this.releaseType == ReleaseType.STABLE) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor + "." + this.patch + "-" + String.valueOf((Object)this.releaseType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.releaseType == that.releaseType;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public ReleaseType getReleaseType() {
        return this.releaseType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.major, this.minor, this.patch, this.releaseType});
    }
}

