/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.ListResponse;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuLargeNumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuPairingCommand;
import com.thecoderscorner.menu.remote.commands.MenuRuntimeListBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.ProtocolUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

public class CommandFactory {
    public static MenuJoinCommand newJoinCommand(String name) {
        return new MenuJoinCommand(UUID.randomUUID(), name, ApiPlatform.JAVA_API, ProtocolUtil.getVersionFromProperties(), 0);
    }

    public static MenuJoinCommand newJoinCommand(String name, UUID uuid, int serialNo) {
        return new MenuJoinCommand(uuid, name, ApiPlatform.JAVA_API, ProtocolUtil.getVersionFromProperties(), serialNo);
    }

    public static MenuHeartbeatCommand newHeartbeatCommand(int frequency, MenuHeartbeatCommand.HeartbeatMode mode) {
        return new MenuHeartbeatCommand(frequency, mode);
    }

    public static MenuAcknowledgementCommand newAcknowledgementCommand(CorrelationId correlationId, AckStatus status) {
        return new MenuAcknowledgementCommand(correlationId, status);
    }

    public static MenuPairingCommand newPairingCommand(String name, UUID uuid) {
        return new MenuPairingCommand(name, uuid);
    }

    public static MenuDialogCommand newDialogCommand(DialogMode mode, String header, String msg, MenuButtonType b1, MenuButtonType b2, CorrelationId correlationId) {
        return new MenuDialogCommand(mode, header, msg, b1, b2, correlationId);
    }

    public static MenuBootstrapCommand newBootstrapCommand(MenuBootstrapCommand.BootType type) {
        return new MenuBootstrapCommand(type);
    }

    public static MenuAnalogBootCommand newAnalogBootCommand(int parentId, AnalogMenuItem item, int currentVal) {
        return new MenuAnalogBootCommand(parentId, item, currentVal);
    }

    public static MenuRuntimeListBootCommand newRuntimeListBootCommand(int parentId, RuntimeListMenuItem item, List<String> val) {
        return new MenuRuntimeListBootCommand(parentId, item, val);
    }

    public static MenuSubBootCommand newMenuSubBootCommand(int parentId, SubMenuItem item) {
        return new MenuSubBootCommand(parentId, item, false);
    }

    public static MenuEnumBootCommand newMenuEnumBootCommand(int parentId, EnumMenuItem item, int currentVal) {
        return new MenuEnumBootCommand(parentId, item, currentVal);
    }

    public static MenuBooleanBootCommand newMenuBooleanBootCommand(int parentId, BooleanMenuItem item, boolean currentVal) {
        return new MenuBooleanBootCommand(parentId, item, currentVal);
    }

    public static MenuFloatBootCommand newMenuFloatBootCommand(int parentId, FloatMenuItem item, Float currentVal) {
        return new MenuFloatBootCommand(parentId, item, currentVal);
    }

    public static MenuActionBootCommand newMenuActionBootCommand(int parentId, ActionMenuItem item) {
        return new MenuActionBootCommand(parentId, item, false);
    }

    public static MenuTextBootCommand newMenuTextBootCommand(int parentId, EditableTextMenuItem item, String currentVal) {
        return new MenuTextBootCommand(parentId, item, currentVal);
    }

    public static MenuLargeNumBootCommand newLargeNumberBootItem(int parentId, EditableLargeNumberMenuItem item, BigDecimal currentVal) {
        return new MenuLargeNumBootCommand(parentId, item, currentVal);
    }

    public static MenuChangeCommand newDeltaChangeCommand(CorrelationId correlation, MenuItem item, int value) {
        return new MenuChangeCommand(correlation, item.getId(), MenuChangeCommand.ChangeType.DELTA, Integer.toString(value));
    }

    public static MenuChangeCommand newAbsoluteMenuChangeCommand(CorrelationId correlation, MenuItem item, Object value) {
        return new MenuChangeCommand(correlation, item.getId(), MenuChangeCommand.ChangeType.ABSOLUTE, value.toString());
    }

    public static MenuChangeCommand newListResponseChangeCommand(CorrelationId correlation, MenuItem item, ListResponse value) {
        return new MenuChangeCommand(correlation, item.getId(), MenuChangeCommand.ChangeType.LIST_STATE_CHANGE, value.toString());
    }

    public static MenuChangeCommand newListResponseChangeCommand(CorrelationId correlation, int itemId, ListResponse value) {
        return new MenuChangeCommand(correlation, itemId, MenuChangeCommand.ChangeType.LIST_STATE_CHANGE, value.toString());
    }

    public static MenuChangeCommand newDeltaChangeCommand(CorrelationId correlation, int itemId, int value) {
        return new MenuChangeCommand(correlation, itemId, MenuChangeCommand.ChangeType.DELTA, Integer.toString(value));
    }

    public static MenuChangeCommand newAbsoluteMenuChangeCommand(CorrelationId correlation, int itemId, Object value) {
        return new MenuChangeCommand(correlation, itemId, MenuChangeCommand.ChangeType.ABSOLUTE, value.toString());
    }

    public static MenuChangeCommand newAbsoluteListChangeCommand(CorrelationId correlation, int itemId, List<String> values) {
        return new MenuChangeCommand(correlation, itemId, values);
    }
}

