/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;

public abstract class MenuItemBuilder<T extends MenuItemBuilder, M extends MenuItem> {
    String name;
    String variableName;
    int id;
    int eepromAddr;
    String functionName;
    boolean readOnly;
    boolean localOnly;
    boolean staticDataInRAM;
    boolean visible = true;

    abstract T getThis();

    public T withName(String name) {
        this.name = name;
        return this.getThis();
    }

    public T withStaticDataInRAM(boolean inRAM) {
        this.staticDataInRAM = inRAM;
        return this.getThis();
    }

    public T withVariableName(String variableName) {
        this.variableName = variableName;
        return this.getThis();
    }

    public T withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this.getThis();
    }

    public T withId(int id) {
        this.id = id;
        return this.getThis();
    }

    public T withEepromAddr(int eepromAddr) {
        this.eepromAddr = eepromAddr;
        return this.getThis();
    }

    public T withFunctionName(String functionName) {
        this.functionName = functionName;
        return this.getThis();
    }

    public T withLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
        return this.getThis();
    }

    public T withVisible(boolean visible) {
        this.visible = visible;
        return this.getThis();
    }

    protected void baseFromExisting(M item) {
        this.name = ((MenuItem)item).getName();
        this.id = ((MenuItem)item).getId();
        this.eepromAddr = ((MenuItem)item).getEepromAddress();
        this.functionName = ((MenuItem)item).getFunctionName();
        this.variableName = ((MenuItem)item).getVariableName();
        this.readOnly = ((MenuItem)item).isReadOnly();
        this.localOnly = ((MenuItem)item).isLocalOnly();
        this.visible = ((MenuItem)item).isVisible();
        this.staticDataInRAM = ((MenuItem)item).isStaticDataInRAM();
    }

    public abstract M menuItem();
}

