/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.state.PortableColor;
import java.util.Arrays;

public class PortablePalette {
    private final PortableColor[] colorArray;
    private final PaletteMode paletteMode;
    private final boolean alphaInUse;

    public PortablePalette(PortableColor[] colorArray, PaletteMode paletteMode) {
        this(colorArray, paletteMode, false);
    }

    public PortablePalette(PortableColor[] colorArray, PaletteMode paletteMode, boolean alphaInUse) {
        this.paletteMode = paletteMode;
        this.alphaInUse = alphaInUse;
        if (colorArray.length != 1 << this.getBitsPerPixel()) {
            throw new IllegalArgumentException("Array to small for BPP");
        }
        this.colorArray = Arrays.copyOf(colorArray, colorArray.length);
    }

    public PortableColor[] getColorArray() {
        return this.colorArray;
    }

    public PortableColor getColorAt(int index) {
        return this.colorArray[index];
    }

    public PaletteMode getPaletteMode() {
        return this.paletteMode;
    }

    public int getBitsPerPixel() {
        return this.paletteMode == PaletteMode.ONE_BPP ? 1 : (this.paletteMode == PaletteMode.TWO_BPP ? 2 : 4);
    }

    public boolean isAlphaInUse() {
        return this.alphaInUse;
    }

    public int getNumColors() {
        return this.colorArray.length;
    }

    public void setColorAt(int index, PortableColor newColor) {
        this.colorArray[index] = newColor;
    }

    public int getClosestColorIndex(PortableColor col, double v, boolean applyAlpha) {
        if (applyAlpha) {
            col = col.applyAlphaChannel();
        }
        int closestIndex = 0;
        double closestDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.colorArray.length; ++i) {
            double distance = Math.sqrt(Math.pow(col.getRed() - this.colorArray[i].getRed(), 2.0) + Math.pow(col.getGreen() - this.colorArray[i].getGreen(), 2.0) + Math.pow(col.getBlue() - this.colorArray[i].getBlue(), 2.0));
            if (!(distance < closestDistance)) continue;
            closestIndex = i;
            closestDistance = distance;
        }
        return closestIndex;
    }

    public static enum PaletteMode {
        ONE_BPP,
        TWO_BPP,
        FOUR_BPP;

    }
}

