/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.encryption.ProtocolEncryptionHandler;
import com.thecoderscorner.menu.remote.protocol.CommandProtocol;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SharedStreamConnection {
    public static final int MAX_MSG_EXPECTED = 8192;
    protected final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    protected final MenuCommandProtocol protocol;
    protected final ByteBuffer inputBuffer = ByteBuffer.allocate(8192).order(ByteOrder.BIG_ENDIAN);
    protected final ByteBuffer cmdBuffer = ByteBuffer.allocate(8192).order(ByteOrder.BIG_ENDIAN);
    protected final ProtocolEncryptionHandler encryptionHandler;

    protected SharedStreamConnection(MenuCommandProtocol protocol, ProtocolEncryptionHandler encryptionHandler) {
        this.protocol = protocol;
        this.encryptionHandler = encryptionHandler;
    }

    public void close() {
        if (this.encryptionHandler != null) {
            this.encryptionHandler.getDecryptBuffer().reset().flip();
        }
    }

    public MenuCommand readCommandFromStream() throws IOException {
        try {
            byte byStart = 0;
            while (byStart != 1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Connection thread interrupted");
                }
                if (!this.isDeviceConnected()) {
                    throw new IOException("Connection thread not connected");
                }
                byStart = this.nextByte(this.inputBuffer);
            }
            this.readCompleteMessage(this.inputBuffer);
            this.logByteBuffer("Line read from stream", this.inputBuffer);
            MenuCommand mc = this.protocol.fromChannel(this.inputBuffer);
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.connectionLog(System.Logger.Level.DEBUG, "Menu command read: " + String.valueOf(mc));
            }
            return mc;
        }
        catch (TcProtocolException ex) {
            this.logger.log(System.Logger.Level.WARNING, "Protocol error: " + ex.getMessage() + ", remote=" + this.getConnectionName());
            return null;
        }
    }

    public static boolean doesBufferHaveEOM(ByteBuffer inputBuffer) {
        if (inputBuffer.remaining() < 4) {
            return false;
        }
        ByteBuffer bbCopy = inputBuffer.slice();
        CommandProtocol proto = CommandProtocol.fromProtocolId(bbCopy.get());
        if (proto == CommandProtocol.TAG_VAL_PROTOCOL) {
            boolean foundMsg = false;
            while (!foundMsg && bbCopy.hasRemaining()) {
                foundMsg = bbCopy.get() == 124 && bbCopy.hasRemaining() && bbCopy.get() == 2;
            }
            return foundMsg;
        }
        bbCopy.getShort();
        short len = bbCopy.getShort();
        return bbCopy.remaining() >= len;
    }

    protected void readCompleteMessage(ByteBuffer inputBuffer) throws IOException {
        while (!SharedStreamConnection.doesBufferHaveEOM(inputBuffer)) {
            if (inputBuffer.remaining() > 8192) {
                throw new TcProtocolException("Message corrupt, no EOM");
            }
            this.getAtLeastBytes(inputBuffer, 1, StreamRemoteConnector.ReadMode.READ_MORE);
        }
    }

    private byte nextByte(ByteBuffer inputBuffer) throws IOException {
        if (this.encryptionHandler != null) {
            if (inputBuffer.remaining() < 1) {
                ByteBuffer decryptBuffer = this.encryptionHandler.getDecryptBuffer();
                this.getAtLeastBytes(decryptBuffer, 2, StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY);
                short len = decryptBuffer.getShort();
                while (decryptBuffer.remaining() < len) {
                    this.getAtLeastBytes(decryptBuffer, len, StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY);
                }
                byte[] data = this.encryptionHandler.decryptBuffer(decryptBuffer, len);
                inputBuffer.compact().put(data).flip();
            }
        } else {
            this.getAtLeastBytes(inputBuffer, 1, StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY);
        }
        return inputBuffer.get();
    }

    protected abstract void getAtLeastBytes(ByteBuffer var1, int var2, StreamRemoteConnector.ReadMode var3) throws IOException;

    protected void logByteBuffer(String msg, ByteBuffer inBuffer) {
        if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            return;
        }
        ByteBuffer bb = inBuffer.duplicate();
        StringBuilder sb = new StringBuilder(256);
        sb.append(msg).append(". Content: ");
        int len = Math.min(400, bb.remaining());
        for (int pos = 0; pos < len; ++pos) {
            byte dataByte = bb.get();
            if (dataByte > 31) {
                sb.append((char)dataByte);
                continue;
            }
            sb.append(String.format("<0x%02x>", dataByte));
        }
        this.connectionLog(System.Logger.Level.DEBUG, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMenuCommand(MenuCommand msg) throws IOException {
        if (this.canSendMessageNow(msg)) {
            ByteBuffer byteBuffer = this.cmdBuffer;
            synchronized (byteBuffer) {
                this.cmdBuffer.clear();
                this.protocol.toChannel(this.cmdBuffer, msg);
                this.cmdBuffer.flip();
                this.logByteBuffer("Sending message on " + this.getConnectionName(), this.cmdBuffer);
                if (this.encryptionHandler != null) {
                    byte[] data = this.encryptionHandler.encryptBuffer(this.cmdBuffer);
                    this.cmdBuffer.clear().putShort((short)data.length).put(data).flip();
                }
                this.sendInternal(this.cmdBuffer);
            }
        } else {
            throw new IOException("Not connected to port");
        }
    }

    protected void connectionLog(System.Logger.Level l, String s) {
        this.logger.log(l, this.getConnectionName() + " - " + s);
    }

    protected abstract void sendInternal(ByteBuffer var1) throws IOException;

    public abstract boolean isDeviceConnected();

    public abstract String getConnectionName();

    public abstract boolean canSendMessageNow(MenuCommand var1);
}

