/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.encryption;

import com.thecoderscorner.menu.remote.encryption.ProtocolEncryptionHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESProtocolEncryptionHandler
implements ProtocolEncryptionHandler {
    private static final String AES_ALGO_NAME = "AES/CBC/PKCS5Padding";
    private static final SecureRandom secureRandom = new SecureRandom();
    private final SecretKey configuredKey;
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;
    private final ByteBuffer decryptBuffer = ByteBuffer.allocate(8192).order(ByteOrder.BIG_ENDIAN).flip();

    public AESProtocolEncryptionHandler(SecretKey configuredKey) throws Exception {
        this.configuredKey = configuredKey;
        this.encryptCipher = Cipher.getInstance(AES_ALGO_NAME);
        this.decryptCipher = Cipher.getInstance(AES_ALGO_NAME);
        this.encryptCipher.init(1, (Key)configuredKey, AESProtocolEncryptionHandler.generateIv());
    }

    public AESProtocolEncryptionHandler(String key) throws Exception {
        byte[] decodedKey = Base64.getDecoder().decode(key);
        this.configuredKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        this.encryptCipher = Cipher.getInstance(AES_ALGO_NAME);
        this.decryptCipher = Cipher.getInstance(AES_ALGO_NAME);
    }

    public static SecretKey generateAesKey(int bitsNeeded) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(bitsNeeded);
        return keyGenerator.generateKey();
    }

    public static IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    @Override
    public byte[] encryptBuffer(ByteBuffer inputBuffer) throws IOException {
        try {
            IvParameterSpec ivParameterSpec = AESProtocolEncryptionHandler.generateIv();
            this.encryptCipher.init(1, (Key)this.configuredKey, ivParameterSpec);
            int in = inputBuffer.remaining();
            int remainder = in % 16;
            int totalSize = remainder == 0 ? in : in + (16 - remainder);
            byte[] data = new byte[totalSize];
            inputBuffer.get(data, 0, inputBuffer.remaining());
            for (int i = in; i < totalSize; ++i) {
                data[i] = 0;
            }
            byte[] encrypted = new byte[this.encryptCipher.getOutputSize(totalSize) + 16];
            System.arraycopy(ivParameterSpec.getIV(), 0, encrypted, 0, 16);
            this.encryptCipher.doFinal(data, 0, totalSize, encrypted, 16);
            return encrypted;
        }
        catch (Exception e) {
            throw new IOException("Encrypt failed", e);
        }
    }

    @Override
    public byte[] decryptBuffer(ByteBuffer inputBuffer, int len) throws IOException {
        try {
            byte[] iv = new byte[16];
            inputBuffer.get(iv);
            byte[] encryptedData = new byte[len - 16];
            this.decryptCipher.init(2, (Key)this.configuredKey, new IvParameterSpec(iv));
            inputBuffer.get(encryptedData);
            return this.decryptCipher.doFinal(encryptedData);
        }
        catch (Exception ex) {
            throw new IOException("Decrypt failed", ex);
        }
    }

    @Override
    public ByteBuffer getDecryptBuffer() {
        return this.decryptBuffer;
    }
}

