/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.mgrclient;

import com.thecoderscorner.menu.mgr.NewServerConnectionListener;
import com.thecoderscorner.menu.mgr.ServerConnection;
import com.thecoderscorner.menu.mgr.ServerConnectionManager;
import com.thecoderscorner.menu.mgr.ServerConnectionMode;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.encryption.EncryptionHandlerFactory;
import com.thecoderscorner.menu.remote.encryption.NoEncryptionHandlerFactory;
import com.thecoderscorner.menu.remote.mgrclient.SocketServerConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SocketServerConnectionManager
implements ServerConnectionManager {
    private final System.Logger logger = System.getLogger(SocketServerConnectionManager.class.getSimpleName());
    private final Thread acceptThread;
    private final ServerSocket serverSocket;
    private final List<ServerConnection> connections = new CopyOnWriteArrayList<ServerConnection>();
    private final MenuCommandProtocol protocol;
    private final ScheduledFuture<?> taskFuture;
    private final int port;
    private final Clock clock;
    private final int heartbeatTimeout;
    private volatile NewServerConnectionListener connectionListener;
    private EncryptionHandlerFactory encryptionManager = new NoEncryptionHandlerFactory();

    public SocketServerConnectionManager(MenuCommandProtocol protocol, ScheduledExecutorService service, int port, Clock clock, int heartbeatTimeout) {
        this.protocol = protocol;
        this.port = port;
        this.clock = clock;
        this.heartbeatTimeout = heartbeatTimeout;
        this.acceptThread = new Thread(this::acceptConnections);
        try {
            this.serverSocket = new ServerSocket();
        }
        catch (IOException ex) {
            this.logger.log(System.Logger.Level.ERROR, "Server socket not created", (Throwable)ex);
            throw new IllegalStateException("Could not start server socket", ex);
        }
        this.taskFuture = service.scheduleAtFixedRate(this::checkAllConnections, 1L, 1L, TimeUnit.SECONDS);
    }

    private void checkAllConnections() {
        ArrayList<ServerConnection> connectionsToRemove = new ArrayList<ServerConnection>();
        for (ServerConnection connection : this.connections) {
            if (connection.getConnectionMode() != ServerConnectionMode.DISCONNECTED) continue;
            connectionsToRemove.add(connection);
        }
        for (ServerConnection connection : connectionsToRemove) {
            this.connections.remove(connection);
        }
    }

    private void acceptConnections() {
        this.logger.log(System.Logger.Level.INFO, "Start accept thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Socket sock = this.serverSocket.accept();
                this.logger.log(System.Logger.Level.INFO, "Accepted client " + String.valueOf(sock.getRemoteSocketAddress()));
                SocketServerConnection newConnection = new SocketServerConnection(sock, this.protocol, this.clock, this.encryptionManager.create(), this.heartbeatTimeout);
                this.connections.add(newConnection);
                this.connectionListener.connectionCreated(newConnection);
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Exception during accept", (Throwable)e);
            }
        }
        this.logger.log(System.Logger.Level.INFO, "End accept thread");
    }

    @Override
    public List<ServerConnection> getServerConnections() {
        if (this.connections.isEmpty()) {
            return List.of();
        }
        return List.copyOf(this.connections);
    }

    @Override
    public void start(NewServerConnectionListener listener) {
        this.logger.log(System.Logger.Level.INFO, "Start called on server manager - port " + this.port);
        this.connectionListener = listener;
        try {
            this.serverSocket.bind(new InetSocketAddress(this.port));
            this.acceptThread.start();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Exception during start", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.logger.log(System.Logger.Level.INFO, "Stop called on server manager");
        this.acceptThread.interrupt();
        this.taskFuture.cancel(true);
    }
}

