/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.encryption.ProtocolEncryptionHandler;
import com.thecoderscorner.menu.remote.states.PairingAuthFailedState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import com.thecoderscorner.menu.remote.states.SocketAwaitJoinState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class SocketClientRemoteConnector
extends StreamRemoteConnector {
    private final SocketChannel socketChannel;
    private Consumer<SocketClientRemoteConnector> clientCloseHandler;

    public SocketClientRemoteConnector(LocalIdentifier localId, ScheduledExecutorService executor, Clock clock, MenuCommandProtocol protocol, SocketChannel socketChannel, Consumer<SocketClientRemoteConnector> closeNotifier, ProtocolEncryptionHandler encryptionHandler) {
        super(localId, protocol, executor, clock, encryptionHandler);
        this.socketChannel = socketChannel;
        this.clientCloseHandler = closeNotifier;
        this.applyStates(ConnectMode.FULLY_AUTHENTICATED);
    }

    private void applyStates(ConnectMode mode) {
        this.stateMachineMappings.put(AuthStatus.ESTABLISHED_CONNECTION, SocketAwaitJoinState.class);
        this.stateMachineMappings.put(AuthStatus.FAILED_AUTH, PairingAuthFailedState.class);
        this.handleCoreConnectionStates(mode);
        this.stateMachineMappings.put(AuthStatus.CONNECTION_FAILED, ClientConnectionFailedState.class);
    }

    @Override
    public void start() {
        this.connectionLog(System.Logger.Level.INFO, "Client acquired from " + String.valueOf(this.socketChannel.socket().getRemoteSocketAddress()));
        this.changeState(AuthStatus.ESTABLISHED_CONNECTION);
        this.startThreadProc();
    }

    @Override
    public void stop() {
        this.close();
    }

    @Override
    public void close() {
        this.connectionLog(System.Logger.Level.INFO, "Closing client socket " + this.getConnectionName());
        try {
            this.stopThreadProc();
            this.clientCloseHandler.accept(this);
            this.changeState(AuthStatus.CONNECTION_FAILED);
            this.socketChannel.close();
            super.close();
        }
        catch (IOException e) {
            this.connectionLog(System.Logger.Level.ERROR, "Unexpected error closing socket", e);
        }
    }

    @Override
    public void performConnection() throws IOException {
        throw new IOException("Not supported in client remote connector");
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len, StreamRemoteConnector.ReadMode mode) throws IOException {
        if (mode == StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY && inputBuffer.remaining() >= len) {
            return;
        }
        if (!this.isDeviceConnected()) {
            throw new IOException("Client Socket closed during read " + String.valueOf(this.socketChannel.socket().getRemoteSocketAddress()));
        }
        do {
            inputBuffer.compact();
            int actual = this.socketChannel.read(inputBuffer);
            inputBuffer.flip();
            if (actual > 0) continue;
            throw new IOException("Client Socket probably closed, read return was 0 or less " + String.valueOf(this.socketChannel.socket().getRemoteSocketAddress()));
        } while (inputBuffer.remaining() < len);
    }

    @Override
    protected void sendInternal(ByteBuffer outputBuffer) throws IOException {
        while (this.isDeviceConnected() && outputBuffer.hasRemaining()) {
            int len = this.socketChannel.write(outputBuffer);
            if (len > 0) continue;
            throw new IOException("Client Socket closed - returned 0 or less from write " + String.valueOf(this.socketChannel.socket().getRemoteSocketAddress()));
        }
    }

    @Override
    public boolean isDeviceConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public String getConnectionName() {
        if (this.socketChannel == null) {
            return "NULL";
        }
        return "TCP " + String.valueOf(this.socketChannel.socket().getRemoteSocketAddress());
    }

    public static class ClientConnectionFailedState
    implements RemoteConnectorState {
        private final RemoteConnectorContext controller;

        public ClientConnectionFailedState(RemoteConnectorContext controller) {
            this.controller = controller;
        }

        @Override
        public void enterState() {
            this.controller.close();
        }

        @Override
        public void exitState(RemoteConnectorState nextState) {
        }

        @Override
        public AuthStatus getAuthenticationStatus() {
            return AuthStatus.NOT_STARTED;
        }

        @Override
        public boolean canSendCommandToRemote(MenuCommand command) {
            return false;
        }

        @Override
        public void runLoop() throws Exception {
            Thread.sleep(10L);
        }
    }
}

