/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.state;

import java.util.Objects;

public class PortableColor {
    public static final PortableColor BLACK = new PortableColor(0, 0, 0);
    public static final PortableColor WHITE = new PortableColor(255, 255, 255);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public PortableColor(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public PortableColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public PortableColor(String htmlCode) {
        if (htmlCode == null) {
            this.alpha = 0;
            this.blue = 0;
            this.green = 0;
            this.red = 0;
            return;
        }
        if (htmlCode.startsWith("#") && htmlCode.length() == 4) {
            this.red = PortableColor.parseHex(htmlCode.charAt(1)) << 4;
            this.green = PortableColor.parseHex(htmlCode.charAt(2)) << 4;
            this.blue = PortableColor.parseHex(htmlCode.charAt(3)) << 4;
            this.alpha = 255;
            return;
        }
        if (htmlCode.startsWith("#") && htmlCode.length() >= 7) {
            this.red = (PortableColor.parseHex(htmlCode.charAt(1)) << 4) + PortableColor.parseHex(htmlCode.charAt(2));
            this.green = (PortableColor.parseHex(htmlCode.charAt(3)) << 4) + PortableColor.parseHex(htmlCode.charAt(4));
            this.blue = (PortableColor.parseHex(htmlCode.charAt(5)) << 4) + PortableColor.parseHex(htmlCode.charAt(6));
            this.alpha = htmlCode.length() == 9 ? (PortableColor.parseHex(htmlCode.charAt(7)) << 4) + PortableColor.parseHex(htmlCode.charAt(8)) : 255;
            return;
        }
        this.blue = 0;
        this.green = 0;
        this.red = 0;
        this.alpha = 255;
    }

    private static int parseHex(char val) {
        if (val >= '0' && val <= '9') {
            return (short)(val - 48);
        }
        if ((val = Character.toUpperCase(val)) >= 'A' && val <= 'F') {
            return (short)(val - 55);
        }
        return 0;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String toString() {
        return String.format("#%02X%02X%02X%02X", this.red, this.green, this.blue, this.alpha);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableColor that = (PortableColor)o;
        return this.red == that.red && this.green == that.green && this.blue == that.blue && this.alpha == that.alpha;
    }

    public int asArgb() {
        return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue, this.alpha);
    }

    public String toHtml() {
        return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
    }

    public static PortableColor asPortableColor(int argb) {
        int b = argb & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int a = argb >>> 24 & 0xFF;
        return new PortableColor(r, g, b, a);
    }

    public PortableColor applyAlphaChannel() {
        double al = (double)this.alpha / 255.0;
        double r = (double)this.red / 255.0 * al;
        double g = (double)this.green / 255.0 * al;
        double b = (double)this.blue / 255.0 * al;
        return new PortableColor((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), 255);
    }
}

