/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.mgr;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.MenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.mgr.DialogShowMode;
import com.thecoderscorner.menu.mgr.MenuManagerListener;
import com.thecoderscorner.menu.mgr.MenuManagerServer;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MenuInMenu {
    private static final int STATUS_ITEM_RANGE = 10;
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final ReplicationMode replicationMode;
    private final int offsetRange;
    private final int maxRange;
    private final RemoteConnector remoteConnector;
    private final MenuManagerServer manager;
    private final SubMenuItem root;
    private final AtomicReference<AuthStatus> latestAuthStatus = new AtomicReference<AuthStatus>(AuthStatus.NOT_STARTED);
    private final BooleanMenuItem statusItem;
    private final AtomicBoolean bootInProgress = new AtomicBoolean(false);

    public MenuInMenu(RemoteConnector remoteConnector, MenuManagerServer manager, MenuItem root, ReplicationMode mode, int offsetRange, int maxRange) {
        this.offsetRange = offsetRange;
        this.maxRange = maxRange;
        this.remoteConnector = remoteConnector;
        this.manager = manager;
        this.replicationMode = mode;
        SubMenuItem subMenuItem = this.root = root instanceof SubMenuItem ? (SubMenuItem)root : MenuTree.ROOT;
        if (this.replicationMode == ReplicationMode.REPLICATE_ADD_STATUS_ITEM) {
            this.statusItem = ((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withId(offsetRange + maxRange - 1)).withName(root.getName() + " connected")).withEepromAddr(-1)).withReadOnly(true)).menuItem();
            manager.getManagedMenu().addMenuItem(MenuItemHelper.asSubMenu(root), this.statusItem);
            MenuItemHelper.setMenuState(this.statusItem, false, manager.getManagedMenu());
            manager.treeStructurallyChanged(root);
        } else {
            this.statusItem = null;
        }
    }

    public void start() {
        this.manager.addMenuManagerListener(new MenuInMenuManagerListener());
        this.remoteConnector.registerConnectorListener(this::processIncomingCommand);
        this.remoteConnector.registerConnectionChangeListener((connector, authStatus) -> {
            this.latestAuthStatus.set(authStatus);
            this.updateStatusItemIfPresent(false);
        });
        this.remoteConnector.start();
    }

    private void updateStatusItemIfPresent(boolean state) {
        if (this.statusItem != null) {
            this.manager.updateMenuItem(this, this.statusItem, state);
        }
    }

    private void processIncomingCommand(RemoteConnector remoteConnector, MenuCommand menuCommand) {
        if (menuCommand instanceof BootItemMenuCommand) {
            BootItemMenuCommand boot = (BootItemMenuCommand)menuCommand;
            Object item = boot.getMenuItem();
            if (((MenuItem)item).getId() != MenuTree.ROOT.getId()) {
                MenuItemBuilder itemBuilder = MenuItemHelper.builderWithExisting(item);
                Object changedItem = ((MenuItemBuilder)((MenuItemBuilder)itemBuilder.withId(((MenuItem)item).getId() + this.offsetRange)).withEepromAddr(-1)).menuItem();
                int modifiedParentId = boot.getSubMenuId() != 0 ? boot.getSubMenuId() + this.offsetRange : this.root.getId();
                MenuItem parent = (MenuItem)this.manager.getManagedMenu().getMenuById(modifiedParentId).orElseThrow();
                this.manager.getManagedMenu().addMenuItem(MenuItemHelper.asSubMenu(parent), (MenuItem)changedItem);
                if (this.isItemAdjustable((MenuItem)changedItem)) {
                    this.manager.updateMenuItem(remoteConnector, (MenuItem)changedItem, boot.getCurrentValue());
                }
                if (this.replicationMode != ReplicationMode.REPLICATE_SILENTLY) {
                    this.manager.treeStructurallyChanged(this.root);
                }
            }
        } else if (menuCommand instanceof MenuChangeCommand) {
            MenuChangeCommand change = (MenuChangeCommand)menuCommand;
            MenuItem item = (MenuItem)this.manager.getManagedMenu().getMenuById(change.getMenuItemId() + this.offsetRange).orElseThrow();
            boolean isListChange = change.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE_LIST;
            this.manager.updateMenuItem(remoteConnector, item, isListChange ? change.getValues() : change.getValue());
        } else if (menuCommand instanceof MenuBootstrapCommand) {
            MenuBootstrapCommand bootstrap = (MenuBootstrapCommand)menuCommand;
            this.bootInProgress.set(bootstrap.getBootType() == MenuBootstrapCommand.BootType.START);
            this.updateStatusItemIfPresent(bootstrap.getBootType() == MenuBootstrapCommand.BootType.END);
            if (bootstrap.getBootType() == MenuBootstrapCommand.BootType.END && this.replicationMode != ReplicationMode.REPLICATE_SILENTLY) {
                this.manager.treeStructurallyChanged(this.root);
            }
        } else if (menuCommand instanceof MenuDialogCommand) {
            MenuDialogCommand dlg = (MenuDialogCommand)menuCommand;
            this.manager.getDialogManager().updateStateFromCommand(menuCommand);
            if (dlg.getDialogMode() == DialogMode.SHOW) {
                this.manager.getDialogManager().withDelegate(DialogShowMode.LOCAL_TO_DELEGATE, btn -> {
                    try {
                        remoteConnector.sendMenuCommand(new MenuDialogCommand(DialogMode.ACTION, "", "", (MenuButtonType)((Object)btn), MenuButtonType.NONE, CorrelationId.EMPTY_CORRELATION));
                    }
                    catch (IOException e) {
                        this.logger.log(System.Logger.Level.ERROR, "Unable to send dialog action " + String.valueOf(btn), (Throwable)e);
                    }
                    return true;
                });
            }
        }
    }

    private boolean isItemAdjustable(MenuItem item) {
        return !(item instanceof SubMenuItem) && !(item instanceof ActionMenuItem);
    }

    public AuthStatus getCurrentStatus() {
        return this.latestAuthStatus.get();
    }

    private boolean isWithinRange(MenuItem item) {
        return item.getId() >= this.offsetRange && item.getId() < this.offsetRange + this.maxRange - 10;
    }

    public static enum ReplicationMode {
        REPLICATE_SILENTLY,
        REPLICATE_NOTIFY,
        REPLICATE_ADD_STATUS_ITEM;

    }

    private class MenuInMenuManagerListener
    implements MenuManagerListener {
        private MenuInMenuManagerListener() {
        }

        @Override
        public void menuItemHasChanged(Object sender, MenuItem item) {
            if (MenuInMenu.this.isWithinRange(item) && sender != MenuInMenu.this && sender != MenuInMenu.this.remoteConnector && MenuInMenu.this.remoteConnector.isDeviceConnected()) {
                try {
                    Object state = MenuItemHelper.getValueFor(item, MenuInMenu.this.manager.getManagedMenu(), MenuItemHelper.getDefaultFor(item));
                    MenuInMenu.this.remoteConnector.sendMenuCommand(CommandFactory.newAbsoluteMenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId() - MenuInMenu.this.offsetRange, state));
                }
                catch (IOException e) {
                    MenuInMenu.this.logger.log(System.Logger.Level.ERROR, MenuInMenu.this.remoteConnector.getConnectionName() + " - failed to send for " + String.valueOf(item), (Throwable)e);
                }
            }
        }

        @Override
        public void managerWillStart() {
        }

        @Override
        public void managerWillStop() {
            MenuInMenu.this.remoteConnector.stop();
        }
    }
}

