/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.mgrclient;

import com.thecoderscorner.menu.mgr.NewServerConnectionListener;
import com.thecoderscorner.menu.mgr.ServerConnection;
import com.thecoderscorner.menu.mgr.ServerConnectionManager;
import com.thecoderscorner.menu.mgr.ServerConnectionMode;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.encryption.EncryptionHandlerFactory;
import com.thecoderscorner.menu.remote.encryption.NoEncryptionHandlerFactory;
import com.thecoderscorner.menu.remote.mgrclient.SocketServerConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ClientBasedConnectionManager
implements ServerConnectionManager {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final AtomicReference<SocketServerConnection> serverConnection = new AtomicReference();
    private final AtomicReference<NewServerConnectionListener> listener = new AtomicReference();
    private final String host;
    private final int port;
    private final MenuCommandProtocol protocol;
    private final Clock clock;
    private final ScheduledExecutorService executorService;
    private final EncryptionHandlerFactory encryptionFactory;
    private volatile Future<?> connectionTask;

    public ClientBasedConnectionManager(String host, int port, MenuCommandProtocol protocol, Clock clock, ScheduledExecutorService executorService) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.clock = clock;
        this.executorService = executorService;
        this.encryptionFactory = new NoEncryptionHandlerFactory();
    }

    public ClientBasedConnectionManager(String host, int port, MenuCommandProtocol protocol, Clock clock, ScheduledExecutorService executorService, EncryptionHandlerFactory factory) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.clock = clock;
        this.executorService = executorService;
        this.encryptionFactory = factory;
    }

    @Override
    public List<ServerConnection> getServerConnections() {
        SocketServerConnection sc = this.serverConnection.get();
        return sc != null ? List.of(sc) : List.of();
    }

    @Override
    public void start(NewServerConnectionListener listener) {
        this.listener.set(listener);
        this.serverConnection.set(null);
        this.connectionTask = this.executorService.scheduleAtFixedRate(this::handleClientConnection, 0L, 2500L, TimeUnit.MILLISECONDS);
    }

    private void handleClientConnection() {
        SocketServerConnection sc = this.serverConnection.get();
        if (sc != null && sc.getConnectionMode() == ServerConnectionMode.DISCONNECTED) {
            sc = null;
        }
        if (sc != null) {
            return;
        }
        try {
            this.logger.log(System.Logger.Level.INFO, "Connecting to " + this.host + ":" + this.port);
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.host, this.port), 5000);
            SocketServerConnection connection = new SocketServerConnection(socket, this.protocol, this.clock, this.encryptionFactory.create(), 1500);
            this.serverConnection.set(connection);
            this.listener.get().connectionCreated(connection);
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Failed to connect to " + this.host + ":" + this.port, (Throwable)e);
        }
    }

    @Override
    public void stop() throws Exception {
        this.connectionTask.cancel(true);
        SocketServerConnection sc = this.serverConnection.get();
        if (sc != null) {
            sc.closeConnection();
        }
        this.serverConnection.set(null);
    }
}

