/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.protocol.CommandProtocol;
import com.thecoderscorner.menu.remote.protocol.MessageField;
import com.thecoderscorner.menu.remote.protocol.ProtocolOutgoingMsgConverter;
import com.thecoderscorner.menu.remote.protocol.RawProtocolIncomingMsgConverter;
import com.thecoderscorner.menu.remote.protocol.TagValMenuCommandProcessors;
import com.thecoderscorner.menu.remote.protocol.TagValProtocolIncomingMsgConverter;
import com.thecoderscorner.menu.remote.protocol.TagValTextParser;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import com.thecoderscorner.menu.remote.protocol.TcUnknownMessageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class ConfigurableProtocolConverter
implements MenuCommandProtocol {
    private static final boolean DEBUG_ALL_MESSAGES = false;
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final Map<MessageField, TagValProtocolIncomingMsgConverter> tagValIncomingParsers = new HashMap<MessageField, TagValProtocolIncomingMsgConverter>(128);
    private final Map<MessageField, OutputMsgConverterWithType<? extends MenuCommand, StringBuilder>> tagValOutputWriters = new HashMap<MessageField, OutputMsgConverterWithType<? extends MenuCommand, StringBuilder>>(128);
    private final Map<MessageField, RawProtocolIncomingMsgConverter> rawIncomingParsers = new HashMap<MessageField, RawProtocolIncomingMsgConverter>();
    private final Map<MessageField, OutputMsgConverterWithType<? extends MenuCommand, ByteBuffer>> rawOutputWriters = new HashMap<MessageField, OutputMsgConverterWithType<? extends MenuCommand, ByteBuffer>>();

    public ConfigurableProtocolConverter(boolean includeDefaultProcessors) {
        if (includeDefaultProcessors) {
            TagValMenuCommandProcessors tagValProcessors = new TagValMenuCommandProcessors();
            tagValProcessors.addHandlersToProtocol(this);
        }
    }

    public void addTagValInProcessor(MessageField field, TagValProtocolIncomingMsgConverter processor) {
        this.tagValIncomingParsers.put(field, processor);
    }

    public <T extends MenuCommand> void addTagValOutProcessor(MessageField field, ProtocolOutgoingMsgConverter<T, StringBuilder> processor, Class<T> clazz) {
        this.tagValOutputWriters.put(field, new OutputMsgConverterWithType<T, StringBuilder>(processor, clazz));
    }

    public void addRawInProcessor(MessageField field, RawProtocolIncomingMsgConverter processor) {
        this.rawIncomingParsers.put(field, processor);
    }

    public <T extends MenuCommand> void addRawOutProcessor(MessageField field, ProtocolOutgoingMsgConverter<T, ByteBuffer> processor, Class<T> clazz) {
        this.rawOutputWriters.put(field, new OutputMsgConverterWithType<T, ByteBuffer>(processor, clazz));
    }

    @Override
    public MenuCommand fromChannel(ByteBuffer buffer) throws IOException {
        byte protoId = buffer.get();
        CommandProtocol protocol = CommandProtocol.fromProtocolId(protoId);
        String ty = this.getMsgTypeFromBuffer(buffer);
        MessageField cmdType = MessageField.fromId(ty);
        if (cmdType == null) {
            throw new TcUnknownMessageException("Received unexpected message: " + ty);
        }
        if (protocol == CommandProtocol.TAG_VAL_PROTOCOL && this.tagValIncomingParsers.containsKey(cmdType)) {
            TagValTextParser parser = new TagValTextParser(buffer);
            return this.tagValIncomingParsers.get(cmdType).apply(parser);
        }
        if (protocol == CommandProtocol.RAW_BIN_PROTOCOL && this.rawIncomingParsers.containsKey(cmdType)) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            short len = buffer.getShort();
            return this.rawIncomingParsers.get(cmdType).apply(buffer, len);
        }
        throw new TcProtocolException("Unknown protocol used in message" + String.valueOf((Object)protocol));
    }

    @Override
    public void toChannel(ByteBuffer buffer, MenuCommand cmd) throws TcProtocolException {
        OutputMsgConverterWithType<? extends MenuCommand, ByteBuffer> rawProcessor = this.rawOutputWriters.get(cmd.getCommandType());
        if (rawProcessor != null) {
            this.writeStandardHeader(buffer, cmd, CommandProtocol.RAW_BIN_PROTOCOL);
            rawProcessor.apply(buffer, cmd);
        } else if (this.tagValOutputWriters.containsKey(cmd.getCommandType())) {
            OutputMsgConverterWithType<? extends MenuCommand, StringBuilder> tagWriter = this.tagValOutputWriters.get(cmd.getCommandType());
            this.writeStandardHeader(buffer, cmd, CommandProtocol.TAG_VAL_PROTOCOL);
            StringBuilder sb = new StringBuilder(256);
            tagWriter.apply(sb, cmd);
            buffer.put(sb.toString().getBytes(StandardCharsets.UTF_8));
            buffer.put((byte)2);
        } else {
            throw new TcProtocolException("Message not processed" + String.valueOf(cmd.getCommandType()));
        }
    }

    @Override
    public CommandProtocol getProtocolForCmd(MenuCommand command) {
        return this.tagValOutputWriters.containsKey(command.getCommandType()) ? CommandProtocol.TAG_VAL_PROTOCOL : CommandProtocol.RAW_BIN_PROTOCOL;
    }

    private void writeStandardHeader(ByteBuffer buffer, MenuCommand cmd, CommandProtocol protocol) {
        buffer.put((byte)1);
        buffer.put(protocol.getProtoNum());
        buffer.put((byte)cmd.getCommandType().getHigh());
        buffer.put((byte)cmd.getCommandType().getLow());
    }

    private String getMsgTypeFromBuffer(ByteBuffer buffer) {
        return String.valueOf((char)buffer.get()) + (char)buffer.get();
    }

    private static class OutputMsgConverterWithType<T extends MenuCommand, B> {
        private final ProtocolOutgoingMsgConverter<T, B> converter;
        private final Class<T> theClazz;

        public OutputMsgConverterWithType(ProtocolOutgoingMsgConverter<T, B> converter, Class<T> theClazz) {
            this.converter = converter;
            this.theClazz = theClazz;
        }

        void apply(B buffer, MenuCommand cmd) throws TcProtocolException {
            if (!cmd.getClass().equals(this.theClazz)) {
                throw new IllegalArgumentException("Wrong type of command provided");
            }
            this.converter.apply(buffer, cmd);
        }
    }
}

