/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class TagValTextParser {
    public static final char FIELD_TERMINATOR = '|';
    private static final int MAX_FIELD_EXPECTED = 256;
    private final Map<String, String> keyToValue = new HashMap<String, String>(32);

    public TagValTextParser(ByteBuffer buffer) throws IOException {
        boolean foundEnd = false;
        while (buffer.hasRemaining() && !foundEnd) {
            String key = this.readString(buffer);
            if (key.isEmpty()) {
                throw new TcProtocolException("Key is empty in protocol");
            }
            if (key.charAt(0) == '\u0002') {
                foundEnd = true;
                continue;
            }
            String value = this.readString(buffer);
            if (!value.isEmpty() && value.charAt(0) == '\u0002') {
                foundEnd = true;
            }
            this.keyToValue.put(key, value);
        }
    }

    private String readString(ByteBuffer buffer) {
        byte[] rawData = new byte[256];
        int position = 0;
        while (buffer.hasRemaining() && position < 256) {
            byte by = buffer.get();
            if (by == 2) {
                return "\u0002";
            }
            if (by == 92) {
                rawData[position++] = buffer.get();
                continue;
            }
            if (by == 61 || by == 124) {
                return new String(rawData, 0, position);
            }
            rawData[position++] = by;
        }
        return new String(rawData, 0, position);
    }

    public String getValue(String keyMsgType) throws TcProtocolException {
        if (this.keyToValue.containsKey(keyMsgType)) {
            return this.keyToValue.get(keyMsgType);
        }
        throw new TcProtocolException("Key " + keyMsgType + " doesn't exist in " + String.valueOf(this.keyToValue));
    }

    public String getValueWithDefault(String keyMsgType, String defaultVal) {
        return this.keyToValue.getOrDefault(keyMsgType, defaultVal);
    }

    public int getValueAsInt(String keyIdField) throws TcProtocolException {
        return Integer.parseInt(this.getValue(keyIdField));
    }

    public int getValueAsIntWithDefault(String keyIdField, int defaultVal) throws TcProtocolException {
        if (this.keyToValue.containsKey(keyIdField)) {
            return Integer.parseInt(this.getValue(keyIdField));
        }
        return defaultVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        this.keyToValue.forEach((k, v) -> sb.append("[Key='").append((String)k).append("', val='").append((String)v).append("'] "));
        return sb.toString();
    }
}

