/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.encryption.EncryptionHandlerFactory;
import com.thecoderscorner.menu.remote.socket.SocketClientRemoteConnector;
import com.thecoderscorner.menu.remote.socket.SocketClientServerListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;

public class SocketClientRemoteServer {
    private final System.Logger logger = System.getLogger(SocketClientRemoteServer.class.getSimpleName());
    private final int port;
    private final LocalIdentifier localId;
    private final ScheduledExecutorService executor;
    private final MenuCommandProtocol protocol;
    private final Clock clock;
    private final EncryptionHandlerFactory encryptionFactory;
    private final Semaphore connectionSemaphore;
    private final Map<UuidAndSerial, SocketClientRemoteConnector> mapOfConnections = new ConcurrentHashMap<UuidAndSerial, SocketClientRemoteConnector>();
    private final List<SocketClientServerListener> connectionListeners = new CopyOnWriteArrayList<SocketClientServerListener>();
    private volatile Thread connectionThread;
    private volatile ServerSocketChannel serverSocket = null;

    protected SocketClientRemoteServer(int port, LocalIdentifier localId, ScheduledExecutorService executor, MenuCommandProtocol protocol, Clock clock, EncryptionHandlerFactory encryptionFactory, int maximumInstances) {
        this.port = port;
        this.localId = localId;
        this.executor = executor;
        this.protocol = protocol;
        this.clock = clock;
        this.encryptionFactory = encryptionFactory;
        this.connectionSemaphore = new Semaphore(maximumInstances);
    }

    public void addConnectionListener(SocketClientServerListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(SocketClientServerListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void start() throws IOException {
        this.serverSocket = ServerSocketChannel.open();
        this.serverSocket.configureBlocking(true);
        this.serverSocket.socket().bind(new InetSocketAddress(3333));
        this.connectionThread = new Thread(this::acceptConnections);
        this.connectionThread.start();
    }

    public void stop() throws IOException {
        this.connectionThread.interrupt();
        try {
            this.logger.log(System.Logger.Level.INFO, "Closing server connection " + this.port);
            this.connectionThread.join(3000L);
            this.serverSocket.close();
            for (Map.Entry<UuidAndSerial, SocketClientRemoteConnector> entry : this.mapOfConnections.entrySet()) {
                this.logger.log(System.Logger.Level.INFO, "Closing client connection to " + String.valueOf(entry.getKey()));
                entry.getValue().close();
            }
            this.connectionThread = null;
        }
        catch (InterruptedException e) {
            this.logger.log(System.Logger.Level.INFO, "Interrupted during thread exit", (Throwable)e);
        }
    }

    private void acceptConnections() {
        this.logger.log(System.Logger.Level.INFO, "Start accept thread");
        while (!Thread.currentThread().isInterrupted()) {
            AbstractInterruptibleChannel sock = null;
            try {
                this.connectionSemaphore.acquire();
                this.logger.log(System.Logger.Level.INFO, "Attempting to accept client connection on port: " + this.port);
                sock = this.serverSocket.accept();
                this.logger.log(System.Logger.Level.INFO, "Accepted client " + String.valueOf(((SocketChannel)sock).getRemoteAddress()));
                SocketClientRemoteConnector connector = new SocketClientRemoteConnector(this.localId, this.executor, this.clock, this.protocol, (SocketChannel)sock, this::onConnectionClose, this.encryptionFactory.create());
                UuidAndSerial uuidSerial = UuidAndSerial.fromRemote(connector.getRemoteParty());
                this.mapOfConnections.put(uuidSerial, connector);
                for (SocketClientServerListener listener : this.connectionListeners) {
                    listener.onConnectionCreated(connector);
                }
            }
            catch (Exception e) {
                this.connectionSemaphore.release();
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException ex) {
                        this.logger.log(System.Logger.Level.ERROR, "Error closing socket", (Throwable)ex);
                    }
                }
                this.logger.log(System.Logger.Level.ERROR, "Exception during accept", (Throwable)e);
            }
        }
        this.logger.log(System.Logger.Level.INFO, "End accept thread");
    }

    private void onConnectionClose(SocketClientRemoteConnector conn) {
        this.connectionSemaphore.release();
        for (SocketClientServerListener listener : this.connectionListeners) {
            listener.onConnectionClosed(conn);
        }
        UuidAndSerial uuidAndSerial = UuidAndSerial.fromRemote(conn.getRemoteParty());
        this.mapOfConnections.remove(uuidAndSerial);
    }

    public Optional<SocketClientRemoteConnector> getFirstConnectionWithUUID(UUID connectionId) {
        return this.mapOfConnections.entrySet().stream().filter(es -> ((UuidAndSerial)es.getKey()).getUuid().equals(connectionId)).map(Map.Entry::getValue).findFirst();
    }

    public Optional<SocketClientRemoteConnector> getConnection(UUID connectionId, long serialNumber) {
        return Optional.ofNullable(this.mapOfConnections.get(new UuidAndSerial(connectionId, serialNumber)));
    }

    public List<SocketClientRemoteConnector> getConnections() {
        return List.copyOf(this.mapOfConnections.values());
    }

    public static class UuidAndSerial {
        private final UUID uuid;
        private final long serial;

        private UuidAndSerial(UUID uuid, long serial) {
            this.uuid = uuid;
            this.serial = serial;
        }

        public static UuidAndSerial fromRemote(RemoteInformation remoteParty) {
            return new UuidAndSerial(remoteParty.getUuid(), remoteParty.getSerialNumber());
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public long getSerial() {
            return this.serial;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UuidAndSerial)) {
                return false;
            }
            UuidAndSerial that = (UuidAndSerial)o;
            return this.serial == that.serial && Objects.equals(this.uuid, that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.serial);
        }
    }
}

