/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs;

import com.tupilabs.pbs.model.Job;
import com.tupilabs.pbs.model.Node;
import com.tupilabs.pbs.model.Queue;
import com.tupilabs.pbs.parser.NodeXmlParser;
import com.tupilabs.pbs.parser.ParseException;
import com.tupilabs.pbs.parser.QstatJobsParser;
import com.tupilabs.pbs.parser.QstatQueuesParser;
import com.tupilabs.pbs.util.PBSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBS {
    private static final Logger LOGGER = Logger.getLogger(PBS.class.getName());
    private static final String COMMAND_QNODES = "qnodes";
    private static final String PARAMETER_XML = "-x";
    private static final String COMMAND_QSTAT = "qstat";
    private static final String PARAMETER_FULL_STATUS = "-f";
    private static final String PARAMETER_QUEUE = "-Q";
    private static final NodeXmlParser NODE_XML_PARSER = new NodeXmlParser();
    private static final QstatQueuesParser QSTAT_QUEUES_PARSER = new QstatQueuesParser();
    private static final QstatJobsParser QSTAT_JOBS_PARSER = new QstatJobsParser();
    private static final int DEFAULT_TIMEOUT = 60000;

    public static List<Node> qnodes() {
        return PBS.qnodes(null);
    }

    public static List<Node> qnodes(String name) {
        List<Node> nodes;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QNODES);
        cmdLine.addArgument(PARAMETER_XML);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qnodes exit value: " + exitValue);
        try {
            nodes = NODE_XML_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse node XML: " + pe.getMessage(), pe);
        }
        return nodes;
    }

    public static List<Queue> qstatQueues() {
        return PBS.qstatQueues(null);
    }

    public static List<Queue> qstatQueues(String name) {
        ArrayList queues;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSTAT);
        cmdLine.addArgument(PARAMETER_FULL_STATUS);
        cmdLine.addArgument(PARAMETER_QUEUE);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qstat exit value: " + exitValue);
        try {
            queues = QSTAT_QUEUES_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse qstat queues output: " + pe.getMessage(), pe);
        }
        return queues == null ? new ArrayList(0) : queues;
    }

    public static List<Job> qstat() {
        return PBS.qstat((String)null);
    }

    public static List<Job> qstat(Queue queue) {
        return PBS.qstat(queue.getName());
    }

    public static List<Job> qstat(Job job) {
        return PBS.qstat(job.getName());
    }

    public static List<Job> qstat(String name) {
        ArrayList jobs;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSTAT);
        cmdLine.addArgument(PARAMETER_FULL_STATUS);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qstat exit value: " + exitValue);
        try {
            jobs = QSTAT_JOBS_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse qstat jobs output: " + pe.getMessage(), pe);
        }
        return jobs == null ? new ArrayList(0) : jobs;
    }

    static DefaultExecuteResultHandler execute(CommandLine cmdLine, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        PumpStreamHandler streamHandler = new PumpStreamHandler(out, err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        return resultHandler;
    }
}

