/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs.parser;

import com.tupilabs.pbs.model.Job;
import com.tupilabs.pbs.model.Node;
import com.tupilabs.pbs.model.QueueState;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeXmlHandler
extends DefaultHandler {
    private List<Node> nodes;
    private Node node;
    private String name;
    private String state;
    private int np;
    private String properties;
    private String ntype;
    private String status;
    private String jobs;
    private boolean isName = false;
    private boolean isState = false;
    private boolean isNp = false;
    private boolean isProperties = false;
    private boolean isNtype = false;
    private boolean isStatus = false;
    private boolean isJobs = false;

    @Override
    public void startDocument() throws SAXException {
        this.nodes = new LinkedList<Node>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("name".equals(qName)) {
            this.isName = true;
        } else if ("state".equals(qName)) {
            this.isState = true;
        } else if ("np".equals(qName)) {
            this.isNp = true;
        } else if ("properties".equals(qName)) {
            this.isProperties = true;
        } else if ("ntype".equals(qName)) {
            this.isNtype = true;
        } else if ("status".equals(qName)) {
            this.isStatus = true;
        } else if ("jobs".equals(qName)) {
            this.isJobs = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (this.isName) {
            this.name = text;
            this.isName = false;
        } else if (this.isState) {
            this.state = text;
            this.isState = false;
        } else if (this.isNp) {
            this.np = Integer.parseInt(text);
            this.isNp = false;
        } else if (this.isProperties) {
            this.properties = text;
            this.isProperties = false;
        } else if (this.isNtype) {
            this.ntype = text;
            this.isNtype = false;
        } else if (this.isStatus) {
            this.status = text;
            this.isStatus = false;
        } else if (this.isJobs) {
            this.jobs = text;
            this.isJobs = false;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Node".equals(qName)) {
            String[] temp;
            this.node = new Node(this.name, this.np, this.ntype, QueueState.fromString(this.state));
            if (StringUtils.isNotBlank((String)this.properties)) {
                String[] props;
                for (String prop : props = this.properties.split(",")) {
                    this.node.getProperties().add(prop);
                }
            }
            if (StringUtils.isNotBlank((String)this.status)) {
                String[] statuses;
                for (String statuss : statuses = this.status.split(",")) {
                    if (statuss.indexOf(61) <= 0 || (temp = statuss.split("=")).length != 2) continue;
                    this.node.getStatus().put(temp[0].trim(), temp[1].trim());
                }
            }
            if (StringUtils.isNotBlank((String)this.jobs)) {
                String[] jobses;
                for (String jobss : jobses = this.jobs.split(",")) {
                    if (jobss.indexOf(47) <= 0 || (temp = jobss.split("/")).length != 2) continue;
                    int index = Integer.parseInt(temp[0].trim());
                    String name = temp[1];
                    Job job = new Job();
                    job.setQueueIndex(index);
                    job.setName(name);
                    this.node.getJobs().add(job);
                }
            }
            this.nodes.add(this.node);
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }
}

