/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs.parser;

import com.tupilabs.pbs.model.Job;
import com.tupilabs.pbs.parser.ParseException;
import com.tupilabs.pbs.parser.Parser;
import com.tupilabs.pbs.util.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QstatJobsParser
implements Parser<String, List<Job>> {
    private static final Logger LOGGER = Logger.getLogger(QstatJobsParser.class.getName());
    private static final String REGEX_JOB = "(?i)job\\s+(?i)i(?i)d:(.*)";
    private static final Pattern PATTERN_JOB = Pattern.compile("(?i)job\\s+(?i)i(?i)d:(.*)");
    private static final String CHAR_EQUALS = "=";

    @Override
    public List<Job> parse(String text) throws ParseException {
        if (StringUtils.isNotBlank((String)text)) {
            LinkedList<Job> jobs = new LinkedList<Job>();
            String separator = "\n";
            if (text.indexOf("\r\n") > 0) {
                separator = "\r\n";
            }
            String[] lines = text.split(separator);
            Job job = null;
            for (String line : lines) {
                String[] temp;
                Matcher matcher = PATTERN_JOB.matcher(line);
                if (matcher.matches()) {
                    if (job != null) {
                        jobs.add(job);
                    }
                    job = new Job();
                    String id = matcher.group(1);
                    job.setId(id);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)line) || (temp = Utils.splitFirst(line, CHAR_EQUALS)).length != 2) continue;
                String key = temp[0].trim().toLowerCase();
                String value = temp[1].trim();
                if ("job_name".equals(key)) {
                    job.setName(value);
                    continue;
                }
                if ("job_owner".equals(key)) {
                    job.setOwner(value);
                    continue;
                }
                if (key.startsWith("resources_used.")) {
                    job.getResourcesUsed().put(key, value);
                    continue;
                }
                if ("job_state".equals(key)) {
                    job.setState(value);
                    continue;
                }
                if ("queue".equals(key)) {
                    job.setQueue(value);
                    continue;
                }
                if ("server".equals(key)) {
                    job.setServer(value);
                    continue;
                }
                if ("checkpoint".equals(key)) {
                    job.setCheckpoint(value);
                    continue;
                }
                if ("ctime".equals(key)) {
                    job.setCtime(value);
                    continue;
                }
                if ("error_path".equals(key)) {
                    job.setErrorPath(value);
                    continue;
                }
                if ("exec_host".equals(key)) {
                    job.setExecHost(value);
                    continue;
                }
                if ("exec_port".equals(key)) {
                    try {
                        job.setExecPort(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job exec port: " + nfe.getMessage(), nfe);
                        job.setExecPort(-1);
                    }
                    continue;
                }
                if ("hold_types".equals(key)) {
                    job.setHoldTypes(value);
                    continue;
                }
                if ("join_path".equals(key)) {
                    job.setJoinPath(value);
                    continue;
                }
                if ("keep_files".equals(key)) {
                    job.setKeepFiles(value);
                    continue;
                }
                if ("mail_points".equals(key)) {
                    job.setMailPoints(value);
                    continue;
                }
                if ("mail_users".equals(key)) {
                    job.setMailUsers(value);
                    continue;
                }
                if ("mtime".equals(key)) {
                    job.setMtime(value);
                    continue;
                }
                if ("output_path".equals(key)) {
                    job.setOutputPath(value);
                    continue;
                }
                if ("priority".equals(key)) {
                    try {
                        job.setPriority(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job priority: " + nfe.getMessage(), nfe);
                        job.setPriority(-1);
                    }
                    continue;
                }
                if ("qtime".equals(key)) {
                    job.setQtime(value);
                    continue;
                }
                if ("rerunable".equals(key)) {
                    job.setRerunable(Boolean.parseBoolean(value));
                    continue;
                }
                if (key.startsWith("resource_list.")) {
                    job.getResourceList().put(key, value);
                    continue;
                }
                if ("session_id".equals(key)) {
                    try {
                        job.setSessionId(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job session id: " + nfe.getMessage(), nfe);
                        job.setSessionId(-1);
                    }
                    continue;
                }
                if ("substate".equals(key)) {
                    try {
                        job.setSubstate(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job substate: " + nfe.getMessage(), nfe);
                        job.setSubstate(-1);
                    }
                    continue;
                }
                if (key.startsWith("variable_list")) {
                    job.getVariableList().put(key, value);
                    continue;
                }
                if ("etime".equals(key)) {
                    job.setEtime(value);
                    continue;
                }
                if ("euser".equals(key)) {
                    job.setEuser(value);
                    continue;
                }
                if ("egroup".equals(key)) {
                    job.setEgroup(value);
                    continue;
                }
                if ("hashname".equals(key)) {
                    job.setHashName(value);
                    continue;
                }
                if ("queue_rank".equals(key)) {
                    try {
                        job.setQueueRank(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job queue rank: " + nfe.getMessage(), nfe);
                        job.setQueueRank(-1);
                    }
                    continue;
                }
                if ("queue_type".equals(key)) {
                    job.setQueueType(value);
                    continue;
                }
                if ("comment".equals(key)) {
                    job.setComment(value);
                    continue;
                }
                if ("submit_args".equals(key)) {
                    job.setSubmitArgs(value);
                    continue;
                }
                if ("submit_host".equals(key)) {
                    job.setSubmitHost(value);
                    continue;
                }
                if ("start_time".equals(key)) {
                    job.setStartTime(value);
                    continue;
                }
                if ("start_count".equals(key)) {
                    try {
                        job.setStartCount(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job start count: " + nfe.getMessage(), nfe);
                        job.setStartCount(-1);
                    }
                    continue;
                }
                if ("fault_tolerant".equals(key)) {
                    job.setFaultTolerant(Boolean.parseBoolean(value));
                    continue;
                }
                if ("job_radix".equals(key)) {
                    try {
                        job.setRadix(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job radix: " + nfe.getMessage(), nfe);
                        job.setRadix(-1);
                    }
                    continue;
                }
                if (!"walltime.remaining".equals(key)) continue;
                try {
                    job.setWalltimeRemaining(Long.parseLong(value));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.WARNING, "Failed parsing job walltime remaining: " + nfe.getMessage(), nfe);
                    job.setWalltimeRemaining(-1L);
                }
            }
            if (job != null) {
                jobs.add(job);
            }
            return jobs;
        }
        return Collections.emptyList();
    }
}

