/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs.parser;

import com.tupilabs.pbs.model.Queue;
import com.tupilabs.pbs.parser.ParseException;
import com.tupilabs.pbs.parser.Parser;
import com.tupilabs.pbs.util.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class QstatQueuesParser
implements Parser<String, List<Queue>> {
    private static final Logger LOGGER = Logger.getLogger(QstatQueuesParser.class.getName());
    private static final String REGEX_QUEUE = "(?i)queue:(.*)";
    private static final Pattern PATTERN_QUEUE = Pattern.compile("(?i)queue:(.*)");
    private static final String CHAR_EQUALS = "=";

    @Override
    public List<Queue> parse(String text) throws ParseException {
        if (StringUtils.isNotBlank((String)text)) {
            LinkedList<Queue> queues = new LinkedList<Queue>();
            String separator = "\n";
            if (text.indexOf("\r\n") > 0) {
                separator = "\r\n";
            }
            String[] lines = text.split(separator);
            Queue queue = null;
            for (String line : lines) {
                String[] temp;
                Matcher matcher = PATTERN_QUEUE.matcher(line);
                if (matcher.matches()) {
                    if (queue != null) {
                        queues.add(queue);
                    }
                    queue = new Queue();
                    String name = matcher.group(1);
                    queue.setName(name);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)line) || (temp = Utils.splitFirst(line, CHAR_EQUALS)).length != 2) continue;
                String key = temp[0].trim().toLowerCase();
                String value = temp[1].trim();
                if ("queue_type".equals(key)) {
                    queue.setQueueType(value);
                    continue;
                }
                if ("priority".equals(key)) {
                    try {
                        queue.setPriority(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing queue priority: " + nfe.getMessage(), nfe);
                        queue.setPriority(-1);
                    }
                    continue;
                }
                if ("total_jobs".equals(key)) {
                    try {
                        queue.setTotalJobs(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing queue total jobs: " + nfe.getMessage(), nfe);
                        queue.setPriority(-1);
                    }
                    continue;
                }
                if ("state_count".equals(key)) {
                    queue.setStateCount(value);
                    continue;
                }
                if ("mtime".equals(key)) {
                    queue.setMtime(value);
                    continue;
                }
                if ("max_user_run".equals(key)) {
                    try {
                        queue.setMaxUserRun(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing queue max user run: " + nfe.getMessage(), nfe);
                        queue.setPriority(-1);
                    }
                    continue;
                }
                if ("enabled".equals(key)) {
                    queue.setEnabled(Boolean.parseBoolean(value));
                    continue;
                }
                if ("started".equals(key)) {
                    queue.setStarted(Boolean.parseBoolean(value));
                    continue;
                }
                if (key.startsWith("resources_max.")) {
                    queue.getResourcesMax().put(key, value);
                    continue;
                }
                if (key.startsWith("resources_min.")) {
                    queue.getResourcesMin().put(key, value);
                    continue;
                }
                if (key.startsWith("resources_assigned.")) {
                    queue.getResourcesAssigned().put(key, value);
                    continue;
                }
                if (key.startsWith("resources_default.")) {
                    queue.getResourcesDefault().put(key, value);
                    continue;
                }
                LOGGER.info("Unmmaped key, value: " + key + ", " + value);
            }
            if (queue != null) {
                queues.add(queue);
            }
            return queues;
        }
        return Collections.emptyList();
    }
}

