/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs;

import com.tupilabs.pbs.model.Job;
import com.tupilabs.pbs.model.Node;
import com.tupilabs.pbs.model.Queue;
import com.tupilabs.pbs.parser.NodeXmlParser;
import com.tupilabs.pbs.parser.ParseException;
import com.tupilabs.pbs.parser.QstatJobsParser;
import com.tupilabs.pbs.parser.QstatQueuesParser;
import com.tupilabs.pbs.util.CommandOutput;
import com.tupilabs.pbs.util.PBSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.StringUtils;

public class PBS {
    private static final Logger LOGGER = Logger.getLogger(PBS.class.getName());
    private static final String COMMAND_QNODES = "qnodes";
    private static final String COMMAND_QSTAT = "qstat";
    private static final String COMMAND_QDEL = "qdel";
    private static final String COMMAND_QSUB = "qsub";
    private static final String COMMAND_TRACEJOB = "tracejob";
    private static final String PARAMETER_XML = "-x";
    private static final String PARAMETER_FULL_STATUS = "-f";
    private static final String PARAMETER_ARRAY_JOB_STATUS = "-t";
    private static final String PARAMETER_RESOURCE_OVERRIDE_STATUS = "-l";
    private static final String PARAMETER_QUEUE = "-Q";
    private static final String PARAMETER_NUMBER_OF_DAYS = "-n";
    private static final NodeXmlParser NODE_XML_PARSER = new NodeXmlParser();
    private static final QstatQueuesParser QSTAT_QUEUES_PARSER = new QstatQueuesParser();
    private static final QstatJobsParser QSTAT_JOBS_PARSER = new QstatJobsParser();
    private static final int DEFAULT_TIMEOUT = 60000;

    public static List<Node> qnodes() {
        return PBS.qnodes(null);
    }

    public static List<Node> qnodes(String name) {
        List<Node> nodes;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QNODES);
        cmdLine.addArgument(PARAMETER_XML);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qnodes command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qnodes exit value: " + exitValue);
        try {
            nodes = NODE_XML_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse node XML: " + pe.getMessage(), pe);
        }
        return nodes;
    }

    public static List<Queue> qstatQueues() {
        return PBS.qstatQueues(null);
    }

    public static List<Queue> qstatQueues(String name) {
        ArrayList queues;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSTAT);
        cmdLine.addArgument(PARAMETER_FULL_STATUS);
        cmdLine.addArgument(PARAMETER_QUEUE);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qstat exit value: " + exitValue);
        try {
            queues = QSTAT_QUEUES_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse qstat queues output: " + pe.getMessage(), pe);
        }
        return queues == null ? new ArrayList(0) : queues;
    }

    public static List<Job> qstat() {
        return PBS.qstat((String)null);
    }

    public static List<Job> qstat(Queue queue) {
        return PBS.qstat(queue.getName());
    }

    public static List<Job> qstat(Job job) {
        return PBS.qstat(job.getName());
    }

    public static List<Job> qstat(String name) {
        ArrayList jobs;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSTAT);
        cmdLine.addArgument(PARAMETER_FULL_STATUS);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qstat exit value: " + exitValue);
        try {
            jobs = QSTAT_JOBS_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse qstat jobs output: " + pe.getMessage(), pe);
        }
        return jobs == null ? new ArrayList(0) : jobs;
    }

    public static List<Job> qstatArrayJob(String name) {
        ArrayList jobs;
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSTAT);
        cmdLine.addArgument(PARAMETER_FULL_STATUS);
        cmdLine.addArgument(PARAMETER_ARRAY_JOB_STATUS);
        if (StringUtils.isNotBlank((String)name)) {
            cmdLine.addArgument(name);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qstat command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qstat exit value: " + exitValue);
        try {
            jobs = QSTAT_JOBS_PARSER.parse(((Object)out).toString());
        }
        catch (ParseException pe) {
            throw new PBSException("Failed to parse qstat jobs output: " + pe.getMessage(), pe);
        }
        return jobs == null ? new ArrayList(0) : jobs;
    }

    public static void qdel(String jobId) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QDEL);
        cmdLine.addArgument(jobId);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qdel command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qdel command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qdel command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qdel exit value: " + exitValue);
        if (exitValue != 0) {
            throw new PBSException("Failed to delete job " + jobId + ". Error output: " + ((Object)err).toString());
        }
    }

    public static String qsub(String input) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsub(String input, String ... resourceOverrides) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(PARAMETER_RESOURCE_OVERRIDE_STATUS);
        String resourceOverrideArgument = StringUtils.join((Object[])resourceOverrides, (String)",");
        cmdLine.addArgument(resourceOverrideArgument);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsubArrayJob(String input, List<Integer> pbsArrayIDs) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(PARAMETER_ARRAY_JOB_STATUS);
        String listArgument = StringUtils.join(pbsArrayIDs, (String)",");
        cmdLine.addArgument(listArgument);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsub(String[] inputs, Map<String, String> environment) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        for (int i = 0; i < inputs.length; ++i) {
            cmdLine.addArgument(inputs[i]);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, environment, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script with command line '" + cmdLine.toString() + "'. Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsubArrayJob(String input, List<Integer> pbsArrayIDs, String ... resourceOverrides) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(PARAMETER_ARRAY_JOB_STATUS);
        String listArgument = StringUtils.join(pbsArrayIDs, (String)",");
        cmdLine.addArgument(listArgument);
        cmdLine.addArgument(PARAMETER_RESOURCE_OVERRIDE_STATUS);
        String resourceOverrideArgument = StringUtils.join((Object[])resourceOverrides, (String)",");
        cmdLine.addArgument(resourceOverrideArgument);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsubArrayJob(String input, int beginIndex, int endIndex) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(PARAMETER_ARRAY_JOB_STATUS);
        String rangeArgument = beginIndex + "-" + endIndex;
        cmdLine.addArgument(rangeArgument);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static String qsubArrayJob(String input, List<Integer> pbsArrayIDs, int beginIndex, int endIndex) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_QSUB);
        cmdLine.addArgument(PARAMETER_ARRAY_JOB_STATUS);
        String rangeArgument = beginIndex + "-" + endIndex;
        String listArgument = StringUtils.join(pbsArrayIDs, (String)",");
        String combinedArgument = listArgument + "," + rangeArgument;
        cmdLine.addArgument(combinedArgument);
        cmdLine.addArgument(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute qsub command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("qsub exit value: " + exitValue);
        LOGGER.fine("qsub output: " + ((Object)out).toString());
        if (exitValue != 0) {
            throw new PBSException("Failed to submit job script " + input + ". Error output: " + ((Object)err).toString());
        }
        String jobId = ((Object)out).toString();
        return jobId.trim();
    }

    public static CommandOutput traceJob(String jobId, int numberOfDays) {
        DefaultExecuteResultHandler resultHandler;
        CommandLine cmdLine = new CommandLine(COMMAND_TRACEJOB);
        cmdLine.addArgument(PARAMETER_NUMBER_OF_DAYS);
        cmdLine.addArgument(Integer.toString(numberOfDays));
        cmdLine.addArgument(jobId);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            resultHandler = PBS.execute(cmdLine, null, out, err);
            resultHandler.waitFor(60000L);
        }
        catch (ExecuteException e) {
            throw new PBSException("Failed to execute tracejob command: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PBSException("Failed to execute tracejob command: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new PBSException("Failed to execute tracejob command: " + e.getMessage(), e);
        }
        int exitValue = resultHandler.getExitValue();
        LOGGER.info("tracejob exit value: " + exitValue);
        LOGGER.fine("tracejob output: " + ((Object)out).toString());
        return new CommandOutput(((Object)out).toString(), ((Object)err).toString());
    }

    static DefaultExecuteResultHandler execute(CommandLine cmdLine, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        return PBS.execute(cmdLine, Collections.<String, String>emptyMap(), out, err);
    }

    static DefaultExecuteResultHandler execute(CommandLine cmdLine, Map<String, String> environment, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        PumpStreamHandler streamHandler = new PumpStreamHandler(out, err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (environment != null) {
            executor.execute(cmdLine, environment, (ExecuteResultHandler)resultHandler);
        } else {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        }
        return resultHandler;
    }
}

