/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.pbs.parser;

import com.tupilabs.pbs.model.Job;
import com.tupilabs.pbs.parser.ParseException;
import com.tupilabs.pbs.parser.Parser;
import com.tupilabs.pbs.util.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class QstatJobsParser
implements Parser<String, List<Job>> {
    private static final Logger LOGGER = Logger.getLogger(QstatJobsParser.class.getName());
    private static final String REGEX_JOB = "(?i)job\\s+(?i)i(?i)d:(.*)";
    private static final Pattern PATTERN_JOB = Pattern.compile("(?i)job\\s+(?i)i(?i)d:(.*)");
    private static final String CHAR_EQUALS = "=";

    @Override
    public List<Job> parse(String text) throws ParseException {
        if (StringUtils.isNotBlank((String)text)) {
            text = StringUtils.replace((String)text, (String)"\n\t", (String)"");
            LinkedList<Job> jobs = new LinkedList<Job>();
            String separator = "\n";
            if (text.indexOf("\r\n") > 0) {
                separator = "\r\n";
            }
            String[] lines = text.split(separator);
            Job job = null;
            for (String line : lines) {
                String[] temp;
                Matcher matcher = PATTERN_JOB.matcher(line);
                if (matcher.matches()) {
                    if (job != null) {
                        jobs.add(job);
                    }
                    job = new Job();
                    String id = matcher.group(1).trim();
                    job.setId(id);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)line) || (temp = Utils.splitFirst(line, CHAR_EQUALS)).length != 2) continue;
                String key = temp[0].trim().toLowerCase();
                String value = temp[1].trim();
                if ("job_name".equalsIgnoreCase(key)) {
                    job.setName(value);
                    continue;
                }
                if ("job_owner".equalsIgnoreCase(key)) {
                    job.setOwner(value);
                    continue;
                }
                if (key.startsWith("resources_used.")) {
                    job.getResourcesUsed().put(key, value);
                    continue;
                }
                if ("job_state".equalsIgnoreCase(key)) {
                    job.setState(value);
                    continue;
                }
                if ("queue".equalsIgnoreCase(key)) {
                    job.setQueue(value);
                    continue;
                }
                if ("server".equalsIgnoreCase(key)) {
                    job.setServer(value);
                    continue;
                }
                if ("checkpoint".equalsIgnoreCase(key)) {
                    job.setCheckpoint(value);
                    continue;
                }
                if ("ctime".equalsIgnoreCase(key)) {
                    job.setCtime(value);
                    continue;
                }
                if ("error_path".equalsIgnoreCase(key)) {
                    job.setErrorPath(value);
                    continue;
                }
                if ("exec_host".equalsIgnoreCase(key)) {
                    job.setExecHost(value);
                    continue;
                }
                if ("exec_port".equalsIgnoreCase(key)) {
                    try {
                        job.setExecPort(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job exec port: " + nfe.getMessage(), nfe);
                        job.setExecPort(-1);
                    }
                    continue;
                }
                if ("hold_types".equalsIgnoreCase(key)) {
                    job.setHoldTypes(value);
                    continue;
                }
                if ("join_path".equalsIgnoreCase(key)) {
                    job.setJoinPath(value);
                    continue;
                }
                if ("keep_files".equalsIgnoreCase(key)) {
                    job.setKeepFiles(value);
                    continue;
                }
                if ("mail_points".equalsIgnoreCase(key)) {
                    job.setMailPoints(value);
                    continue;
                }
                if ("mail_users".equalsIgnoreCase(key)) {
                    job.setMailUsers(value);
                    continue;
                }
                if ("mtime".equalsIgnoreCase(key)) {
                    job.setMtime(value);
                    continue;
                }
                if ("output_path".equalsIgnoreCase(key)) {
                    job.setOutputPath(value);
                    continue;
                }
                if ("priority".equalsIgnoreCase(key)) {
                    try {
                        job.setPriority(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job priority: " + nfe.getMessage(), nfe);
                        job.setPriority(-1);
                    }
                    continue;
                }
                if ("qtime".equalsIgnoreCase(key)) {
                    job.setQtime(value);
                    continue;
                }
                if ("rerunable".equalsIgnoreCase(key)) {
                    job.setRerunable(Boolean.parseBoolean(value));
                    continue;
                }
                if (key.startsWith("resource_list.")) {
                    job.getResourceList().put(key, value);
                    continue;
                }
                if ("session_id".equalsIgnoreCase(key)) {
                    try {
                        job.setSessionId(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job session id: " + nfe.getMessage(), nfe);
                        job.setSessionId(-1);
                    }
                    continue;
                }
                if ("substate".equalsIgnoreCase(key)) {
                    try {
                        job.setSubstate(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job substate: " + nfe.getMessage(), nfe);
                        job.setSubstate(-1);
                    }
                    continue;
                }
                if (key.startsWith("variable_list")) {
                    job.getVariableList().put(key, value);
                    continue;
                }
                if ("etime".equalsIgnoreCase(key)) {
                    job.setEtime(value);
                    continue;
                }
                if ("euser".equalsIgnoreCase(key)) {
                    job.setEuser(value);
                    continue;
                }
                if ("egroup".equalsIgnoreCase(key)) {
                    job.setEgroup(value);
                    continue;
                }
                if ("hashname".equalsIgnoreCase(key)) {
                    job.setHashName(value);
                    continue;
                }
                if ("queue_rank".equalsIgnoreCase(key)) {
                    try {
                        job.setQueueRank(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job queue rank: " + nfe.getMessage(), nfe);
                        job.setQueueRank(-1);
                    }
                    continue;
                }
                if ("queue_type".equalsIgnoreCase(key)) {
                    job.setQueueType(value);
                    continue;
                }
                if ("comment".equalsIgnoreCase(key)) {
                    job.setComment(value);
                    continue;
                }
                if ("submit_args".equalsIgnoreCase(key)) {
                    job.setSubmitArgs(value);
                    continue;
                }
                if ("submit_host".equalsIgnoreCase(key)) {
                    job.setSubmitHost(value);
                    continue;
                }
                if ("start_time".equalsIgnoreCase(key)) {
                    job.setStartTime(value);
                    continue;
                }
                if ("start_count".equalsIgnoreCase(key)) {
                    try {
                        job.setStartCount(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job start count: " + nfe.getMessage(), nfe);
                        job.setStartCount(-1);
                    }
                    continue;
                }
                if ("fault_tolerant".equalsIgnoreCase(key)) {
                    job.setFaultTolerant(Boolean.parseBoolean(value));
                    continue;
                }
                if ("job_array_id".equalsIgnoreCase(key)) {
                    job.setJobArrayId(Integer.parseInt(value));
                    continue;
                }
                if ("job_radix".equalsIgnoreCase(key)) {
                    try {
                        job.setRadix(Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Failed parsing job radix: " + nfe.getMessage(), nfe);
                        job.setRadix(-1);
                    }
                    continue;
                }
                if (!"walltime.remaining".equalsIgnoreCase(key)) continue;
                try {
                    job.setWalltimeRemaining(Long.parseLong(value));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.WARNING, "Failed parsing job walltime remaining: " + nfe.getMessage(), nfe);
                    job.setWalltimeRemaining(-1L);
                }
            }
            if (job != null) {
                jobs.add(job);
            }
            return jobs;
        }
        return Collections.emptyList();
    }
}

