/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.TwitterCredentialsBearer;
import com.twitter.clientlib.TwitterCredentialsOAuth2;
import com.twitter.clientlib.api.TwitterApi;
import com.twitter.clientlib.model.DuplicateRuleProblem;
import com.twitter.clientlib.model.Expansions;
import com.twitter.clientlib.model.GenericProblem;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.InvalidRequestProblemAllOfErrors;
import com.twitter.clientlib.model.ModelList;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.ResourceNotFoundProblem;
import com.twitter.clientlib.model.Space;
import com.twitter.clientlib.model.Tweet;
import com.twitter.clientlib.model.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;

public class ApiTester {
    protected TwitterApi apiInstance;
    protected final Integer maxResults = 15;
    protected final Set<String> tweetFields = new HashSet<String>(Arrays.asList("author_id", "id", "created_at"));
    protected Set<String> expansions = new HashSet<String>(Collections.singletonList("author_id"));
    protected String tweetId = "20";
    protected String tweetIdNotFound = "12119879112120";
    protected String tweetIdPopular = "1354143047324299264";
    protected final Set<String> userFields = new HashSet<String>(Collections.singletonList("username"));
    protected final String userId = System.getenv("YOUR_TWITTER_USER_ID");
    protected final String popularUserId = "250831586";
    protected final String userNotExists = "9999999999999";
    protected final List<String> usersIds = Arrays.asList("250831586");
    protected final List<String> usersIdsNotFound = Arrays.asList("9999999999999");

    protected void initApiInstance() {
        this.apiInstance = new TwitterApi();
        this.apiInstance.setTwitterCredentials(new TwitterCredentialsOAuth2(System.getenv("TWITTER_OAUTH2_CLIENT_ID"), System.getenv("TWITTER_OAUTH2_CLIENT_SECRET"), System.getenv("TWITTER_OAUTH2_ACCESS_TOKEN"), System.getenv("TWITTER_OAUTH2_REFRESH_TOKEN")));
    }

    protected void initApiInstanceBearer() {
        this.apiInstance = new TwitterApi();
        this.apiInstance.setTwitterCredentials(new TwitterCredentialsBearer(System.getenv("TWITTER_BEARER_TOKEN")));
    }

    protected void checkApiExceptionProblem(ApiException e, Class problemType, String message, String title, String detail) {
        Assert.assertTrue((boolean)e.getErrorObject().getProblem().getClass().getName().equals(problemType.getName()));
        InvalidRequestProblem problem = (InvalidRequestProblem)e.getErrorObject().getProblem();
        Assert.assertNotNull((Object)problem.getErrors());
        Assert.assertNotNull(problem.getErrors().get(0));
        Assert.assertNotNull((Object)((InvalidRequestProblemAllOfErrors)problem.getErrors().get(0)).getMessage());
        Assert.assertTrue((boolean)((InvalidRequestProblemAllOfErrors)problem.getErrors().get(0)).getMessage().contains(message));
        Assert.assertEquals((Object)problem.getTitle(), (Object)title);
        Assert.assertEquals((Object)problem.getDetail(), (Object)detail);
    }

    protected void checkErrors(boolean assertTrue, List<Problem> errors) {
        boolean hasErrors;
        boolean bl = hasErrors = errors != null && errors.size() > 0;
        if (assertTrue) {
            Assert.assertTrue((boolean)hasErrors);
        } else {
            Assert.assertFalse((boolean)hasErrors);
        }
    }

    protected void checkTweetData(Tweet tweet) {
        Assert.assertNotNull((Object)tweet);
        Assert.assertNotNull((Object)tweet.getText());
        Assert.assertNotNull((Object)tweet.getAuthorId());
        Assert.assertNotNull((Object)tweet.getCreatedAt());
    }

    protected void checkTweetIncludes(Expansions expansions) {
        Assert.assertNotNull((Object)expansions);
        Assert.assertNotNull((Object)expansions.getUsers());
        Assert.assertNotNull(expansions.getUsers().get(0));
        Assert.assertNotNull((Object)((User)expansions.getUsers().get(0)).getUsername());
    }

    protected void checkUserData(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getId());
        Assert.assertNotNull((Object)user.getUsername());
        Assert.assertNotNull((Object)user.getName());
    }

    protected void checkSpaceData(Space space) {
        Assert.assertNotNull((Object)space);
        Assert.assertNotNull((Object)space.getId());
        Assert.assertNotNull((Object)space.getCreatedAt());
        Assert.assertNotNull((Object)space.getCreatorId());
        Assert.assertNotNull((Object)space.getTitle());
    }

    protected void checkListData(ModelList list) {
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getId());
        Assert.assertNotNull((Object)list.getCreatedAt());
        Assert.assertNotNull((Object)list.getDescription());
        Assert.assertNotNull((Object)list.getOwnerId());
        Assert.assertNotNull((Object)list.getFollowerCount());
    }

    protected void checkResourceNotFoundProblem(Problem problem, String value, String title, String parameter) {
        Assert.assertTrue((boolean)(problem instanceof ResourceNotFoundProblem));
        ResourceNotFoundProblem resourceNotFoundProblem = (ResourceNotFoundProblem)problem;
        Assert.assertTrue((boolean)resourceNotFoundProblem.getTitle().equals(title));
        Assert.assertEquals((Object)parameter, (Object)resourceNotFoundProblem.getParameter());
        Assert.assertEquals((Object)value, (Object)resourceNotFoundProblem.getValue());
    }

    protected void checkGenericProblem(Problem problem, String detail, String title, Integer status) {
        Assert.assertTrue((boolean)(problem instanceof GenericProblem));
        GenericProblem genericProblem = (GenericProblem)problem;
        Assert.assertTrue((boolean)genericProblem.getTitle().equals(title));
        Assert.assertEquals((Object)detail, (Object)genericProblem.getDetail());
        Assert.assertEquals((Object)status, (Object)genericProblem.getStatus());
    }

    protected void checkInvalidRequestProblem(Problem problem, String detail, String title, String firstErrorMessage) {
        Assert.assertTrue((boolean)(problem instanceof InvalidRequestProblem));
        InvalidRequestProblem invalidRequestProblem = (InvalidRequestProblem)problem;
        Assert.assertTrue((boolean)invalidRequestProblem.getTitle().equals(title));
        Assert.assertEquals((Object)detail, (Object)invalidRequestProblem.getDetail());
        Assert.assertEquals((Object)firstErrorMessage, (Object)((InvalidRequestProblemAllOfErrors)invalidRequestProblem.getErrors().get(0)).getMessage());
    }

    protected void checkDuplicateRuleProblem(Problem problem, String detail, String value) {
        Assert.assertTrue((boolean)(problem instanceof DuplicateRuleProblem));
        DuplicateRuleProblem duplicateProblem = (DuplicateRuleProblem)problem;
        Assert.assertTrue((boolean)duplicateProblem.getTitle().equals("DuplicateRule"));
        Assert.assertEquals((Object)value, (Object)duplicateProblem.getValue());
    }
}

