/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ContextAnnotationDomainFields;
import com.twitter.clientlib.model.ContextAnnotationEntityFields;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Annotation inferred from the tweet text.")
public class ContextAnnotation {
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private ContextAnnotationDomainFields domain;
    public static final String SERIALIZED_NAME_ENTITY = "entity";
    @SerializedName(value="entity")
    private ContextAnnotationEntityFields entity;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContextAnnotation domain(ContextAnnotationDomainFields domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ContextAnnotationDomainFields getDomain() {
        return this.domain;
    }

    public void setDomain(ContextAnnotationDomainFields domain) {
        this.domain = domain;
    }

    public ContextAnnotation entity(ContextAnnotationEntityFields entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ContextAnnotationEntityFields getEntity() {
        return this.entity;
    }

    public void setEntity(ContextAnnotationEntityFields entity) {
        this.entity = entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextAnnotation contextAnnotation = (ContextAnnotation)o;
        return Objects.equals(this.domain, contextAnnotation.domain) && Objects.equals(this.entity, contextAnnotation.entity);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.entity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContextAnnotation {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContextAnnotation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContextAnnotation` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN) != null) {
            ContextAnnotationDomainFields.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITY) != null) {
            ContextAnnotationEntityFields.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITY));
        }
    }

    public static ContextAnnotation fromJson(String jsonString) throws IOException {
        return (ContextAnnotation)JSON.getGson().fromJson(jsonString, ContextAnnotation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_ENTITY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOMAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTITY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContextAnnotation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContextAnnotation.class));
            return new TypeAdapter<ContextAnnotation>(){

                public void write(JsonWriter out, ContextAnnotation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContextAnnotation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContextAnnotation.validateJsonObject(jsonObj);
                    return (ContextAnnotation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

