/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Point;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Geo {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_BBOX = "bbox";
    @SerializedName(value="bbox")
    private List<Double> bbox = new ArrayList<Double>();
    public static final String SERIALIZED_NAME_GEOMETRY = "geometry";
    @SerializedName(value="geometry")
    private Point geometry;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    private Object properties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Geo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Geo bbox(List<Double> bbox) {
        this.bbox = bbox;
        return this;
    }

    public Geo addBboxItem(Double bboxItem) {
        this.bbox.add(bboxItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[-105.193475,39.60973,-105.053164,39.761974]", required=true, value="")
    public List<Double> getBbox() {
        return this.bbox;
    }

    public void setBbox(List<Double> bbox) {
        this.bbox = bbox;
    }

    public Geo geometry(Point geometry) {
        this.geometry = geometry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Point getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Point geometry) {
        this.geometry = geometry;
    }

    public Geo properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geo geo = (Geo)o;
        return Objects.equals((Object)this.type, (Object)geo.type) && Objects.equals(this.bbox, geo.bbox) && Objects.equals(this.geometry, geo.geometry) && Objects.equals(this.properties, geo.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.bbox, this.geometry, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Geo {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("    geometry: ").append(this.toIndentedString(this.geometry)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Geo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Geo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GEOMETRY) != null) {
            Point.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GEOMETRY));
        }
    }

    public static Geo fromJson(String jsonString) throws IOException {
        return (Geo)JSON.getGson().fromJson(jsonString, Geo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_BBOX);
        openapiFields.add(SERIALIZED_NAME_GEOMETRY);
        openapiFields.add(SERIALIZED_NAME_PROPERTIES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_BBOX);
        openapiRequiredFields.add(SERIALIZED_NAME_PROPERTIES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Geo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Geo.class));
            return new TypeAdapter<Geo>(){

                public void write(JsonWriter out, Geo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Geo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Geo.validateJsonObject(jsonObj);
                    return (Geo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FEATURE("Feature");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

