/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.SpaceTopics;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Space {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_STARTED_AT = "started_at";
    @SerializedName(value="started_at")
    private OffsetDateTime startedAt;
    public static final String SERIALIZED_NAME_IS_TICKETED = "is_ticketed";
    @SerializedName(value="is_ticketed")
    private Boolean isTicketed;
    public static final String SERIALIZED_NAME_PARTICIPANT_COUNT = "participant_count";
    @SerializedName(value="participant_count")
    private Integer participantCount;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_HOST_IDS = "host_ids";
    @SerializedName(value="host_ids")
    private List<String> hostIds = null;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_CREATOR_ID = "creator_id";
    @SerializedName(value="creator_id")
    private String creatorId;
    public static final String SERIALIZED_NAME_LANG = "lang";
    @SerializedName(value="lang")
    private String lang;
    public static final String SERIALIZED_NAME_SPEAKER_IDS = "speaker_ids";
    @SerializedName(value="speaker_ids")
    private List<String> speakerIds = null;
    public static final String SERIALIZED_NAME_INVITED_USER_IDS = "invited_user_ids";
    @SerializedName(value="invited_user_ids")
    private List<String> invitedUserIds = null;
    public static final String SERIALIZED_NAME_SCHEDULED_START = "scheduled_start";
    @SerializedName(value="scheduled_start")
    private OffsetDateTime scheduledStart;
    public static final String SERIALIZED_NAME_ENDED_AT = "ended_at";
    @SerializedName(value="ended_at")
    private OffsetDateTime endedAt;
    public static final String SERIALIZED_NAME_TOPICS = "topics";
    @SerializedName(value="topics")
    private List<SpaceTopics> topics = null;
    public static final String SERIALIZED_NAME_SUBSCRIBER_COUNT = "subscriber_count";
    @SerializedName(value="subscriber_count")
    private Integer subscriberCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Space id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1SLjjRYNejbKM", required=true, value="The unique identifier of this Space.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Space state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="live", required=true, value="The current state of the space.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Space startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the space was started as a date string")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public Space isTicketed(Boolean isTicketed) {
        this.isTicketed = isTicketed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Denotes if the space is a ticketed space")
    public Boolean getIsTicketed() {
        return this.isTicketed;
    }

    public void setIsTicketed(Boolean isTicketed) {
        this.isTicketed = isTicketed;
    }

    public Space participantCount(Integer participantCount) {
        this.participantCount = participantCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="The number of participants in a space")
    public Integer getParticipantCount() {
        return this.participantCount;
    }

    public void setParticipantCount(Integer participantCount) {
        this.participantCount = participantCount;
    }

    public Space title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Spaces are Awesome", value="The title of the space")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Space hostIds(List<String> hostIds) {
        this.hostIds = hostIds;
        return this;
    }

    public Space addHostIdsItem(String hostIdsItem) {
        if (this.hostIds == null) {
            this.hostIds = new ArrayList<String>();
        }
        this.hostIds.add(hostIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user ids for the hosts of the space")
    public List<String> getHostIds() {
        return this.hostIds;
    }

    public void setHostIds(List<String> hostIds) {
        this.hostIds = hostIds;
    }

    public Space updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the space was last updated")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Space createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2021-07-06T18:40:40Z", value="Creation time of the space")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Space creatorId(String creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2244994945", value="Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public Space lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="The language of the space")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Space speakerIds(List<String> speakerIds) {
        this.speakerIds = speakerIds;
        return this;
    }

    public Space addSpeakerIdsItem(String speakerIdsItem) {
        if (this.speakerIds == null) {
            this.speakerIds = new ArrayList<String>();
        }
        this.speakerIds.add(speakerIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of user ids for people who were speakers in a space")
    public List<String> getSpeakerIds() {
        return this.speakerIds;
    }

    public void setSpeakerIds(List<String> speakerIds) {
        this.speakerIds = speakerIds;
    }

    public Space invitedUserIds(List<String> invitedUserIds) {
        this.invitedUserIds = invitedUserIds;
        return this;
    }

    public Space addInvitedUserIdsItem(String invitedUserIdsItem) {
        if (this.invitedUserIds == null) {
            this.invitedUserIds = new ArrayList<String>();
        }
        this.invitedUserIds.add(invitedUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of user ids for people who were invited to a space")
    public List<String> getInvitedUserIds() {
        return this.invitedUserIds;
    }

    public void setInvitedUserIds(List<String> invitedUserIds) {
        this.invitedUserIds = invitedUserIds;
    }

    public Space scheduledStart(OffsetDateTime scheduledStart) {
        this.scheduledStart = scheduledStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2021-07-06T18:40:40Z", value="A date time stamp for when a space is scheduled to begin")
    public OffsetDateTime getScheduledStart() {
        return this.scheduledStart;
    }

    public void setScheduledStart(OffsetDateTime scheduledStart) {
        this.scheduledStart = scheduledStart;
    }

    public Space endedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2021-07-06T18:40:40Z", value="End time of the space")
    public OffsetDateTime getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
    }

    public Space topics(List<SpaceTopics> topics) {
        this.topics = topics;
        return this;
    }

    public Space addTopicsItem(SpaceTopics topicsItem) {
        if (this.topics == null) {
            this.topics = new ArrayList<SpaceTopics>();
        }
        this.topics.add(topicsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The topics of a space, as selected by its creator")
    public List<SpaceTopics> getTopics() {
        return this.topics;
    }

    public void setTopics(List<SpaceTopics> topics) {
        this.topics = topics;
    }

    public Space subscriberCount(Integer subscriberCount) {
        this.subscriberCount = subscriberCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="The number of people who have either purchased a ticket or set a reminder for this space.")
    public Integer getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(Integer subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Space space = (Space)o;
        return Objects.equals(this.id, space.id) && Objects.equals((Object)this.state, (Object)space.state) && Objects.equals(this.startedAt, space.startedAt) && Objects.equals(this.isTicketed, space.isTicketed) && Objects.equals(this.participantCount, space.participantCount) && Objects.equals(this.title, space.title) && Objects.equals(this.hostIds, space.hostIds) && Objects.equals(this.updatedAt, space.updatedAt) && Objects.equals(this.createdAt, space.createdAt) && Objects.equals(this.creatorId, space.creatorId) && Objects.equals(this.lang, space.lang) && Objects.equals(this.speakerIds, space.speakerIds) && Objects.equals(this.invitedUserIds, space.invitedUserIds) && Objects.equals(this.scheduledStart, space.scheduledStart) && Objects.equals(this.endedAt, space.endedAt) && Objects.equals(this.topics, space.topics) && Objects.equals(this.subscriberCount, space.subscriberCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.startedAt, this.isTicketed, this.participantCount, this.title, this.hostIds, this.updatedAt, this.createdAt, this.creatorId, this.lang, this.speakerIds, this.invitedUserIds, this.scheduledStart, this.endedAt, this.topics, this.subscriberCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Space {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    isTicketed: ").append(this.toIndentedString(this.isTicketed)).append("\n");
        sb.append("    participantCount: ").append(this.toIndentedString(this.participantCount)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hostIds: ").append(this.toIndentedString(this.hostIds)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        sb.append("    lang: ").append(this.toIndentedString(this.lang)).append("\n");
        sb.append("    speakerIds: ").append(this.toIndentedString(this.speakerIds)).append("\n");
        sb.append("    invitedUserIds: ").append(this.toIndentedString(this.invitedUserIds)).append("\n");
        sb.append("    scheduledStart: ").append(this.toIndentedString(this.scheduledStart)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("    subscriberCount: ").append(this.toIndentedString(this.subscriberCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Space is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Space` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArraytopics = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOPICS);
        if (jsonArraytopics != null) {
            for (int i = 0; i < jsonArraytopics.size(); ++i) {
                SpaceTopics.validateJsonObject(jsonArraytopics.get(i).getAsJsonObject());
            }
        }
    }

    public static Space fromJson(String jsonString) throws IOException {
        return (Space)JSON.getGson().fromJson(jsonString, Space.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_STARTED_AT);
        openapiFields.add(SERIALIZED_NAME_IS_TICKETED);
        openapiFields.add(SERIALIZED_NAME_PARTICIPANT_COUNT);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_HOST_IDS);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_CREATOR_ID);
        openapiFields.add(SERIALIZED_NAME_LANG);
        openapiFields.add(SERIALIZED_NAME_SPEAKER_IDS);
        openapiFields.add(SERIALIZED_NAME_INVITED_USER_IDS);
        openapiFields.add(SERIALIZED_NAME_SCHEDULED_START);
        openapiFields.add(SERIALIZED_NAME_ENDED_AT);
        openapiFields.add(SERIALIZED_NAME_TOPICS);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIBER_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Space.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Space.class));
            return new TypeAdapter<Space>(){

                public void write(JsonWriter out, Space value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Space read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Space.validateJsonObject(jsonObj);
                    return (Space)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        LIVE("live"),
        SCHEDULED("scheduled"),
        ENDED("ended");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

