/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.FullTextEntities;
import com.twitter.clientlib.model.UserEntitiesUrl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="A list of metadata found in the user's profile description.")
public class UserEntities {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private UserEntitiesUrl url;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private FullTextEntities description;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UserEntities url(UserEntitiesUrl url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserEntitiesUrl getUrl() {
        return this.url;
    }

    public void setUrl(UserEntitiesUrl url) {
        this.url = url;
    }

    public UserEntities description(FullTextEntities description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FullTextEntities getDescription() {
        return this.description;
    }

    public void setDescription(FullTextEntities description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntities userEntities = (UserEntities)o;
        return Objects.equals(this.url, userEntities.url) && Objects.equals(this.description, userEntities.description);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserEntities {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UserEntities is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UserEntities` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_URL) != null) {
            UserEntitiesUrl.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_URL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DESCRIPTION) != null) {
            FullTextEntities.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DESCRIPTION));
        }
    }

    public static UserEntities fromJson(String jsonString) throws IOException {
        return (UserEntities)JSON.getGson().fromJson(jsonString, UserEntities.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UserEntities.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserEntities.class));
            return new TypeAdapter<UserEntities>(){

                public void write(JsonWriter out, UserEntities value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UserEntities read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UserEntities.validateJsonObject(jsonObj);
                    return (UserEntities)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

