/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="Promoted nonpublic engagement metrics for the Tweet at the time of the request.")
public class TweetPromotedMetrics {
    public static final String SERIALIZED_NAME_IMPRESSION_COUNT = "impression_count";
    @SerializedName(value="impression_count")
    private Integer impressionCount;
    public static final String SERIALIZED_NAME_LIKE_COUNT = "like_count";
    @SerializedName(value="like_count")
    private Integer likeCount;
    public static final String SERIALIZED_NAME_REPLY_COUNT = "reply_count";
    @SerializedName(value="reply_count")
    private Integer replyCount;
    public static final String SERIALIZED_NAME_RETWEET_COUNT = "retweet_count";
    @SerializedName(value="retweet_count")
    private Integer retweetCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetPromotedMetrics impressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been viewed.")
    public Integer getImpressionCount() {
        return this.impressionCount;
    }

    public void setImpressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
    }

    public TweetPromotedMetrics likeCount(Integer likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been liked.")
    public Integer getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public TweetPromotedMetrics replyCount(Integer replyCount) {
        this.replyCount = replyCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been replied to.")
    public Integer getReplyCount() {
        return this.replyCount;
    }

    public void setReplyCount(Integer replyCount) {
        this.replyCount = replyCount;
    }

    public TweetPromotedMetrics retweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been Retweeted.")
    public Integer getRetweetCount() {
        return this.retweetCount;
    }

    public void setRetweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetPromotedMetrics tweetPromotedMetrics = (TweetPromotedMetrics)o;
        return Objects.equals(this.impressionCount, tweetPromotedMetrics.impressionCount) && Objects.equals(this.likeCount, tweetPromotedMetrics.likeCount) && Objects.equals(this.replyCount, tweetPromotedMetrics.replyCount) && Objects.equals(this.retweetCount, tweetPromotedMetrics.retweetCount);
    }

    public int hashCode() {
        return Objects.hash(this.impressionCount, this.likeCount, this.replyCount, this.retweetCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetPromotedMetrics {\n");
        sb.append("    impressionCount: ").append(this.toIndentedString(this.impressionCount)).append("\n");
        sb.append("    likeCount: ").append(this.toIndentedString(this.likeCount)).append("\n");
        sb.append("    replyCount: ").append(this.toIndentedString(this.replyCount)).append("\n");
        sb.append("    retweetCount: ").append(this.toIndentedString(this.retweetCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TweetPromotedMetrics is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TweetPromotedMetrics` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static TweetPromotedMetrics fromJson(String jsonString) throws IOException {
        return (TweetPromotedMetrics)JSON.getGson().fromJson(jsonString, TweetPromotedMetrics.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IMPRESSION_COUNT);
        openapiFields.add(SERIALIZED_NAME_LIKE_COUNT);
        openapiFields.add(SERIALIZED_NAME_REPLY_COUNT);
        openapiFields.add(SERIALIZED_NAME_RETWEET_COUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetPromotedMetrics.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetPromotedMetrics.class));
            return new TypeAdapter<TweetPromotedMetrics>(){

                public void write(JsonWriter out, TweetPromotedMetrics value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetPromotedMetrics read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetPromotedMetrics.validateJsonObject(jsonObj);
                    return (TweetPromotedMetrics)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

