/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Engagement metrics for the Tweet at the time of the request.")
public class TweetPublicMetrics {
    public static final String SERIALIZED_NAME_RETWEET_COUNT = "retweet_count";
    @SerializedName(value="retweet_count")
    private Integer retweetCount;
    public static final String SERIALIZED_NAME_REPLY_COUNT = "reply_count";
    @SerializedName(value="reply_count")
    private Integer replyCount;
    public static final String SERIALIZED_NAME_LIKE_COUNT = "like_count";
    @SerializedName(value="like_count")
    private Integer likeCount;
    public static final String SERIALIZED_NAME_QUOTE_COUNT = "quote_count";
    @SerializedName(value="quote_count")
    private Integer quoteCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetPublicMetrics retweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of times this Tweet has been Retweeted.")
    public Integer getRetweetCount() {
        return this.retweetCount;
    }

    public void setRetweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
    }

    public TweetPublicMetrics replyCount(Integer replyCount) {
        this.replyCount = replyCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of times this Tweet has been replied to.")
    public Integer getReplyCount() {
        return this.replyCount;
    }

    public void setReplyCount(Integer replyCount) {
        this.replyCount = replyCount;
    }

    public TweetPublicMetrics likeCount(Integer likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of times this Tweet has been liked.")
    public Integer getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public TweetPublicMetrics quoteCount(Integer quoteCount) {
        this.quoteCount = quoteCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been quoted.")
    public Integer getQuoteCount() {
        return this.quoteCount;
    }

    public void setQuoteCount(Integer quoteCount) {
        this.quoteCount = quoteCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetPublicMetrics tweetPublicMetrics = (TweetPublicMetrics)o;
        return Objects.equals(this.retweetCount, tweetPublicMetrics.retweetCount) && Objects.equals(this.replyCount, tweetPublicMetrics.replyCount) && Objects.equals(this.likeCount, tweetPublicMetrics.likeCount) && Objects.equals(this.quoteCount, tweetPublicMetrics.quoteCount);
    }

    public int hashCode() {
        return Objects.hash(this.retweetCount, this.replyCount, this.likeCount, this.quoteCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetPublicMetrics {\n");
        sb.append("    retweetCount: ").append(this.toIndentedString(this.retweetCount)).append("\n");
        sb.append("    replyCount: ").append(this.toIndentedString(this.replyCount)).append("\n");
        sb.append("    likeCount: ").append(this.toIndentedString(this.likeCount)).append("\n");
        sb.append("    quoteCount: ").append(this.toIndentedString(this.quoteCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TweetPublicMetrics is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TweetPublicMetrics` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static TweetPublicMetrics fromJson(String jsonString) throws IOException {
        return (TweetPublicMetrics)JSON.getGson().fromJson(jsonString, TweetPublicMetrics.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RETWEET_COUNT);
        openapiFields.add(SERIALIZED_NAME_REPLY_COUNT);
        openapiFields.add(SERIALIZED_NAME_LIKE_COUNT);
        openapiFields.add(SERIALIZED_NAME_QUOTE_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RETWEET_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_REPLY_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_LIKE_COUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetPublicMetrics.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetPublicMetrics.class));
            return new TypeAdapter<TweetPublicMetrics>(){

                public void write(JsonWriter out, TweetPublicMetrics value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetPublicMetrics read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetPublicMetrics.validateJsonObject(jsonObj);
                    return (TweetPublicMetrics)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

