/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Problem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="A problem that indicates that a usage cap has been exceeded.")
public class UsageCapExceededProblem
extends Problem {
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private PeriodEnum period;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private ScopeEnum scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UsageCapExceededProblem() {
        this.type = this.getClass().getSimpleName();
    }

    public UsageCapExceededProblem period(PeriodEnum period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PeriodEnum getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodEnum period) {
        this.period = period;
    }

    public UsageCapExceededProblem scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageCapExceededProblem usageCapExceededProblem = (UsageCapExceededProblem)o;
        return Objects.equals((Object)this.period, (Object)usageCapExceededProblem.period) && Objects.equals((Object)this.scope, (Object)usageCapExceededProblem.scope) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.period, this.scope, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageCapExceededProblem {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UsageCapExceededProblem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UsageCapExceededProblem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static UsageCapExceededProblem fromJson(String jsonString) throws IOException {
        return (UsageCapExceededProblem)JSON.getGson().fromJson(jsonString, UsageCapExceededProblem.class);
    }

    @Override
    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add("type");
        openapiFields.add("title");
        openapiFields.add("detail");
        openapiFields.add("status");
        openapiFields.add(SERIALIZED_NAME_PERIOD);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add("type");
        openapiRequiredFields.add("title");
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UsageCapExceededProblem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UsageCapExceededProblem.class));
            return new TypeAdapter<UsageCapExceededProblem>(){

                public void write(JsonWriter out, UsageCapExceededProblem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UsageCapExceededProblem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UsageCapExceededProblem.validateJsonObject(jsonObj);
                    return (UsageCapExceededProblem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScopeEnum {
        ACCOUNT("Account"),
        PRODUCT("Product");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScopeEnum fromValue(String value) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ScopeEnum> {
            public void write(JsonWriter jsonWriter, ScopeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ScopeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScopeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodEnum {
        DAILY("Daily"),
        MONTHLY("Monthly");

        private String value;

        private PeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodEnum fromValue(String value) {
            for (PeriodEnum b : PeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PeriodEnum> {
            public void write(JsonWriter jsonWriter, PeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodEnum.fromValue(value);
            }
        }
    }
}

