/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Indicates withholding details for [withheld content](https://help.twitter.com/en/rules-and-policies/tweet-withheld-by-country).")
public class UserWithheld {
    public static final String SERIALIZED_NAME_COUNTRY_CODES = "country_codes";
    @SerializedName(value="country_codes")
    private Set<String> countryCodes = new LinkedHashSet<String>();
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private ScopeEnum scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UserWithheld countryCodes(Set<String> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public UserWithheld addCountryCodesItem(String countryCodesItem) {
        this.countryCodes.add(countryCodesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Provides a list of countries where this content is not available.")
    public Set<String> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(Set<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    public UserWithheld scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the content being withheld is a `user`.")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserWithheld userWithheld = (UserWithheld)o;
        return Objects.equals(this.countryCodes, userWithheld.countryCodes) && Objects.equals((Object)this.scope, (Object)userWithheld.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.countryCodes, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserWithheld {\n");
        sb.append("    countryCodes: ").append(this.toIndentedString(this.countryCodes)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UserWithheld is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UserWithheld` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static UserWithheld fromJson(String jsonString) throws IOException {
        return (UserWithheld)JSON.getGson().fromJson(jsonString, UserWithheld.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODES);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY_CODES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UserWithheld.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserWithheld.class));
            return new TypeAdapter<UserWithheld>(){

                public void write(JsonWriter out, UserWithheld value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UserWithheld read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UserWithheld.validateJsonObject(jsonObj);
                    return (UserWithheld)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScopeEnum {
        USER("user");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScopeEnum fromValue(String value) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ScopeEnum> {
            public void write(JsonWriter jsonWriter, ScopeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ScopeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScopeEnum.fromValue(value);
            }
        }
    }
}

