/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.AddBookmarkRequest;
import com.twitter.clientlib.model.BookmarkMutationResponse;
import com.twitter.clientlib.model.GenericTweetsTimelineResponse;
import com.twitter.clientlib.model.ProblemOrError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class BookmarksApi
extends ApiCommon {
    public Call getUsersIdBookmarksCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/bookmarks".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getUsersIdBookmarksValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUsersIdBookmarks(Async)");
        }
        Call localVarCall = this.getUsersIdBookmarksCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public GenericTweetsTimelineResponse getUsersIdBookmarks(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<GenericTweetsTimelineResponse> localVarResp;
        try {
            localVarResp = this.getUsersIdBookmarksWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.getUsersIdBookmarksWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericTweetsTimelineResponse getUsersIdBookmarks(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try {
            localVarResp = this.getUsersIdBookmarks(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.getUsersIdBookmarks(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericTweetsTimelineResponse> getUsersIdBookmarksWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call getUsersIdBookmarksAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {
        Call localVarCall = this.getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postUsersIdBookmarksCall(AddBookmarkRequest addBookmarkRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        AddBookmarkRequest localVarPostBody = addBookmarkRequest;
        String localVarPath = "/2/users/{id}/bookmarks".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call postUsersIdBookmarksValidateBeforeCall(AddBookmarkRequest addBookmarkRequest, String id, ApiCallback _callback) throws ApiException {
        if (addBookmarkRequest == null) {
            throw new ApiException("Missing the required parameter 'addBookmarkRequest' when calling postUsersIdBookmarks(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postUsersIdBookmarks(Async)");
        }
        Call localVarCall = this.postUsersIdBookmarksCall(addBookmarkRequest, id, _callback);
        return localVarCall;
    }

    public BookmarkMutationResponse postUsersIdBookmarks(AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
        ApiResponse<BookmarkMutationResponse> localVarResp;
        try {
            localVarResp = this.postUsersIdBookmarksWithHttpInfo(addBookmarkRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.postUsersIdBookmarksWithHttpInfo(addBookmarkRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public BookmarkMutationResponse postUsersIdBookmarks(Integer retries, AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
        BookmarkMutationResponse localVarResp;
        try {
            localVarResp = this.postUsersIdBookmarks(addBookmarkRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.postUsersIdBookmarks(retries - 1, addBookmarkRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<BookmarkMutationResponse> postUsersIdBookmarksWithHttpInfo(AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
        Call localVarCall = this.postUsersIdBookmarksValidateBeforeCall(addBookmarkRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call postUsersIdBookmarksAsync(AddBookmarkRequest addBookmarkRequest, String id, ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.postUsersIdBookmarksValidateBeforeCall(addBookmarkRequest, id, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdBookmarksDeleteCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/bookmarks/{tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{tweet_id\\}", this.localVarApiClient.escapeString(tweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBookmarksDeleteValidateBeforeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBookmarksDelete(Async)");
        }
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdBookmarksDelete(Async)");
        }
        Call localVarCall = this.usersIdBookmarksDeleteCall(id, tweetId, _callback);
        return localVarCall;
    }

    public BookmarkMutationResponse usersIdBookmarksDelete(String id, String tweetId) throws ApiException {
        ApiResponse<BookmarkMutationResponse> localVarResp;
        try {
            localVarResp = this.usersIdBookmarksDeleteWithHttpInfo(id, tweetId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdBookmarksDeleteWithHttpInfo(id, tweetId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public BookmarkMutationResponse usersIdBookmarksDelete(Integer retries, String id, String tweetId) throws ApiException {
        BookmarkMutationResponse localVarResp;
        try {
            localVarResp = this.usersIdBookmarksDelete(id, tweetId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdBookmarksDelete(retries - 1, id, tweetId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<BookmarkMutationResponse> usersIdBookmarksDeleteWithHttpInfo(String id, String tweetId) throws ApiException {
        Call localVarCall = this.usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdBookmarksDeleteAsync(String id, String tweetId, ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

