/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.ComplianceJobStatus;
import com.twitter.clientlib.model.ComplianceJobType;
import com.twitter.clientlib.model.CreateBatchComplianceJobRequest;
import com.twitter.clientlib.model.MultiComplianceJobResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.SingleComplianceJobResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class ComplianceApi
extends ApiCommon {
    public Call createBatchComplianceJobCall(CreateBatchComplianceJobRequest createBatchComplianceJobRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        CreateBatchComplianceJobRequest localVarPostBody = createBatchComplianceJobRequest;
        String localVarPath = "/2/compliance/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call createBatchComplianceJobValidateBeforeCall(CreateBatchComplianceJobRequest createBatchComplianceJobRequest, ApiCallback _callback) throws ApiException {
        if (createBatchComplianceJobRequest == null) {
            throw new ApiException("Missing the required parameter 'createBatchComplianceJobRequest' when calling createBatchComplianceJob(Async)");
        }
        Call localVarCall = this.createBatchComplianceJobCall(createBatchComplianceJobRequest, _callback);
        return localVarCall;
    }

    public SingleComplianceJobResponse createBatchComplianceJob(CreateBatchComplianceJobRequest createBatchComplianceJobRequest) throws ApiException {
        ApiResponse<SingleComplianceJobResponse> localVarResp;
        try {
            localVarResp = this.createBatchComplianceJobWithHttpInfo(createBatchComplianceJobRequest);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.createBatchComplianceJobWithHttpInfo(createBatchComplianceJobRequest);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleComplianceJobResponse createBatchComplianceJob(Integer retries, CreateBatchComplianceJobRequest createBatchComplianceJobRequest) throws ApiException {
        SingleComplianceJobResponse localVarResp;
        try {
            localVarResp = this.createBatchComplianceJob(createBatchComplianceJobRequest);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.createBatchComplianceJob(retries - 1, createBatchComplianceJobRequest);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleComplianceJobResponse> createBatchComplianceJobWithHttpInfo(CreateBatchComplianceJobRequest createBatchComplianceJobRequest) throws ApiException {
        Call localVarCall = this.createBatchComplianceJobValidateBeforeCall(createBatchComplianceJobRequest, null);
        try {
            Type localVarReturnType = new TypeToken<SingleComplianceJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call createBatchComplianceJobAsync(CreateBatchComplianceJobRequest createBatchComplianceJobRequest, ApiCallback<SingleComplianceJobResponse> _callback) throws ApiException {
        Call localVarCall = this.createBatchComplianceJobValidateBeforeCall(createBatchComplianceJobRequest, _callback);
        Type localVarReturnType = new TypeToken<SingleComplianceJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchComplianceJobCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/compliance/jobs/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getBatchComplianceJobValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBatchComplianceJob(Async)");
        }
        Call localVarCall = this.getBatchComplianceJobCall(id, _callback);
        return localVarCall;
    }

    public SingleComplianceJobResponse getBatchComplianceJob(String id) throws ApiException {
        ApiResponse<SingleComplianceJobResponse> localVarResp;
        try {
            localVarResp = this.getBatchComplianceJobWithHttpInfo(id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.getBatchComplianceJobWithHttpInfo(id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleComplianceJobResponse getBatchComplianceJob(Integer retries, String id) throws ApiException {
        SingleComplianceJobResponse localVarResp;
        try {
            localVarResp = this.getBatchComplianceJob(id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.getBatchComplianceJob(retries - 1, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleComplianceJobResponse> getBatchComplianceJobWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getBatchComplianceJobValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<SingleComplianceJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call getBatchComplianceJobAsync(String id, ApiCallback<SingleComplianceJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getBatchComplianceJobValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<SingleComplianceJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listBatchComplianceJobsCall(ComplianceJobType type, ComplianceJobStatus status, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/compliance/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", (Object)status));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listBatchComplianceJobsValidateBeforeCall(ComplianceJobType type, ComplianceJobStatus status, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listBatchComplianceJobs(Async)");
        }
        Call localVarCall = this.listBatchComplianceJobsCall(type, status, _callback);
        return localVarCall;
    }

    public MultiComplianceJobResponse listBatchComplianceJobs(ComplianceJobType type, ComplianceJobStatus status) throws ApiException {
        ApiResponse<MultiComplianceJobResponse> localVarResp;
        try {
            localVarResp = this.listBatchComplianceJobsWithHttpInfo(type, status);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listBatchComplianceJobsWithHttpInfo(type, status);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiComplianceJobResponse listBatchComplianceJobs(Integer retries, ComplianceJobType type, ComplianceJobStatus status) throws ApiException {
        MultiComplianceJobResponse localVarResp;
        try {
            localVarResp = this.listBatchComplianceJobs(type, status);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listBatchComplianceJobs(retries - 1, type, status);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiComplianceJobResponse> listBatchComplianceJobsWithHttpInfo(ComplianceJobType type, ComplianceJobStatus status) throws ApiException {
        Call localVarCall = this.listBatchComplianceJobsValidateBeforeCall(type, status, null);
        try {
            Type localVarReturnType = new TypeToken<MultiComplianceJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listBatchComplianceJobsAsync(ComplianceJobType type, ComplianceJobStatus status, ApiCallback<MultiComplianceJobResponse> _callback) throws ApiException {
        Call localVarCall = this.listBatchComplianceJobsValidateBeforeCall(type, status, _callback);
        Type localVarReturnType = new TypeToken<MultiComplianceJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

