/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Media;
import com.twitter.clientlib.model.VideoAllOfVariants;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class AnimatedGif
extends Media {
    public static final String SERIALIZED_NAME_PREVIEW_IMAGE_URL = "preview_image_url";
    @SerializedName(value="preview_image_url")
    private URI previewImageUrl;
    public static final String SERIALIZED_NAME_VARIANTS = "variants";
    @SerializedName(value="variants")
    private List<VideoAllOfVariants> variants = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AnimatedGif() {
        this.type = this.getClass().getSimpleName();
    }

    public AnimatedGif previewImageUrl(URI previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public URI getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    public void setPreviewImageUrl(URI previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
    }

    public AnimatedGif variants(List<VideoAllOfVariants> variants) {
        this.variants = variants;
        return this;
    }

    public AnimatedGif addVariantsItem(VideoAllOfVariants variantsItem) {
        if (this.variants == null) {
            this.variants = new ArrayList<VideoAllOfVariants>();
        }
        this.variants.add(variantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of all available variants of the media")
    public List<VideoAllOfVariants> getVariants() {
        return this.variants;
    }

    public void setVariants(List<VideoAllOfVariants> variants) {
        this.variants = variants;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimatedGif animatedGif = (AnimatedGif)o;
        return Objects.equals(this.previewImageUrl, animatedGif.previewImageUrl) && Objects.equals(this.variants, animatedGif.variants) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.previewImageUrl, this.variants, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnimatedGif {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    previewImageUrl: ").append(this.toIndentedString(this.previewImageUrl)).append("\n");
        sb.append("    variants: ").append(this.toIndentedString(this.variants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static AnimatedGif fromJson(String jsonString) throws IOException {
        return (AnimatedGif)JSON.getGson().fromJson(jsonString, AnimatedGif.class);
    }

    @Override
    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add("type");
        openapiFields.add("media_key");
        openapiFields.add("height");
        openapiFields.add("width");
        openapiFields.add(SERIALIZED_NAME_PREVIEW_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_VARIANTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add("type");
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AnimatedGif.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AnimatedGif.class));
            return new TypeAdapter<AnimatedGif>(){

                public void write(JsonWriter out, AnimatedGif value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AnimatedGif read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AnimatedGif.validateJsonObject(jsonObj);
                    return (AnimatedGif)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

