/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Describes a choice in a Poll object.")
public class PollOption {
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Integer position;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_VOTES = "votes";
    @SerializedName(value="votes")
    private Integer votes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PollOption position(Integer position) {
        this.position = position;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Position of this choice in the poll.")
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public PollOption label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The text of a poll choice.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PollOption votes(Integer votes) {
        this.votes = votes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of users who voted for this choice.")
    public Integer getVotes() {
        return this.votes;
    }

    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollOption pollOption = (PollOption)o;
        return Objects.equals(this.position, pollOption.position) && Objects.equals(this.label, pollOption.label) && Objects.equals(this.votes, pollOption.votes);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.label, this.votes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PollOption {\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LABEL) != null && !jsonObj.get(SERIALIZED_NAME_LABEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `label` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LABEL).toString()));
        }
    }

    public static PollOption fromJson(String jsonString) throws IOException {
        return (PollOption)JSON.getGson().fromJson(jsonString, PollOption.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_POSITION);
        openapiFields.add(SERIALIZED_NAME_LABEL);
        openapiFields.add(SERIALIZED_NAME_VOTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_POSITION);
        openapiRequiredFields.add(SERIALIZED_NAME_LABEL);
        openapiRequiredFields.add(SERIALIZED_NAME_VOTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PollOption.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PollOption.class));
            return new TypeAdapter<PollOption>(){

                public void write(JsonWriter out, PollOption value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PollOption read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PollOption.validateJsonObject(jsonObj);
                    return (PollOption)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

