/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

public class TweetSearchResponseMeta {
    public static final String SERIALIZED_NAME_NEWEST_ID = "newest_id";
    @SerializedName(value="newest_id")
    private String newestId;
    public static final String SERIALIZED_NAME_OLDEST_ID = "oldest_id";
    @SerializedName(value="oldest_id")
    private String oldestId;
    public static final String SERIALIZED_NAME_NEXT_TOKEN = "next_token";
    @SerializedName(value="next_token")
    private String nextToken;
    public static final String SERIALIZED_NAME_RESULT_COUNT = "result_count";
    @SerializedName(value="result_count")
    private Integer resultCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetSearchResponseMeta newestId(String newestId) {
        this.newestId = newestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Most recent Tweet Id returned by search query")
    public String getNewestId() {
        return this.newestId;
    }

    public void setNewestId(String newestId) {
        this.newestId = newestId;
    }

    public TweetSearchResponseMeta oldestId(String oldestId) {
        this.oldestId = oldestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Oldest Tweet Id returned by search query")
    public String getOldestId() {
        return this.oldestId;
    }

    public void setOldestId(String oldestId) {
        this.oldestId = oldestId;
    }

    public TweetSearchResponseMeta nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This value is used to get the next 'page' of results by providing it to the next_token parameter.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public TweetSearchResponseMeta resultCount(Integer resultCount) {
        this.resultCount = resultCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of search query results")
    public Integer getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(Integer resultCount) {
        this.resultCount = resultCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetSearchResponseMeta tweetSearchResponseMeta = (TweetSearchResponseMeta)o;
        return Objects.equals(this.newestId, tweetSearchResponseMeta.newestId) && Objects.equals(this.oldestId, tweetSearchResponseMeta.oldestId) && Objects.equals(this.nextToken, tweetSearchResponseMeta.nextToken) && Objects.equals(this.resultCount, tweetSearchResponseMeta.resultCount);
    }

    public int hashCode() {
        return Objects.hash(this.newestId, this.oldestId, this.nextToken, this.resultCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetSearchResponseMeta {\n");
        sb.append("    newestId: ").append(this.toIndentedString(this.newestId)).append("\n");
        sb.append("    oldestId: ").append(this.toIndentedString(this.oldestId)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    resultCount: ").append(this.toIndentedString(this.resultCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj.get(SERIALIZED_NAME_NEWEST_ID) != null && !jsonObj.get(SERIALIZED_NAME_NEWEST_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `newest_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEWEST_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OLDEST_ID) != null && !jsonObj.get(SERIALIZED_NAME_OLDEST_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oldest_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OLDEST_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEXT_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_NEXT_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `next_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEXT_TOKEN).toString()));
        }
    }

    public static TweetSearchResponseMeta fromJson(String jsonString) throws IOException {
        return (TweetSearchResponseMeta)JSON.getGson().fromJson(jsonString, TweetSearchResponseMeta.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NEWEST_ID);
        openapiFields.add(SERIALIZED_NAME_OLDEST_ID);
        openapiFields.add(SERIALIZED_NAME_NEXT_TOKEN);
        openapiFields.add(SERIALIZED_NAME_RESULT_COUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetSearchResponseMeta.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetSearchResponseMeta.class));
            return new TypeAdapter<TweetSearchResponseMeta>(){

                public void write(JsonWriter out, TweetSearchResponseMeta value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetSearchResponseMeta read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetSearchResponseMeta.validateJsonObject(jsonObj);
                    return (TweetSearchResponseMeta)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

