/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.ListAddMemberRequest;
import com.twitter.clientlib.model.ListCreateRequest;
import com.twitter.clientlib.model.ListCreateResponse;
import com.twitter.clientlib.model.ListDeleteResponse;
import com.twitter.clientlib.model.ListFollowRequest;
import com.twitter.clientlib.model.ListFollowedResponse;
import com.twitter.clientlib.model.ListMemberResponse;
import com.twitter.clientlib.model.ListPinRequest;
import com.twitter.clientlib.model.ListPinnedResponse;
import com.twitter.clientlib.model.ListUpdateRequest;
import com.twitter.clientlib.model.ListUpdateResponse;
import com.twitter.clientlib.model.MultiListNoPaginationResponse;
import com.twitter.clientlib.model.MultiListResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.SingleListLookupResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class ListsApi
extends ApiCommon {
    public Call getUserListMembershipsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/list_memberships".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getUserListMembershipsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUserListMemberships(Async)");
        }
        Call localVarCall = this.getUserListMembershipsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    public MultiListResponse getUserListMemberships(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        ApiResponse<MultiListResponse> localVarResp;
        try {
            localVarResp = this.getUserListMembershipsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.getUserListMembershipsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiListResponse getUserListMemberships(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try {
            localVarResp = this.getUserListMemberships(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.getUserListMemberships(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiListResponse> getUserListMembershipsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call getUserListMembershipsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<MultiListResponse> _callback) throws ApiException {
        Call localVarCall = this.getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAddMemberCall(ListAddMemberRequest listAddMemberRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListAddMemberRequest localVarPostBody = listAddMemberRequest;
        String localVarPath = "/2/lists/{id}/members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listAddMemberValidateBeforeCall(ListAddMemberRequest listAddMemberRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listAddMember(Async)");
        }
        Call localVarCall = this.listAddMemberCall(listAddMemberRequest, id, _callback);
        return localVarCall;
    }

    public ListMemberResponse listAddMember(ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
        ApiResponse<ListMemberResponse> localVarResp;
        try {
            localVarResp = this.listAddMemberWithHttpInfo(listAddMemberRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listAddMemberWithHttpInfo(listAddMemberRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListMemberResponse listAddMember(Integer retries, ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
        ListMemberResponse localVarResp;
        try {
            localVarResp = this.listAddMember(listAddMemberRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listAddMember(retries - 1, listAddMemberRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListMemberResponse> listAddMemberWithHttpInfo(ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
        Call localVarCall = this.listAddMemberValidateBeforeCall(listAddMemberRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listAddMemberAsync(ListAddMemberRequest listAddMemberRequest, String id, ApiCallback<ListMemberResponse> _callback) throws ApiException {
        Call localVarCall = this.listAddMemberValidateBeforeCall(listAddMemberRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIdCreateCall(ListCreateRequest listCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListCreateRequest localVarPostBody = listCreateRequest;
        String localVarPath = "/2/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdCreateValidateBeforeCall(ListCreateRequest listCreateRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listIdCreateCall(listCreateRequest, _callback);
        return localVarCall;
    }

    public ListCreateResponse listIdCreate(ListCreateRequest listCreateRequest) throws ApiException {
        ApiResponse<ListCreateResponse> localVarResp;
        try {
            localVarResp = this.listIdCreateWithHttpInfo(listCreateRequest);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listIdCreateWithHttpInfo(listCreateRequest);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListCreateResponse listIdCreate(Integer retries, ListCreateRequest listCreateRequest) throws ApiException {
        ListCreateResponse localVarResp;
        try {
            localVarResp = this.listIdCreate(listCreateRequest);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listIdCreate(retries - 1, listCreateRequest);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListCreateResponse> listIdCreateWithHttpInfo(ListCreateRequest listCreateRequest) throws ApiException {
        Call localVarCall = this.listIdCreateValidateBeforeCall(listCreateRequest, null);
        try {
            Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listIdCreateAsync(ListCreateRequest listCreateRequest, ApiCallback<ListCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdCreateValidateBeforeCall(listCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIdDeleteCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdDeleteValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdDelete(Async)");
        }
        Call localVarCall = this.listIdDeleteCall(id, _callback);
        return localVarCall;
    }

    public ListDeleteResponse listIdDelete(String id) throws ApiException {
        ApiResponse<ListDeleteResponse> localVarResp;
        try {
            localVarResp = this.listIdDeleteWithHttpInfo(id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listIdDeleteWithHttpInfo(id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListDeleteResponse listIdDelete(Integer retries, String id) throws ApiException {
        ListDeleteResponse localVarResp;
        try {
            localVarResp = this.listIdDelete(id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listIdDelete(retries - 1, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListDeleteResponse> listIdDeleteWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.listIdDeleteValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listIdDeleteAsync(String id, ApiCallback<ListDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdDeleteValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIdGetCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdGetValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdGet(Async)");
        }
        Call localVarCall = this.listIdGetCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    public SingleListLookupResponse listIdGet(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        ApiResponse<SingleListLookupResponse> localVarResp;
        try {
            localVarResp = this.listIdGetWithHttpInfo(id, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listIdGetWithHttpInfo(id, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleListLookupResponse listIdGet(Integer retries, String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        SingleListLookupResponse localVarResp;
        try {
            localVarResp = this.listIdGet(id, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listIdGet(retries - 1, id, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleListLookupResponse> listIdGetWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listIdGetValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleListLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listIdGetAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<SingleListLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdGetValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleListLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIdUpdateCall(ListUpdateRequest listUpdateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListUpdateRequest localVarPostBody = listUpdateRequest;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdUpdateValidateBeforeCall(ListUpdateRequest listUpdateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdUpdate(Async)");
        }
        Call localVarCall = this.listIdUpdateCall(listUpdateRequest, id, _callback);
        return localVarCall;
    }

    public ListUpdateResponse listIdUpdate(ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        ApiResponse<ListUpdateResponse> localVarResp;
        try {
            localVarResp = this.listIdUpdateWithHttpInfo(listUpdateRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listIdUpdateWithHttpInfo(listUpdateRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListUpdateResponse listIdUpdate(Integer retries, ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        ListUpdateResponse localVarResp;
        try {
            localVarResp = this.listIdUpdate(listUpdateRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listIdUpdate(retries - 1, listUpdateRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListUpdateResponse> listIdUpdateWithHttpInfo(ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        Call localVarCall = this.listIdUpdateValidateBeforeCall(listUpdateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listIdUpdateAsync(ListUpdateRequest listUpdateRequest, String id, ApiCallback<ListUpdateResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdUpdateValidateBeforeCall(listUpdateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRemoveMemberCall(String id, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/members/{user_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listRemoveMemberValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listRemoveMember(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listRemoveMember(Async)");
        }
        Call localVarCall = this.listRemoveMemberCall(id, userId, _callback);
        return localVarCall;
    }

    public ListMemberResponse listRemoveMember(String id, String userId) throws ApiException {
        ApiResponse<ListMemberResponse> localVarResp;
        try {
            localVarResp = this.listRemoveMemberWithHttpInfo(id, userId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listRemoveMemberWithHttpInfo(id, userId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListMemberResponse listRemoveMember(Integer retries, String id, String userId) throws ApiException {
        ListMemberResponse localVarResp;
        try {
            localVarResp = this.listRemoveMember(id, userId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listRemoveMember(retries - 1, id, userId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListMemberResponse> listRemoveMemberWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.listRemoveMemberValidateBeforeCall(id, userId, null);
        try {
            Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listRemoveMemberAsync(String id, String userId, ApiCallback<ListMemberResponse> _callback) throws ApiException {
        Call localVarCall = this.listRemoveMemberValidateBeforeCall(id, userId, _callback);
        Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserFollowCall(ListFollowRequest listFollowRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListFollowRequest localVarPostBody = listFollowRequest;
        String localVarPath = "/2/users/{id}/followed_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserFollowValidateBeforeCall(ListFollowRequest listFollowRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserFollow(Async)");
        }
        Call localVarCall = this.listUserFollowCall(listFollowRequest, id, _callback);
        return localVarCall;
    }

    public ListFollowedResponse listUserFollow(ListFollowRequest listFollowRequest, String id) throws ApiException {
        ApiResponse<ListFollowedResponse> localVarResp;
        try {
            localVarResp = this.listUserFollowWithHttpInfo(listFollowRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserFollowWithHttpInfo(listFollowRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListFollowedResponse listUserFollow(Integer retries, ListFollowRequest listFollowRequest, String id) throws ApiException {
        ListFollowedResponse localVarResp;
        try {
            localVarResp = this.listUserFollow(listFollowRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserFollow(retries - 1, listFollowRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListFollowedResponse> listUserFollowWithHttpInfo(ListFollowRequest listFollowRequest, String id) throws ApiException {
        Call localVarCall = this.listUserFollowValidateBeforeCall(listFollowRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserFollowAsync(ListFollowRequest listFollowRequest, String id, ApiCallback<ListFollowedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserFollowValidateBeforeCall(listFollowRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserOwnedListsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/owned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserOwnedListsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserOwnedLists(Async)");
        }
        Call localVarCall = this.listUserOwnedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    public MultiListResponse listUserOwnedLists(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        ApiResponse<MultiListResponse> localVarResp;
        try {
            localVarResp = this.listUserOwnedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserOwnedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiListResponse listUserOwnedLists(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try {
            localVarResp = this.listUserOwnedLists(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserOwnedLists(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiListResponse> listUserOwnedListsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserOwnedListsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<MultiListResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserPinCall(ListPinRequest listPinRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListPinRequest localVarPostBody = listPinRequest;
        String localVarPath = "/2/users/{id}/pinned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserPinValidateBeforeCall(ListPinRequest listPinRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPin(Async)");
        }
        Call localVarCall = this.listUserPinCall(listPinRequest, id, _callback);
        return localVarCall;
    }

    public ListPinnedResponse listUserPin(ListPinRequest listPinRequest, String id) throws ApiException {
        ApiResponse<ListPinnedResponse> localVarResp;
        try {
            localVarResp = this.listUserPinWithHttpInfo(listPinRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserPinWithHttpInfo(listPinRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListPinnedResponse listUserPin(Integer retries, ListPinRequest listPinRequest, String id) throws ApiException {
        ListPinnedResponse localVarResp;
        try {
            localVarResp = this.listUserPin(listPinRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserPin(retries - 1, listPinRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListPinnedResponse> listUserPinWithHttpInfo(ListPinRequest listPinRequest, String id) throws ApiException {
        Call localVarCall = this.listUserPinValidateBeforeCall(listPinRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserPinAsync(ListPinRequest listPinRequest, String id, ApiCallback<ListPinnedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserPinValidateBeforeCall(listPinRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserPinnedListsCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/pinned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserPinnedListsValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPinnedLists(Async)");
        }
        Call localVarCall = this.listUserPinnedListsCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    public MultiListNoPaginationResponse listUserPinnedLists(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        ApiResponse<MultiListNoPaginationResponse> localVarResp;
        try {
            localVarResp = this.listUserPinnedListsWithHttpInfo(id, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserPinnedListsWithHttpInfo(id, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiListNoPaginationResponse listUserPinnedLists(Integer retries, String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListNoPaginationResponse localVarResp;
        try {
            localVarResp = this.listUserPinnedLists(id, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserPinnedLists(retries - 1, id, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiListNoPaginationResponse> listUserPinnedListsWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListNoPaginationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserPinnedListsAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<MultiListNoPaginationResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListNoPaginationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserUnfollowCall(String id, String listId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followed_lists/{list_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{list_id\\}", this.localVarApiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserUnfollowValidateBeforeCall(String id, String listId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnfollow(Async)");
        }
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnfollow(Async)");
        }
        Call localVarCall = this.listUserUnfollowCall(id, listId, _callback);
        return localVarCall;
    }

    public ListFollowedResponse listUserUnfollow(String id, String listId) throws ApiException {
        ApiResponse<ListFollowedResponse> localVarResp;
        try {
            localVarResp = this.listUserUnfollowWithHttpInfo(id, listId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserUnfollowWithHttpInfo(id, listId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListFollowedResponse listUserUnfollow(Integer retries, String id, String listId) throws ApiException {
        ListFollowedResponse localVarResp;
        try {
            localVarResp = this.listUserUnfollow(id, listId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserUnfollow(retries - 1, id, listId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListFollowedResponse> listUserUnfollowWithHttpInfo(String id, String listId) throws ApiException {
        Call localVarCall = this.listUserUnfollowValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserUnfollowAsync(String id, String listId, ApiCallback<ListFollowedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserUnfollowValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserUnpinCall(String id, String listId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/pinned_lists/{list_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{list_id\\}", this.localVarApiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserUnpinValidateBeforeCall(String id, String listId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnpin(Async)");
        }
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnpin(Async)");
        }
        Call localVarCall = this.listUserUnpinCall(id, listId, _callback);
        return localVarCall;
    }

    public ListPinnedResponse listUserUnpin(String id, String listId) throws ApiException {
        ApiResponse<ListPinnedResponse> localVarResp;
        try {
            localVarResp = this.listUserUnpinWithHttpInfo(id, listId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listUserUnpinWithHttpInfo(id, listId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListPinnedResponse listUserUnpin(Integer retries, String id, String listId) throws ApiException {
        ListPinnedResponse localVarResp;
        try {
            localVarResp = this.listUserUnpin(id, listId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listUserUnpin(retries - 1, id, listId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListPinnedResponse> listUserUnpinWithHttpInfo(String id, String listId) throws ApiException {
        Call localVarCall = this.listUserUnpinValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listUserUnpinAsync(String id, String listId, ApiCallback<ListPinnedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserUnpinValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call userFollowedListsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followed_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call userFollowedListsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling userFollowedLists(Async)");
        }
        Call localVarCall = this.userFollowedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    public MultiListResponse userFollowedLists(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        ApiResponse<MultiListResponse> localVarResp;
        try {
            localVarResp = this.userFollowedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.userFollowedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiListResponse userFollowedLists(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try {
            localVarResp = this.userFollowedLists(id, maxResults, paginationToken, listFields, expansions, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.userFollowedLists(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiListResponse> userFollowedListsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call userFollowedListsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<MultiListResponse> _callback) throws ApiException {
        Call localVarCall = this.userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

