/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.MultiSpaceLookupResponse;
import com.twitter.clientlib.model.MultiTweetLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.SingleSpaceLookupResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class SpacesApi
extends ApiCommon {
    public Call findSpaceByIdCall(String id, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpaceByIdValidateBeforeCall(String id, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findSpaceById(Async)");
        }
        Call localVarCall = this.findSpaceByIdCall(id, spaceFields, expansions, _callback);
        return localVarCall;
    }

    public SingleSpaceLookupResponse findSpaceById(String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        ApiResponse<SingleSpaceLookupResponse> localVarResp;
        try {
            localVarResp = this.findSpaceByIdWithHttpInfo(id, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findSpaceByIdWithHttpInfo(id, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleSpaceLookupResponse findSpaceById(Integer retries, String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        SingleSpaceLookupResponse localVarResp;
        try {
            localVarResp = this.findSpaceById(id, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findSpaceById(retries - 1, id, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleSpaceLookupResponse> findSpaceByIdWithHttpInfo(String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        Call localVarCall = this.findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<SingleSpaceLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findSpaceByIdAsync(String id, Set<String> spaceFields, Set<String> expansions, ApiCallback<SingleSpaceLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<SingleSpaceLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findSpacesByCreatorIdsCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/by/creator_ids";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "user_ids", userIds));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpacesByCreatorIdsValidateBeforeCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        if (userIds == null) {
            throw new ApiException("Missing the required parameter 'userIds' when calling findSpacesByCreatorIds(Async)");
        }
        Call localVarCall = this.findSpacesByCreatorIdsCall(userIds, spaceFields, expansions, _callback);
        return localVarCall;
    }

    public MultiSpaceLookupResponse findSpacesByCreatorIds(List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        ApiResponse<MultiSpaceLookupResponse> localVarResp;
        try {
            localVarResp = this.findSpacesByCreatorIdsWithHttpInfo(userIds, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findSpacesByCreatorIdsWithHttpInfo(userIds, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiSpaceLookupResponse findSpacesByCreatorIds(Integer retries, List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try {
            localVarResp = this.findSpacesByCreatorIds(userIds, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findSpacesByCreatorIds(retries - 1, userIds, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiSpaceLookupResponse> findSpacesByCreatorIdsWithHttpInfo(List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        Call localVarCall = this.findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findSpacesByCreatorIdsAsync(List<String> userIds, Set<String> spaceFields, Set<String> expansions, ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findSpacesByIdsCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "ids", ids));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpacesByIdsValidateBeforeCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findSpacesByIds(Async)");
        }
        Call localVarCall = this.findSpacesByIdsCall(ids, spaceFields, expansions, _callback);
        return localVarCall;
    }

    public MultiSpaceLookupResponse findSpacesByIds(List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        ApiResponse<MultiSpaceLookupResponse> localVarResp;
        try {
            localVarResp = this.findSpacesByIdsWithHttpInfo(ids, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findSpacesByIdsWithHttpInfo(ids, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiSpaceLookupResponse findSpacesByIds(Integer retries, List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try {
            localVarResp = this.findSpacesByIds(ids, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findSpacesByIds(retries - 1, ids, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiSpaceLookupResponse> findSpacesByIdsWithHttpInfo(List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        Call localVarCall = this.findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findSpacesByIdsAsync(List<String> ids, Set<String> spaceFields, Set<String> expansions, ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchSpacesCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("state", state));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call searchSpacesValidateBeforeCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling searchSpaces(Async)");
        }
        Call localVarCall = this.searchSpacesCall(query, state, maxResults, spaceFields, expansions, _callback);
        return localVarCall;
    }

    public MultiSpaceLookupResponse searchSpaces(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        ApiResponse<MultiSpaceLookupResponse> localVarResp;
        try {
            localVarResp = this.searchSpacesWithHttpInfo(query, state, maxResults, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.searchSpacesWithHttpInfo(query, state, maxResults, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiSpaceLookupResponse searchSpaces(Integer retries, String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try {
            localVarResp = this.searchSpaces(query, state, maxResults, spaceFields, expansions);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.searchSpaces(retries - 1, query, state, maxResults, spaceFields, expansions);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiSpaceLookupResponse> searchSpacesWithHttpInfo(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        Call localVarCall = this.searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call searchSpacesAsync(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call spaceBuyersCall(String id, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/buyers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceBuyersValidateBeforeCall(String id, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        Call localVarCall = this.spaceBuyersCall(id, userFields, _callback);
        return localVarCall;
    }

    public MultiUserLookupResponse spaceBuyers(String id, Set<String> userFields) throws ApiException {
        ApiResponse<MultiUserLookupResponse> localVarResp;
        try {
            localVarResp = this.spaceBuyersWithHttpInfo(id, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.spaceBuyersWithHttpInfo(id, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiUserLookupResponse spaceBuyers(Integer retries, String id, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try {
            localVarResp = this.spaceBuyers(id, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.spaceBuyers(retries - 1, id, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiUserLookupResponse> spaceBuyersWithHttpInfo(String id, Set<String> userFields) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call spaceBuyersAsync(String id, Set<String> userFields, ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call spaceTweetsCall(Integer maxResults, String id, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceTweetsValidateBeforeCall(Integer maxResults, String id, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        Call localVarCall = this.spaceTweetsCall(maxResults, id, tweetFields, _callback);
        return localVarCall;
    }

    public MultiTweetLookupResponse spaceTweets(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        ApiResponse<MultiTweetLookupResponse> localVarResp;
        try {
            localVarResp = this.spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiTweetLookupResponse spaceTweets(Integer retries, Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try {
            localVarResp = this.spaceTweets(maxResults, id, tweetFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.spaceTweets(retries - 1, maxResults, id, tweetFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiTweetLookupResponse> spaceTweetsWithHttpInfo(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call spaceTweetsAsync(Integer maxResults, String id, Set<String> tweetFields, ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

