/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.AddOrDeleteRulesRequest;
import com.twitter.clientlib.model.AddOrDeleteRulesResponse;
import com.twitter.clientlib.model.CreateTweetRequest;
import com.twitter.clientlib.model.FilteredStreamingTweet;
import com.twitter.clientlib.model.GenericTweetsTimelineResponse;
import com.twitter.clientlib.model.GetRulesResponse;
import com.twitter.clientlib.model.Granularity;
import com.twitter.clientlib.model.HideReplyByIdRequest;
import com.twitter.clientlib.model.HideReplyByIdResponse;
import com.twitter.clientlib.model.ListsIdTweetsResponse;
import com.twitter.clientlib.model.MultiTweetLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.QuoteTweetLookupResponse;
import com.twitter.clientlib.model.SingleTweetLookupResponse;
import com.twitter.clientlib.model.StreamingTweet;
import com.twitter.clientlib.model.TweetCountsResponse;
import com.twitter.clientlib.model.TweetCreateResponse;
import com.twitter.clientlib.model.TweetDeleteResponse;
import com.twitter.clientlib.model.TweetSearchResponse;
import com.twitter.clientlib.model.UsersIdLikedTweetsResponse;
import com.twitter.clientlib.model.UsersLikesCreateRequest;
import com.twitter.clientlib.model.UsersLikesCreateResponse;
import com.twitter.clientlib.model.UsersLikesDeleteResponse;
import com.twitter.clientlib.model.UsersRetweetsCreateRequest;
import com.twitter.clientlib.model.UsersRetweetsCreateResponse;
import com.twitter.clientlib.model.UsersRetweetsDeleteResponse;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class TweetsApi
extends ApiCommon {
    public Call addOrDeleteRulesCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        AddOrDeleteRulesRequest localVarPostBody = addOrDeleteRulesRequest;
        String localVarPath = "/2/tweets/search/stream/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dry_run", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call addOrDeleteRulesValidateBeforeCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback _callback) throws ApiException {
        if (addOrDeleteRulesRequest == null) {
            throw new ApiException("Missing the required parameter 'addOrDeleteRulesRequest' when calling addOrDeleteRules(Async)");
        }
        Call localVarCall = this.addOrDeleteRulesCall(addOrDeleteRulesRequest, dryRun, _callback);
        return localVarCall;
    }

    public AddOrDeleteRulesResponse addOrDeleteRules(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        ApiResponse<AddOrDeleteRulesResponse> localVarResp;
        try {
            localVarResp = this.addOrDeleteRulesWithHttpInfo(addOrDeleteRulesRequest, dryRun);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.addOrDeleteRulesWithHttpInfo(addOrDeleteRulesRequest, dryRun);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public AddOrDeleteRulesResponse addOrDeleteRules(Integer retries, AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        AddOrDeleteRulesResponse localVarResp;
        try {
            localVarResp = this.addOrDeleteRules(addOrDeleteRulesRequest, dryRun);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.addOrDeleteRules(retries - 1, addOrDeleteRulesRequest, dryRun);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<AddOrDeleteRulesResponse> addOrDeleteRulesWithHttpInfo(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        Call localVarCall = this.addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, null);
        try {
            Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call addOrDeleteRulesAsync(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback<AddOrDeleteRulesResponse> _callback) throws ApiException {
        Call localVarCall = this.addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, _callback);
        Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createTweetCall(CreateTweetRequest createTweetRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        CreateTweetRequest localVarPostBody = createTweetRequest;
        String localVarPath = "/2/tweets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call createTweetValidateBeforeCall(CreateTweetRequest createTweetRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createTweetCall(createTweetRequest, _callback);
        return localVarCall;
    }

    public TweetCreateResponse createTweet(CreateTweetRequest createTweetRequest) throws ApiException {
        ApiResponse<TweetCreateResponse> localVarResp;
        try {
            localVarResp = this.createTweetWithHttpInfo(createTweetRequest);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.createTweetWithHttpInfo(createTweetRequest);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetCreateResponse createTweet(Integer retries, CreateTweetRequest createTweetRequest) throws ApiException {
        TweetCreateResponse localVarResp;
        try {
            localVarResp = this.createTweet(createTweetRequest);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.createTweet(retries - 1, createTweetRequest);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetCreateResponse> createTweetWithHttpInfo(CreateTweetRequest createTweetRequest) throws ApiException {
        Call localVarCall = this.createTweetValidateBeforeCall(createTweetRequest, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call createTweetAsync(CreateTweetRequest createTweetRequest, ApiCallback<TweetCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.createTweetValidateBeforeCall(createTweetRequest, _callback);
        Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTweetByIdCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call deleteTweetByIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTweetById(Async)");
        }
        Call localVarCall = this.deleteTweetByIdCall(id, _callback);
        return localVarCall;
    }

    public TweetDeleteResponse deleteTweetById(String id) throws ApiException {
        ApiResponse<TweetDeleteResponse> localVarResp;
        try {
            localVarResp = this.deleteTweetByIdWithHttpInfo(id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.deleteTweetByIdWithHttpInfo(id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetDeleteResponse deleteTweetById(Integer retries, String id) throws ApiException {
        TweetDeleteResponse localVarResp;
        try {
            localVarResp = this.deleteTweetById(id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.deleteTweetById(retries - 1, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetDeleteResponse> deleteTweetByIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteTweetByIdValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call deleteTweetByIdAsync(String id, ApiCallback<TweetDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteTweetByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findTweetByIdCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetByIdValidateBeforeCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetById(Async)");
        }
        Call localVarCall = this.findTweetByIdCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public SingleTweetLookupResponse findTweetById(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<SingleTweetLookupResponse> localVarResp;
        try {
            localVarResp = this.findTweetByIdWithHttpInfo(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findTweetByIdWithHttpInfo(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleTweetLookupResponse findTweetById(Integer retries, String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        SingleTweetLookupResponse localVarResp;
        try {
            localVarResp = this.findTweetById(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findTweetById(retries - 1, id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleTweetLookupResponse> findTweetByIdWithHttpInfo(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.findTweetByIdValidateBeforeCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleTweetLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findTweetByIdAsync(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<SingleTweetLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetByIdValidateBeforeCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<SingleTweetLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findTweetsByIdCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "ids", ids));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetsByIdValidateBeforeCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findTweetsById(Async)");
        }
        Call localVarCall = this.findTweetsByIdCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public MultiTweetLookupResponse findTweetsById(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<MultiTweetLookupResponse> localVarResp;
        try {
            localVarResp = this.findTweetsByIdWithHttpInfo(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findTweetsByIdWithHttpInfo(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiTweetLookupResponse findTweetsById(Integer retries, List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try {
            localVarResp = this.findTweetsById(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findTweetsById(retries - 1, ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiTweetLookupResponse> findTweetsByIdWithHttpInfo(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.findTweetsByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findTweetsByIdAsync(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetsByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findTweetsThatQuoteATweetCall(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/quote_tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetsThatQuoteATweetValidateBeforeCall(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetsThatQuoteATweet(Async)");
        }
        Call localVarCall = this.findTweetsThatQuoteATweetCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public QuoteTweetLookupResponse findTweetsThatQuoteATweet(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<QuoteTweetLookupResponse> localVarResp;
        try {
            localVarResp = this.findTweetsThatQuoteATweetWithHttpInfo(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findTweetsThatQuoteATweetWithHttpInfo(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public QuoteTweetLookupResponse findTweetsThatQuoteATweet(Integer retries, String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        QuoteTweetLookupResponse localVarResp;
        try {
            localVarResp = this.findTweetsThatQuoteATweet(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findTweetsThatQuoteATweet(retries - 1, id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<QuoteTweetLookupResponse> findTweetsThatQuoteATweetWithHttpInfo(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<QuoteTweetLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findTweetsThatQuoteATweetAsync(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<QuoteTweetLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<QuoteTweetLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRulesCall(List<String> ids, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/stream/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "ids", ids));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getRulesValidateBeforeCall(List<String> ids, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getRulesCall(ids, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GetRulesResponse getRules(List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GetRulesResponse> localVarResp;
        try {
            localVarResp = this.getRulesWithHttpInfo(ids, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.getRulesWithHttpInfo(ids, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GetRulesResponse getRules(Integer retries, List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        GetRulesResponse localVarResp;
        try {
            localVarResp = this.getRules(ids, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.getRules(retries - 1, ids, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GetRulesResponse> getRulesWithHttpInfo(List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.getRulesValidateBeforeCall(ids, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GetRulesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call getRulesAsync(List<String> ids, Integer maxResults, String paginationToken, ApiCallback<GetRulesResponse> _callback) throws ApiException {
        Call localVarCall = this.getRulesValidateBeforeCall(ids, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GetRulesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call hideReplyByIdCall(HideReplyByIdRequest hideReplyByIdRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        HideReplyByIdRequest localVarPostBody = hideReplyByIdRequest;
        String localVarPath = "/2/tweets/{id}/hidden".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call hideReplyByIdValidateBeforeCall(HideReplyByIdRequest hideReplyByIdRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling hideReplyById(Async)");
        }
        Call localVarCall = this.hideReplyByIdCall(hideReplyByIdRequest, id, _callback);
        return localVarCall;
    }

    public HideReplyByIdResponse hideReplyById(HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
        ApiResponse<HideReplyByIdResponse> localVarResp;
        try {
            localVarResp = this.hideReplyByIdWithHttpInfo(hideReplyByIdRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.hideReplyByIdWithHttpInfo(hideReplyByIdRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public HideReplyByIdResponse hideReplyById(Integer retries, HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
        HideReplyByIdResponse localVarResp;
        try {
            localVarResp = this.hideReplyById(hideReplyByIdRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.hideReplyById(retries - 1, hideReplyByIdRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<HideReplyByIdResponse> hideReplyByIdWithHttpInfo(HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
        Call localVarCall = this.hideReplyByIdValidateBeforeCall(hideReplyByIdRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<HideReplyByIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call hideReplyByIdAsync(HideReplyByIdRequest hideReplyByIdRequest, String id, ApiCallback<HideReplyByIdResponse> _callback) throws ApiException {
        Call localVarCall = this.hideReplyByIdValidateBeforeCall(hideReplyByIdRequest, id, _callback);
        Type localVarReturnType = new TypeToken<HideReplyByIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listsIdTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listsIdTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listsIdTweets(Async)");
        }
        Call localVarCall = this.listsIdTweetsCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public ListsIdTweetsResponse listsIdTweets(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<ListsIdTweetsResponse> localVarResp;
        try {
            localVarResp = this.listsIdTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listsIdTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListsIdTweetsResponse listsIdTweets(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ListsIdTweetsResponse localVarResp;
        try {
            localVarResp = this.listsIdTweets(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listsIdTweets(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListsIdTweetsResponse> listsIdTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListsIdTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listsIdTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<ListsIdTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<ListsIdTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sampleStreamCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/sample/stream";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (backfillMinutes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call sampleStreamValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.sampleStreamCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        return localVarCall;
    }

    public InputStream sampleStream(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp = this.sampleStreamWithHttpInfo(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        return localVarResp;
    }

    public InputStream sampleStream(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp;
        try {
            localVarResp = this.sampleStream(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.sampleStream(retries - 1, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
            }
            throw e;
        }
        return localVarResp;
    }

    public InputStream sampleStreamWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        Call localVarCall = this.sampleStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, null);
        try {
            Type localVarReturnType = new TypeToken<StreamingTweet>(){}.getType();
            return this.localVarApiClient.executeStream(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call sampleStreamAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback<StreamingTweet> _callback) throws ApiException {
        Call localVarCall = this.sampleStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        Type localVarReturnType = new TypeToken<StreamingTweet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchStreamCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/stream";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (backfillMinutes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call searchStreamValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.searchStreamCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        return localVarCall;
    }

    public InputStream searchStream(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp = this.searchStreamWithHttpInfo(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        return localVarResp;
    }

    public InputStream searchStream(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp;
        try {
            localVarResp = this.searchStream(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.searchStream(retries - 1, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
            }
            throw e;
        }
        return localVarResp;
    }

    public InputStream searchStreamWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        Call localVarCall = this.searchStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, null);
        try {
            Type localVarReturnType = new TypeToken<FilteredStreamingTweet>(){}.getType();
            return this.localVarApiClient.executeStream(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call searchStreamAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, ApiCallback<FilteredStreamingTweet> _callback) throws ApiException {
        Call localVarCall = this.searchStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        Type localVarReturnType = new TypeToken<FilteredStreamingTweet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call spaceBuyersCall(String id, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/buyers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceBuyersValidateBeforeCall(String id, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        Call localVarCall = this.spaceBuyersCall(id, userFields, _callback);
        return localVarCall;
    }

    public MultiUserLookupResponse spaceBuyers(String id, Set<String> userFields) throws ApiException {
        ApiResponse<MultiUserLookupResponse> localVarResp;
        try {
            localVarResp = this.spaceBuyersWithHttpInfo(id, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.spaceBuyersWithHttpInfo(id, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiUserLookupResponse spaceBuyers(Integer retries, String id, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try {
            localVarResp = this.spaceBuyers(id, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.spaceBuyers(retries - 1, id, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiUserLookupResponse> spaceBuyersWithHttpInfo(String id, Set<String> userFields) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call spaceBuyersAsync(String id, Set<String> userFields, ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call spaceTweetsCall(Integer maxResults, String id, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceTweetsValidateBeforeCall(Integer maxResults, String id, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        Call localVarCall = this.spaceTweetsCall(maxResults, id, tweetFields, _callback);
        return localVarCall;
    }

    public MultiTweetLookupResponse spaceTweets(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        ApiResponse<MultiTweetLookupResponse> localVarResp;
        try {
            localVarResp = this.spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiTweetLookupResponse spaceTweets(Integer retries, Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try {
            localVarResp = this.spaceTweets(maxResults, id, tweetFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.spaceTweets(retries - 1, maxResults, id, tweetFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiTweetLookupResponse> spaceTweetsWithHttpInfo(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call spaceTweetsAsync(Integer maxResults, String id, Set<String> tweetFields, ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetCountsFullArchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/counts/all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("granularity", (Object)granularity));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetCountsFullArchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsFullArchiveSearch(Async)");
        }
        Call localVarCall = this.tweetCountsFullArchiveSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        return localVarCall;
    }

    public TweetCountsResponse tweetCountsFullArchiveSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        ApiResponse<TweetCountsResponse> localVarResp;
        try {
            localVarResp = this.tweetCountsFullArchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetCountsFullArchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetCountsResponse tweetCountsFullArchiveSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        TweetCountsResponse localVarResp;
        try {
            localVarResp = this.tweetCountsFullArchiveSearch(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetCountsFullArchiveSearch(retries - 1, query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetCountsResponse> tweetCountsFullArchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        Call localVarCall = this.tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetCountsFullArchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback<TweetCountsResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetCountsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/counts/recent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("granularity", (Object)granularity));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetCountsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsRecentSearch(Async)");
        }
        Call localVarCall = this.tweetCountsRecentSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        return localVarCall;
    }

    public TweetCountsResponse tweetCountsRecentSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        ApiResponse<TweetCountsResponse> localVarResp;
        try {
            localVarResp = this.tweetCountsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetCountsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetCountsResponse tweetCountsRecentSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        TweetCountsResponse localVarResp;
        try {
            localVarResp = this.tweetCountsRecentSearch(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetCountsRecentSearch(retries - 1, query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetCountsResponse> tweetCountsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        Call localVarCall = this.tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetCountsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, ApiCallback<TweetCountsResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetsFullarchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsFullarchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsFullarchiveSearch(Async)");
        }
        Call localVarCall = this.tweetsFullarchiveSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public TweetSearchResponse tweetsFullarchiveSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<TweetSearchResponse> localVarResp;
        try {
            localVarResp = this.tweetsFullarchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetsFullarchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetSearchResponse tweetsFullarchiveSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        TweetSearchResponse localVarResp;
        try {
            localVarResp = this.tweetsFullarchiveSearch(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetsFullarchiveSearch(retries - 1, query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetSearchResponse> tweetsFullarchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetsFullarchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<TweetSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/recent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsRecentSearch(Async)");
        }
        Call localVarCall = this.tweetsRecentSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public TweetSearchResponse tweetsRecentSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<TweetSearchResponse> localVarResp;
        try {
            localVarResp = this.tweetsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public TweetSearchResponse tweetsRecentSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        TweetSearchResponse localVarResp;
        try {
            localVarResp = this.tweetsRecentSearch(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetsRecentSearch(retries - 1, query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<TweetSearchResponse> tweetsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<TweetSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdLikeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersLikesCreateRequest localVarPostBody = usersLikesCreateRequest;
        String localVarPath = "/2/users/{id}/likes".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdLikeValidateBeforeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLike(Async)");
        }
        Call localVarCall = this.usersIdLikeCall(usersLikesCreateRequest, id, _callback);
        return localVarCall;
    }

    public UsersLikesCreateResponse usersIdLike(UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        ApiResponse<UsersLikesCreateResponse> localVarResp;
        try {
            localVarResp = this.usersIdLikeWithHttpInfo(usersLikesCreateRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdLikeWithHttpInfo(usersLikesCreateRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersLikesCreateResponse usersIdLike(Integer retries, UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        UsersLikesCreateResponse localVarResp;
        try {
            localVarResp = this.usersIdLike(usersLikesCreateRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdLike(retries - 1, usersLikesCreateRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersLikesCreateResponse> usersIdLikeWithHttpInfo(UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdLikeAsync(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback<UsersLikesCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdLikedTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/liked_tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdLikedTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLikedTweets(Async)");
        }
        Call localVarCall = this.usersIdLikedTweetsCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public UsersIdLikedTweetsResponse usersIdLikedTweets(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<UsersIdLikedTweetsResponse> localVarResp;
        try {
            localVarResp = this.usersIdLikedTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdLikedTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersIdLikedTweetsResponse usersIdLikedTweets(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        UsersIdLikedTweetsResponse localVarResp;
        try {
            localVarResp = this.usersIdLikedTweets(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdLikedTweets(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersIdLikedTweetsResponse> usersIdLikedTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<UsersIdLikedTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdLikedTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<UsersIdLikedTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<UsersIdLikedTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdMentionsCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/mentions".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMentionsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMentions(Async)");
        }
        Call localVarCall = this.usersIdMentionsCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public GenericTweetsTimelineResponse usersIdMentions(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<GenericTweetsTimelineResponse> localVarResp;
        try {
            localVarResp = this.usersIdMentionsWithHttpInfo(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdMentionsWithHttpInfo(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericTweetsTimelineResponse usersIdMentions(Integer retries, String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try {
            localVarResp = this.usersIdMentions(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdMentions(retries - 1, id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericTweetsTimelineResponse> usersIdMentionsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdMentionsAsync(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdRetweetsCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersRetweetsCreateRequest localVarPostBody = usersRetweetsCreateRequest;
        String localVarPath = "/2/users/{id}/retweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdRetweetsValidateBeforeCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdRetweets(Async)");
        }
        Call localVarCall = this.usersIdRetweetsCall(usersRetweetsCreateRequest, id, _callback);
        return localVarCall;
    }

    public UsersRetweetsCreateResponse usersIdRetweets(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        ApiResponse<UsersRetweetsCreateResponse> localVarResp;
        try {
            localVarResp = this.usersIdRetweetsWithHttpInfo(usersRetweetsCreateRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdRetweetsWithHttpInfo(usersRetweetsCreateRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersRetweetsCreateResponse usersIdRetweets(Integer retries, UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        UsersRetweetsCreateResponse localVarResp;
        try {
            localVarResp = this.usersIdRetweets(usersRetweetsCreateRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdRetweets(retries - 1, usersRetweetsCreateRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersRetweetsCreateResponse> usersIdRetweetsWithHttpInfo(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdRetweetsAsync(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback<UsersRetweetsCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdTimelineCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/timelines/reverse_chronological".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdTimelineValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTimeline(Async)");
        }
        Call localVarCall = this.usersIdTimelineCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public GenericTweetsTimelineResponse usersIdTimeline(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<GenericTweetsTimelineResponse> localVarResp;
        try {
            localVarResp = this.usersIdTimelineWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdTimelineWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericTweetsTimelineResponse usersIdTimeline(Integer retries, String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try {
            localVarResp = this.usersIdTimeline(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdTimeline(retries - 1, id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericTweetsTimelineResponse> usersIdTimelineWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdTimelineAsync(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdTweetsCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdTweetsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTweets(Async)");
        }
        Call localVarCall = this.usersIdTweetsCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;
    }

    public GenericTweetsTimelineResponse usersIdTweets(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ApiResponse<GenericTweetsTimelineResponse> localVarResp;
        try {
            localVarResp = this.usersIdTweetsWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdTweetsWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericTweetsTimelineResponse usersIdTweets(Integer retries, String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try {
            localVarResp = this.usersIdTweets(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdTweets(retries - 1, id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericTweetsTimelineResponse> usersIdTweetsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        Call localVarCall = this.usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdTweetsAsync(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdUnlikeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/likes/{tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{tweet_id\\}", this.localVarApiClient.escapeString(tweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnlikeValidateBeforeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnlike(Async)");
        }
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdUnlike(Async)");
        }
        Call localVarCall = this.usersIdUnlikeCall(id, tweetId, _callback);
        return localVarCall;
    }

    public UsersLikesDeleteResponse usersIdUnlike(String id, String tweetId) throws ApiException {
        ApiResponse<UsersLikesDeleteResponse> localVarResp;
        try {
            localVarResp = this.usersIdUnlikeWithHttpInfo(id, tweetId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdUnlikeWithHttpInfo(id, tweetId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersLikesDeleteResponse usersIdUnlike(Integer retries, String id, String tweetId) throws ApiException {
        UsersLikesDeleteResponse localVarResp;
        try {
            localVarResp = this.usersIdUnlike(id, tweetId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdUnlike(retries - 1, id, tweetId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersLikesDeleteResponse> usersIdUnlikeWithHttpInfo(String id, String tweetId) throws ApiException {
        Call localVarCall = this.usersIdUnlikeValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdUnlikeAsync(String id, String tweetId, ApiCallback<UsersLikesDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnlikeValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdUnretweetsCall(String id, String sourceTweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/retweets/{source_tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{source_tweet_id\\}", this.localVarApiClient.escapeString(sourceTweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnretweetsValidateBeforeCall(String id, String sourceTweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnretweets(Async)");
        }
        if (sourceTweetId == null) {
            throw new ApiException("Missing the required parameter 'sourceTweetId' when calling usersIdUnretweets(Async)");
        }
        Call localVarCall = this.usersIdUnretweetsCall(id, sourceTweetId, _callback);
        return localVarCall;
    }

    public UsersRetweetsDeleteResponse usersIdUnretweets(String id, String sourceTweetId) throws ApiException {
        ApiResponse<UsersRetweetsDeleteResponse> localVarResp;
        try {
            localVarResp = this.usersIdUnretweetsWithHttpInfo(id, sourceTweetId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdUnretweetsWithHttpInfo(id, sourceTweetId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersRetweetsDeleteResponse usersIdUnretweets(Integer retries, String id, String sourceTweetId) throws ApiException {
        UsersRetweetsDeleteResponse localVarResp;
        try {
            localVarResp = this.usersIdUnretweets(id, sourceTweetId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdUnretweets(retries - 1, id, sourceTweetId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersRetweetsDeleteResponse> usersIdUnretweetsWithHttpInfo(String id, String sourceTweetId) throws ApiException {
        Call localVarCall = this.usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdUnretweetsAsync(String id, String sourceTweetId, ApiCallback<UsersRetweetsDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

