/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.GenericMultipleUsersLookupResponse;
import com.twitter.clientlib.model.ListLookupMultipleUsersLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.SingleUserLookupResponse;
import com.twitter.clientlib.model.UsersBlockingMutationResponse;
import com.twitter.clientlib.model.UsersFollowingCreateResponse;
import com.twitter.clientlib.model.UsersFollowingDeleteResponse;
import com.twitter.clientlib.model.UsersFollowingLookupResponse;
import com.twitter.clientlib.model.UsersIdBlockRequest;
import com.twitter.clientlib.model.UsersIdFollowRequest;
import com.twitter.clientlib.model.UsersIdMuteRequest;
import com.twitter.clientlib.model.UsersMutingMutationResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import okhttp3.Call;

public class UsersApi
extends ApiCommon {
    public Call findMyUserCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/me";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findMyUserValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.findMyUserCall(expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public SingleUserLookupResponse findMyUser(Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<SingleUserLookupResponse> localVarResp;
        try {
            localVarResp = this.findMyUserWithHttpInfo(expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findMyUserWithHttpInfo(expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleUserLookupResponse findMyUser(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try {
            localVarResp = this.findMyUser(expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findMyUser(retries - 1, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleUserLookupResponse> findMyUserWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.findMyUserValidateBeforeCall(expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findMyUserAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findMyUserValidateBeforeCall(expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findUserByIdCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUserByIdValidateBeforeCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findUserById(Async)");
        }
        Call localVarCall = this.findUserByIdCall(id, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public SingleUserLookupResponse findUserById(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<SingleUserLookupResponse> localVarResp;
        try {
            localVarResp = this.findUserByIdWithHttpInfo(id, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findUserByIdWithHttpInfo(id, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleUserLookupResponse findUserById(Integer retries, String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try {
            localVarResp = this.findUserById(id, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findUserById(retries - 1, id, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleUserLookupResponse> findUserByIdWithHttpInfo(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.findUserByIdValidateBeforeCall(id, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findUserByIdAsync(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findUserByIdValidateBeforeCall(id, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findUserByUsernameCall(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/by/username/{username}".replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUserByUsernameValidateBeforeCall(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling findUserByUsername(Async)");
        }
        Call localVarCall = this.findUserByUsernameCall(username, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public SingleUserLookupResponse findUserByUsername(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<SingleUserLookupResponse> localVarResp;
        try {
            localVarResp = this.findUserByUsernameWithHttpInfo(username, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findUserByUsernameWithHttpInfo(username, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public SingleUserLookupResponse findUserByUsername(Integer retries, String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try {
            localVarResp = this.findUserByUsername(username, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findUserByUsername(retries - 1, username, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<SingleUserLookupResponse> findUserByUsernameWithHttpInfo(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.findUserByUsernameValidateBeforeCall(username, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findUserByUsernameAsync(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findUserByUsernameValidateBeforeCall(username, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findUsersByIdCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "ids", ids));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUsersByIdValidateBeforeCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findUsersById(Async)");
        }
        Call localVarCall = this.findUsersByIdCall(ids, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public MultiUserLookupResponse findUsersById(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<MultiUserLookupResponse> localVarResp;
        try {
            localVarResp = this.findUsersByIdWithHttpInfo(ids, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findUsersByIdWithHttpInfo(ids, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiUserLookupResponse findUsersById(Integer retries, List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try {
            localVarResp = this.findUsersById(ids, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findUsersById(retries - 1, ids, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiUserLookupResponse> findUsersByIdWithHttpInfo(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.findUsersByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findUsersByIdAsync(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findUsersByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findUsersByUsernameCall(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/by";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (usernames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "usernames", usernames));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUsersByUsernameValidateBeforeCall(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (usernames == null) {
            throw new ApiException("Missing the required parameter 'usernames' when calling findUsersByUsername(Async)");
        }
        Call localVarCall = this.findUsersByUsernameCall(usernames, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public MultiUserLookupResponse findUsersByUsername(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<MultiUserLookupResponse> localVarResp;
        try {
            localVarResp = this.findUsersByUsernameWithHttpInfo(usernames, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.findUsersByUsernameWithHttpInfo(usernames, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public MultiUserLookupResponse findUsersByUsername(Integer retries, List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try {
            localVarResp = this.findUsersByUsername(usernames, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.findUsersByUsername(retries - 1, usernames, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<MultiUserLookupResponse> findUsersByUsernameWithHttpInfo(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.findUsersByUsernameValidateBeforeCall(usernames, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call findUsersByUsernameAsync(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.findUsersByUsernameValidateBeforeCall(usernames, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGetFollowersCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/followers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listGetFollowersValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetFollowers(Async)");
        }
        Call localVarCall = this.listGetFollowersCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public ListLookupMultipleUsersLookupResponse listGetFollowers(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<ListLookupMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.listGetFollowersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listGetFollowersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListLookupMultipleUsersLookupResponse listGetFollowers(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ListLookupMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.listGetFollowers(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listGetFollowers(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListLookupMultipleUsersLookupResponse> listGetFollowersWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listGetFollowersAsync(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<ListLookupMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGetMembersCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listGetMembersValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetMembers(Async)");
        }
        Call localVarCall = this.listGetMembersCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        return localVarCall;
    }

    public ListLookupMultipleUsersLookupResponse listGetMembers(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ApiResponse<ListLookupMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.listGetMembersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.listGetMembersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public ListLookupMultipleUsersLookupResponse listGetMembers(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ListLookupMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.listGetMembers(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.listGetMembers(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<ListLookupMultipleUsersLookupResponse> listGetMembersWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listGetMembersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call listGetMembersAsync(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, ApiCallback<ListLookupMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.listGetMembersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetsIdLikingUsersCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/liking_users".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsIdLikingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdLikingUsers(Async)");
        }
        Call localVarCall = this.tweetsIdLikingUsersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GenericMultipleUsersLookupResponse tweetsIdLikingUsers(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GenericMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.tweetsIdLikingUsersWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetsIdLikingUsersWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericMultipleUsersLookupResponse tweetsIdLikingUsers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.tweetsIdLikingUsers(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetsIdLikingUsers(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericMultipleUsersLookupResponse> tweetsIdLikingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetsIdLikingUsersAsync(String id, Integer maxResults, String paginationToken, ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call tweetsIdRetweetingUsersCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/retweeted_by".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsIdRetweetingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdRetweetingUsers(Async)");
        }
        Call localVarCall = this.tweetsIdRetweetingUsersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GenericMultipleUsersLookupResponse tweetsIdRetweetingUsers(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GenericMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.tweetsIdRetweetingUsersWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.tweetsIdRetweetingUsersWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericMultipleUsersLookupResponse tweetsIdRetweetingUsers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.tweetsIdRetweetingUsers(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.tweetsIdRetweetingUsers(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericMultipleUsersLookupResponse> tweetsIdRetweetingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call tweetsIdRetweetingUsersAsync(String id, Integer maxResults, String paginationToken, ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdBlockCall(UsersIdBlockRequest usersIdBlockRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersIdBlockRequest localVarPostBody = usersIdBlockRequest;
        String localVarPath = "/2/users/{id}/blocking".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBlockValidateBeforeCall(UsersIdBlockRequest usersIdBlockRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlock(Async)");
        }
        Call localVarCall = this.usersIdBlockCall(usersIdBlockRequest, id, _callback);
        return localVarCall;
    }

    public UsersBlockingMutationResponse usersIdBlock(UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
        ApiResponse<UsersBlockingMutationResponse> localVarResp;
        try {
            localVarResp = this.usersIdBlockWithHttpInfo(usersIdBlockRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdBlockWithHttpInfo(usersIdBlockRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersBlockingMutationResponse usersIdBlock(Integer retries, UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
        UsersBlockingMutationResponse localVarResp;
        try {
            localVarResp = this.usersIdBlock(usersIdBlockRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdBlock(retries - 1, usersIdBlockRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersBlockingMutationResponse> usersIdBlockWithHttpInfo(UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdBlockValidateBeforeCall(usersIdBlockRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdBlockAsync(UsersIdBlockRequest usersIdBlockRequest, String id, ApiCallback<UsersBlockingMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBlockValidateBeforeCall(usersIdBlockRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdBlockingCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/blocking".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBlockingValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlocking(Async)");
        }
        Call localVarCall = this.usersIdBlockingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GenericMultipleUsersLookupResponse usersIdBlocking(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GenericMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.usersIdBlockingWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdBlockingWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericMultipleUsersLookupResponse usersIdBlocking(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.usersIdBlocking(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdBlocking(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdBlockingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdBlockingAsync(String id, Integer maxResults, String paginationToken, ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdFollowCall(UsersIdFollowRequest usersIdFollowRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersIdFollowRequest localVarPostBody = usersIdFollowRequest;
        String localVarPath = "/2/users/{id}/following".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowValidateBeforeCall(UsersIdFollowRequest usersIdFollowRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollow(Async)");
        }
        Call localVarCall = this.usersIdFollowCall(usersIdFollowRequest, id, _callback);
        return localVarCall;
    }

    public UsersFollowingCreateResponse usersIdFollow(UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
        ApiResponse<UsersFollowingCreateResponse> localVarResp;
        try {
            localVarResp = this.usersIdFollowWithHttpInfo(usersIdFollowRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdFollowWithHttpInfo(usersIdFollowRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersFollowingCreateResponse usersIdFollow(Integer retries, UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
        UsersFollowingCreateResponse localVarResp;
        try {
            localVarResp = this.usersIdFollow(usersIdFollowRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdFollow(retries - 1, usersIdFollowRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersFollowingCreateResponse> usersIdFollowWithHttpInfo(UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdFollowValidateBeforeCall(usersIdFollowRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdFollowAsync(UsersIdFollowRequest usersIdFollowRequest, String id, ApiCallback<UsersFollowingCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowValidateBeforeCall(usersIdFollowRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdFollowersCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowersValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowers(Async)");
        }
        Call localVarCall = this.usersIdFollowersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GenericMultipleUsersLookupResponse usersIdFollowers(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GenericMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.usersIdFollowersWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdFollowersWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericMultipleUsersLookupResponse usersIdFollowers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.usersIdFollowers(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdFollowers(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdFollowersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdFollowersAsync(String id, Integer maxResults, String paginationToken, ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdFollowingCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/following".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowingValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowing(Async)");
        }
        Call localVarCall = this.usersIdFollowingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public UsersFollowingLookupResponse usersIdFollowing(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<UsersFollowingLookupResponse> localVarResp;
        try {
            localVarResp = this.usersIdFollowingWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdFollowingWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersFollowingLookupResponse usersIdFollowing(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        UsersFollowingLookupResponse localVarResp;
        try {
            localVarResp = this.usersIdFollowing(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdFollowing(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersFollowingLookupResponse> usersIdFollowingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdFollowingAsync(String id, Integer maxResults, String paginationToken, ApiCallback<UsersFollowingLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdMuteCall(UsersIdMuteRequest usersIdMuteRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersIdMuteRequest localVarPostBody = usersIdMuteRequest;
        String localVarPath = "/2/users/{id}/muting".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMuteValidateBeforeCall(UsersIdMuteRequest usersIdMuteRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMute(Async)");
        }
        Call localVarCall = this.usersIdMuteCall(usersIdMuteRequest, id, _callback);
        return localVarCall;
    }

    public UsersMutingMutationResponse usersIdMute(UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
        ApiResponse<UsersMutingMutationResponse> localVarResp;
        try {
            localVarResp = this.usersIdMuteWithHttpInfo(usersIdMuteRequest, id);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdMuteWithHttpInfo(usersIdMuteRequest, id);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersMutingMutationResponse usersIdMute(Integer retries, UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
        UsersMutingMutationResponse localVarResp;
        try {
            localVarResp = this.usersIdMute(usersIdMuteRequest, id);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdMute(retries - 1, usersIdMuteRequest, id);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersMutingMutationResponse> usersIdMuteWithHttpInfo(UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdMuteValidateBeforeCall(usersIdMuteRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdMuteAsync(UsersIdMuteRequest usersIdMuteRequest, String id, ApiCallback<UsersMutingMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMuteValidateBeforeCall(usersIdMuteRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdMutingCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/muting".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMutingValidateBeforeCall(String id, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMuting(Async)");
        }
        Call localVarCall = this.usersIdMutingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    public GenericMultipleUsersLookupResponse usersIdMuting(String id, Integer maxResults, String paginationToken) throws ApiException {
        ApiResponse<GenericMultipleUsersLookupResponse> localVarResp;
        try {
            localVarResp = this.usersIdMutingWithHttpInfo(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdMutingWithHttpInfo(id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public GenericMultipleUsersLookupResponse usersIdMuting(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try {
            localVarResp = this.usersIdMuting(id, maxResults, paginationToken);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdMuting(retries - 1, id, maxResults, paginationToken);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdMutingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdMutingAsync(String id, Integer maxResults, String paginationToken, ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdUnblockCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/blocking/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnblockValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnblock(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnblock(Async)");
        }
        Call localVarCall = this.usersIdUnblockCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    public UsersBlockingMutationResponse usersIdUnblock(String sourceUserId, String targetUserId) throws ApiException {
        ApiResponse<UsersBlockingMutationResponse> localVarResp;
        try {
            localVarResp = this.usersIdUnblockWithHttpInfo(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdUnblockWithHttpInfo(sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersBlockingMutationResponse usersIdUnblock(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersBlockingMutationResponse localVarResp;
        try {
            localVarResp = this.usersIdUnblock(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdUnblock(retries - 1, sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersBlockingMutationResponse> usersIdUnblockWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdUnblockAsync(String sourceUserId, String targetUserId, ApiCallback<UsersBlockingMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdUnfollowCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/following/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnfollowValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnfollow(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnfollow(Async)");
        }
        Call localVarCall = this.usersIdUnfollowCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    public UsersFollowingDeleteResponse usersIdUnfollow(String sourceUserId, String targetUserId) throws ApiException {
        ApiResponse<UsersFollowingDeleteResponse> localVarResp;
        try {
            localVarResp = this.usersIdUnfollowWithHttpInfo(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdUnfollowWithHttpInfo(sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersFollowingDeleteResponse usersIdUnfollow(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersFollowingDeleteResponse localVarResp;
        try {
            localVarResp = this.usersIdUnfollow(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdUnfollow(retries - 1, sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersFollowingDeleteResponse> usersIdUnfollowWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdUnfollowAsync(String sourceUserId, String targetUserId, ApiCallback<UsersFollowingDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call usersIdUnmuteCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/muting/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnmuteValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnmute(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnmute(Async)");
        }
        Call localVarCall = this.usersIdUnmuteCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    public UsersMutingMutationResponse usersIdUnmute(String sourceUserId, String targetUserId) throws ApiException {
        ApiResponse<UsersMutingMutationResponse> localVarResp;
        try {
            localVarResp = this.usersIdUnmuteWithHttpInfo(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.isOAUth2AutoRefreshToken() && e.getCode() == 401) {
                this.refreshToken();
                localVarResp = this.usersIdUnmuteWithHttpInfo(sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp != null ? localVarResp.getData() : null;
    }

    public UsersMutingMutationResponse usersIdUnmute(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersMutingMutationResponse localVarResp;
        try {
            localVarResp = this.usersIdUnmute(sourceUserId, targetUserId);
        }
        catch (ApiException e) {
            if (this.handleRateLimit(e, retries)) {
                return this.usersIdUnmute(retries - 1, sourceUserId, targetUserId);
            }
            throw e;
        }
        return localVarResp;
    }

    public ApiResponse<UsersMutingMutationResponse> usersIdUnmuteWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            e.setErrorObjectType((GenericType)new GenericType<ProblemOrError>(){});
            throw e;
        }
    }

    public Call usersIdUnmuteAsync(String sourceUserId, String targetUserId, ApiCallback<UsersMutingMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

