/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.api;

import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.auth.*;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.Configuration;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.ProgressRequestBody;
import com.twitter.clientlib.ProgressResponseBody;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.twitter.clientlib.model.AddBookmarkRequest;
import com.twitter.clientlib.model.BookmarkMutationResponse;
import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.GenericTweetsTimelineResponse;
import com.twitter.clientlib.model.Problem;
import java.util.Set;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.io.InputStream;
import javax.ws.rs.core.GenericType;

import org.apache.commons.lang3.StringUtils;

public class BookmarksApi extends ApiCommon {

    /**
     * Build call for getUsersIdBookmarks
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUsersIdBookmarksCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/bookmarks"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUsersIdBookmarksValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUsersIdBookmarks(Async)");
        }
        

        okhttp3.Call localVarCall = getUsersIdBookmarksCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Bookmarks by User
     * Returns Tweet objects that have been bookmarked by the requesting user
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return GenericTweetsTimelineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericTweetsTimelineResponse getUsersIdBookmarks(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<GenericTweetsTimelineResponse> localVarResp = getUsersIdBookmarksWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericTweetsTimelineResponse getUsersIdBookmarks(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try{
          localVarResp = getUsersIdBookmarks(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return getUsersIdBookmarks(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Bookmarks by User
     * Returns Tweet objects that have been bookmarked by the requesting user
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;GenericTweetsTimelineResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericTweetsTimelineResponse> getUsersIdBookmarksWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Bookmarks by User (asynchronously)
     * Returns Tweet objects that have been bookmarked by the requesting user
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUsersIdBookmarksAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postUsersIdBookmarks
     * @param addBookmarkRequest  (required)
     * @param id The ID of the user for whom to add bookmarks (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postUsersIdBookmarksCall(AddBookmarkRequest addBookmarkRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = addBookmarkRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/bookmarks"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postUsersIdBookmarksValidateBeforeCall(AddBookmarkRequest addBookmarkRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'addBookmarkRequest' is set
        if (addBookmarkRequest == null) {
            throw new ApiException("Missing the required parameter 'addBookmarkRequest' when calling postUsersIdBookmarks(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postUsersIdBookmarks(Async)");
        }
        

        okhttp3.Call localVarCall = postUsersIdBookmarksCall(addBookmarkRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Add Tweet to Bookmarks
     * Adds a Tweet (ID in the body) to the requesting user&#39;s (in the path) bookmarks
     * @param addBookmarkRequest  (required)
     * @param id The ID of the user for whom to add bookmarks (required)
     * @return BookmarkMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public BookmarkMutationResponse postUsersIdBookmarks(AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
      ApiResponse<BookmarkMutationResponse> localVarResp = postUsersIdBookmarksWithHttpInfo(addBookmarkRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public BookmarkMutationResponse postUsersIdBookmarks(Integer retries, AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
        BookmarkMutationResponse localVarResp;
        try{
          localVarResp = postUsersIdBookmarks(addBookmarkRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return postUsersIdBookmarks(retries - 1, addBookmarkRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Add Tweet to Bookmarks
     * Adds a Tweet (ID in the body) to the requesting user&#39;s (in the path) bookmarks
     * @param addBookmarkRequest  (required)
     * @param id The ID of the user for whom to add bookmarks (required)
     * @return ApiResponse&lt;BookmarkMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BookmarkMutationResponse> postUsersIdBookmarksWithHttpInfo(AddBookmarkRequest addBookmarkRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = postUsersIdBookmarksValidateBeforeCall(addBookmarkRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Add Tweet to Bookmarks (asynchronously)
     * Adds a Tweet (ID in the body) to the requesting user&#39;s (in the path) bookmarks
     * @param addBookmarkRequest  (required)
     * @param id The ID of the user for whom to add bookmarks (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postUsersIdBookmarksAsync(AddBookmarkRequest addBookmarkRequest, String id, final ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = postUsersIdBookmarksValidateBeforeCall(addBookmarkRequest, id, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdBookmarksDelete
     * @param id The ID of the user whose bookmark is to be removed. (required)
     * @param tweetId The ID of the tweet that the user is removing from bookmarks (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBookmarksDeleteCall(String id, String tweetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/bookmarks/{tweet_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "tweet_id" + "\\}", localVarApiClient.escapeString(tweetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdBookmarksDeleteValidateBeforeCall(String id, String tweetId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBookmarksDelete(Async)");
        }
        
        // verify the required parameter 'tweetId' is set
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdBookmarksDelete(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdBookmarksDeleteCall(id, tweetId, _callback);
        return localVarCall;

    }

    /**
     * Remove a bookmarked Tweet
     * Removes a Tweet from the requesting user&#39;s bookmarked Tweets.
     * @param id The ID of the user whose bookmark is to be removed. (required)
     * @param tweetId The ID of the tweet that the user is removing from bookmarks (required)
     * @return BookmarkMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public BookmarkMutationResponse usersIdBookmarksDelete(String id, String tweetId) throws ApiException {
      ApiResponse<BookmarkMutationResponse> localVarResp = usersIdBookmarksDeleteWithHttpInfo(id, tweetId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public BookmarkMutationResponse usersIdBookmarksDelete(Integer retries, String id, String tweetId) throws ApiException {
        BookmarkMutationResponse localVarResp;
        try{
          localVarResp = usersIdBookmarksDelete(id, tweetId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdBookmarksDelete(retries - 1, id, tweetId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Remove a bookmarked Tweet
     * Removes a Tweet from the requesting user&#39;s bookmarked Tweets.
     * @param id The ID of the user whose bookmark is to be removed. (required)
     * @param tweetId The ID of the tweet that the user is removing from bookmarks (required)
     * @return ApiResponse&lt;BookmarkMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BookmarkMutationResponse> usersIdBookmarksDeleteWithHttpInfo(String id, String tweetId) throws ApiException {
        okhttp3.Call localVarCall = usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Remove a bookmarked Tweet (asynchronously)
     * Removes a Tweet from the requesting user&#39;s bookmarked Tweets.
     * @param id The ID of the user whose bookmark is to be removed. (required)
     * @param tweetId The ID of the tweet that the user is removing from bookmarks (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBookmarksDeleteAsync(String id, String tweetId, final ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
