/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.api;

import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.auth.*;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.Configuration;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.ProgressRequestBody;
import com.twitter.clientlib.ProgressResponseBody;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.ListAddMemberRequest;
import com.twitter.clientlib.model.ListCreateRequest;
import com.twitter.clientlib.model.ListCreateResponse;
import com.twitter.clientlib.model.ListDeleteResponse;
import com.twitter.clientlib.model.ListFollowRequest;
import com.twitter.clientlib.model.ListFollowedResponse;
import com.twitter.clientlib.model.ListMemberResponse;
import com.twitter.clientlib.model.ListPinRequest;
import com.twitter.clientlib.model.ListPinnedResponse;
import com.twitter.clientlib.model.ListUpdateRequest;
import com.twitter.clientlib.model.ListUpdateResponse;
import com.twitter.clientlib.model.MultiListNoPaginationResponse;
import com.twitter.clientlib.model.MultiListResponse;
import com.twitter.clientlib.model.Problem;
import java.util.Set;
import com.twitter.clientlib.model.SingleListLookupResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.io.InputStream;
import javax.ws.rs.core.GenericType;

import org.apache.commons.lang3.StringUtils;

public class ListsApi extends ApiCommon {

    /**
     * Build call for getUserListMemberships
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUserListMembershipsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/list_memberships"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (listFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUserListMembershipsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUserListMemberships(Async)");
        }
        

        okhttp3.Call localVarCall = getUserListMembershipsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;

    }

    /**
     * Get a User&#39;s List Memberships
     * Get a User&#39;s List Memberships.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiListResponse getUserListMemberships(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
      ApiResponse<MultiListResponse> localVarResp = getUserListMembershipsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiListResponse getUserListMemberships(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try{
          localVarResp = getUserListMemberships(id, maxResults, paginationToken, listFields, expansions, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return getUserListMemberships(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Get a User&#39;s List Memberships
     * Get a User&#39;s List Memberships.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiListResponse> getUserListMembershipsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Get a User&#39;s List Memberships (asynchronously)
     * Get a User&#39;s List Memberships.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUserListMembershipsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback<MultiListResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAddMember
     * @param listAddMemberRequest  (optional)
     * @param id The ID of the List to add a member (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAddMemberCall(ListAddMemberRequest listAddMemberRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = listAddMemberRequest;

        // create path and map variables
        String localVarPath = "/2/lists/{id}/members"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAddMemberValidateBeforeCall(ListAddMemberRequest listAddMemberRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listAddMember(Async)");
        }
        

        okhttp3.Call localVarCall = listAddMemberCall(listAddMemberRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Add a List member
     * Causes a user to become a member of a List.
     * @param listAddMemberRequest  (optional)
     * @param id The ID of the List to add a member (required)
     * @return ListMemberResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListMemberResponse listAddMember(ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
      ApiResponse<ListMemberResponse> localVarResp = listAddMemberWithHttpInfo(listAddMemberRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListMemberResponse listAddMember(Integer retries, ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
        ListMemberResponse localVarResp;
        try{
          localVarResp = listAddMember(listAddMemberRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listAddMember(retries - 1, listAddMemberRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Add a List member
     * Causes a user to become a member of a List.
     * @param listAddMemberRequest  (optional)
     * @param id The ID of the List to add a member (required)
     * @return ApiResponse&lt;ListMemberResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListMemberResponse> listAddMemberWithHttpInfo(ListAddMemberRequest listAddMemberRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = listAddMemberValidateBeforeCall(listAddMemberRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Add a List member (asynchronously)
     * Causes a user to become a member of a List.
     * @param listAddMemberRequest  (optional)
     * @param id The ID of the List to add a member (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAddMemberAsync(ListAddMemberRequest listAddMemberRequest, String id, final ApiCallback<ListMemberResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAddMemberValidateBeforeCall(listAddMemberRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIdCreate
     * @param listCreateRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdCreateCall(ListCreateRequest listCreateRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = listCreateRequest;

        // create path and map variables
        String localVarPath = "/2/lists";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIdCreateValidateBeforeCall(ListCreateRequest listCreateRequest, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listIdCreateCall(listCreateRequest, _callback);
        return localVarCall;

    }

    /**
     * Create List
     * Creates a new List.
     * @param listCreateRequest  (optional)
     * @return ListCreateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListCreateResponse listIdCreate(ListCreateRequest listCreateRequest) throws ApiException {
      ApiResponse<ListCreateResponse> localVarResp = listIdCreateWithHttpInfo(listCreateRequest);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListCreateResponse listIdCreate(Integer retries, ListCreateRequest listCreateRequest) throws ApiException {
        ListCreateResponse localVarResp;
        try{
          localVarResp = listIdCreate(listCreateRequest);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listIdCreate(retries - 1, listCreateRequest);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Create List
     * Creates a new List.
     * @param listCreateRequest  (optional)
     * @return ApiResponse&lt;ListCreateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListCreateResponse> listIdCreateWithHttpInfo(ListCreateRequest listCreateRequest) throws ApiException {
        okhttp3.Call localVarCall = listIdCreateValidateBeforeCall(listCreateRequest, null);
        try {
            Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Create List (asynchronously)
     * Creates a new List.
     * @param listCreateRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdCreateAsync(ListCreateRequest listCreateRequest, final ApiCallback<ListCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIdCreateValidateBeforeCall(listCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIdDelete
     * @param id The ID of the List to delete (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdDeleteCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIdDeleteValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdDelete(Async)");
        }
        

        okhttp3.Call localVarCall = listIdDeleteCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete List
     * Delete a List that you own.
     * @param id The ID of the List to delete (required)
     * @return ListDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListDeleteResponse listIdDelete(String id) throws ApiException {
      ApiResponse<ListDeleteResponse> localVarResp = listIdDeleteWithHttpInfo(id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListDeleteResponse listIdDelete(Integer retries, String id) throws ApiException {
        ListDeleteResponse localVarResp;
        try{
          localVarResp = listIdDelete(id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listIdDelete(retries - 1, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Delete List
     * Delete a List that you own.
     * @param id The ID of the List to delete (required)
     * @return ApiResponse&lt;ListDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListDeleteResponse> listIdDeleteWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = listIdDeleteValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Delete List (asynchronously)
     * Delete a List that you own.
     * @param id The ID of the List to delete (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdDeleteAsync(String id, final ApiCallback<ListDeleteResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIdDeleteValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIdGet
     * @param id The ID of the List to get (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdGetCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (listFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIdGetValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdGet(Async)");
        }
        

        okhttp3.Call localVarCall = listIdGetCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;

    }

    /**
     * List lookup by List ID
     * Returns a List
     * @param id The ID of the List to get (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return SingleListLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleListLookupResponse listIdGet(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
      ApiResponse<SingleListLookupResponse> localVarResp = listIdGetWithHttpInfo(id, listFields, expansions, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleListLookupResponse listIdGet(Integer retries, String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        SingleListLookupResponse localVarResp;
        try{
          localVarResp = listIdGet(id, listFields, expansions, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listIdGet(retries - 1, id, listFields, expansions, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * List lookup by List ID
     * Returns a List
     * @param id The ID of the List to get (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;SingleListLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleListLookupResponse> listIdGetWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = listIdGetValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleListLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * List lookup by List ID (asynchronously)
     * Returns a List
     * @param id The ID of the List to get (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdGetAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback<SingleListLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIdGetValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleListLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIdUpdate
     * @param listUpdateRequest  (optional)
     * @param id The ID of the List to modify (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdUpdateCall(ListUpdateRequest listUpdateRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = listUpdateRequest;

        // create path and map variables
        String localVarPath = "/2/lists/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIdUpdateValidateBeforeCall(ListUpdateRequest listUpdateRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdUpdate(Async)");
        }
        

        okhttp3.Call localVarCall = listIdUpdateCall(listUpdateRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Update List
     * Update a List that you own.
     * @param listUpdateRequest  (optional)
     * @param id The ID of the List to modify (required)
     * @return ListUpdateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListUpdateResponse listIdUpdate(ListUpdateRequest listUpdateRequest, String id) throws ApiException {
      ApiResponse<ListUpdateResponse> localVarResp = listIdUpdateWithHttpInfo(listUpdateRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListUpdateResponse listIdUpdate(Integer retries, ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        ListUpdateResponse localVarResp;
        try{
          localVarResp = listIdUpdate(listUpdateRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listIdUpdate(retries - 1, listUpdateRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Update List
     * Update a List that you own.
     * @param listUpdateRequest  (optional)
     * @param id The ID of the List to modify (required)
     * @return ApiResponse&lt;ListUpdateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListUpdateResponse> listIdUpdateWithHttpInfo(ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = listIdUpdateValidateBeforeCall(listUpdateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Update List (asynchronously)
     * Update a List that you own.
     * @param listUpdateRequest  (optional)
     * @param id The ID of the List to modify (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIdUpdateAsync(ListUpdateRequest listUpdateRequest, String id, final ApiCallback<ListUpdateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIdUpdateValidateBeforeCall(listUpdateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listRemoveMember
     * @param id The ID of the List to remove a member (required)
     * @param userId The ID of user that will be removed from the List (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemoveMemberCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}/members/{user_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "user_id" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listRemoveMemberValidateBeforeCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listRemoveMember(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listRemoveMember(Async)");
        }
        

        okhttp3.Call localVarCall = listRemoveMemberCall(id, userId, _callback);
        return localVarCall;

    }

    /**
     * Remove a List member
     * Causes a user to be removed from the members of a List.
     * @param id The ID of the List to remove a member (required)
     * @param userId The ID of user that will be removed from the List (required)
     * @return ListMemberResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListMemberResponse listRemoveMember(String id, String userId) throws ApiException {
      ApiResponse<ListMemberResponse> localVarResp = listRemoveMemberWithHttpInfo(id, userId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListMemberResponse listRemoveMember(Integer retries, String id, String userId) throws ApiException {
        ListMemberResponse localVarResp;
        try{
          localVarResp = listRemoveMember(id, userId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listRemoveMember(retries - 1, id, userId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Remove a List member
     * Causes a user to be removed from the members of a List.
     * @param id The ID of the List to remove a member (required)
     * @param userId The ID of user that will be removed from the List (required)
     * @return ApiResponse&lt;ListMemberResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListMemberResponse> listRemoveMemberWithHttpInfo(String id, String userId) throws ApiException {
        okhttp3.Call localVarCall = listRemoveMemberValidateBeforeCall(id, userId, null);
        try {
            Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Remove a List member (asynchronously)
     * Causes a user to be removed from the members of a List.
     * @param id The ID of the List to remove a member (required)
     * @param userId The ID of user that will be removed from the List (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemoveMemberAsync(String id, String userId, final ApiCallback<ListMemberResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listRemoveMemberValidateBeforeCall(id, userId, _callback);
        Type localVarReturnType = new TypeToken<ListMemberResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserFollow
     * @param listFollowRequest  (optional)
     * @param id The ID of the authenticated source user that will follow the List (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserFollowCall(ListFollowRequest listFollowRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = listFollowRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/followed_lists"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserFollowValidateBeforeCall(ListFollowRequest listFollowRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserFollow(Async)");
        }
        

        okhttp3.Call localVarCall = listUserFollowCall(listFollowRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Follow a List
     * Causes a user to follow a List.
     * @param listFollowRequest  (optional)
     * @param id The ID of the authenticated source user that will follow the List (required)
     * @return ListFollowedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListFollowedResponse listUserFollow(ListFollowRequest listFollowRequest, String id) throws ApiException {
      ApiResponse<ListFollowedResponse> localVarResp = listUserFollowWithHttpInfo(listFollowRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListFollowedResponse listUserFollow(Integer retries, ListFollowRequest listFollowRequest, String id) throws ApiException {
        ListFollowedResponse localVarResp;
        try{
          localVarResp = listUserFollow(listFollowRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserFollow(retries - 1, listFollowRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Follow a List
     * Causes a user to follow a List.
     * @param listFollowRequest  (optional)
     * @param id The ID of the authenticated source user that will follow the List (required)
     * @return ApiResponse&lt;ListFollowedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListFollowedResponse> listUserFollowWithHttpInfo(ListFollowRequest listFollowRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = listUserFollowValidateBeforeCall(listFollowRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Follow a List (asynchronously)
     * Causes a user to follow a List.
     * @param listFollowRequest  (optional)
     * @param id The ID of the authenticated source user that will follow the List (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserFollowAsync(ListFollowRequest listFollowRequest, String id, final ApiCallback<ListFollowedResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserFollowValidateBeforeCall(listFollowRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserOwnedLists
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserOwnedListsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/owned_lists"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (listFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserOwnedListsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserOwnedLists(Async)");
        }
        

        okhttp3.Call localVarCall = listUserOwnedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;

    }

    /**
     * Get a User&#39;s Owned Lists
     * Get a User&#39;s Owned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiListResponse listUserOwnedLists(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
      ApiResponse<MultiListResponse> localVarResp = listUserOwnedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiListResponse listUserOwnedLists(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try{
          localVarResp = listUserOwnedLists(id, maxResults, paginationToken, listFields, expansions, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserOwnedLists(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Get a User&#39;s Owned Lists
     * Get a User&#39;s Owned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiListResponse> listUserOwnedListsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Get a User&#39;s Owned Lists (asynchronously)
     * Get a User&#39;s Owned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserOwnedListsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback<MultiListResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserPin
     * @param listPinRequest  (optional)
     * @param id The ID of the authenticated source user that will pin the List (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserPinCall(ListPinRequest listPinRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = listPinRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/pinned_lists"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserPinValidateBeforeCall(ListPinRequest listPinRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPin(Async)");
        }
        

        okhttp3.Call localVarCall = listUserPinCall(listPinRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Pin a List
     * Causes a user to pin a List.
     * @param listPinRequest  (optional)
     * @param id The ID of the authenticated source user that will pin the List (required)
     * @return ListPinnedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListPinnedResponse listUserPin(ListPinRequest listPinRequest, String id) throws ApiException {
      ApiResponse<ListPinnedResponse> localVarResp = listUserPinWithHttpInfo(listPinRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListPinnedResponse listUserPin(Integer retries, ListPinRequest listPinRequest, String id) throws ApiException {
        ListPinnedResponse localVarResp;
        try{
          localVarResp = listUserPin(listPinRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserPin(retries - 1, listPinRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Pin a List
     * Causes a user to pin a List.
     * @param listPinRequest  (optional)
     * @param id The ID of the authenticated source user that will pin the List (required)
     * @return ApiResponse&lt;ListPinnedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListPinnedResponse> listUserPinWithHttpInfo(ListPinRequest listPinRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = listUserPinValidateBeforeCall(listPinRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Pin a List (asynchronously)
     * Causes a user to pin a List.
     * @param listPinRequest  (optional)
     * @param id The ID of the authenticated source user that will pin the List (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserPinAsync(ListPinRequest listPinRequest, String id, final ApiCallback<ListPinnedResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserPinValidateBeforeCall(listPinRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserPinnedLists
     * @param id The ID of the user for whom to return results (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserPinnedListsCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/pinned_lists"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (listFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserPinnedListsValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPinnedLists(Async)");
        }
        

        okhttp3.Call localVarCall = listUserPinnedListsCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;

    }

    /**
     * Get a User&#39;s Pinned Lists
     * Get a User&#39;s Pinned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiListNoPaginationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiListNoPaginationResponse listUserPinnedLists(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
      ApiResponse<MultiListNoPaginationResponse> localVarResp = listUserPinnedListsWithHttpInfo(id, listFields, expansions, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiListNoPaginationResponse listUserPinnedLists(Integer retries, String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListNoPaginationResponse localVarResp;
        try{
          localVarResp = listUserPinnedLists(id, listFields, expansions, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserPinnedLists(retries - 1, id, listFields, expansions, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Get a User&#39;s Pinned Lists
     * Get a User&#39;s Pinned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiListNoPaginationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiListNoPaginationResponse> listUserPinnedListsWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListNoPaginationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Get a User&#39;s Pinned Lists (asynchronously)
     * Get a User&#39;s Pinned Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserPinnedListsAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback<MultiListNoPaginationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListNoPaginationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserUnfollow
     * @param id The ID of the authenticated source user that will unfollow the List (required)
     * @param listId The ID of the List to unfollow (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserUnfollowCall(String id, String listId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/followed_lists/{list_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "list_id" + "\\}", localVarApiClient.escapeString(listId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserUnfollowValidateBeforeCall(String id, String listId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnfollow(Async)");
        }
        
        // verify the required parameter 'listId' is set
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnfollow(Async)");
        }
        

        okhttp3.Call localVarCall = listUserUnfollowCall(id, listId, _callback);
        return localVarCall;

    }

    /**
     * Unfollow a List
     * Causes a user to unfollow a List.
     * @param id The ID of the authenticated source user that will unfollow the List (required)
     * @param listId The ID of the List to unfollow (required)
     * @return ListFollowedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListFollowedResponse listUserUnfollow(String id, String listId) throws ApiException {
      ApiResponse<ListFollowedResponse> localVarResp = listUserUnfollowWithHttpInfo(id, listId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListFollowedResponse listUserUnfollow(Integer retries, String id, String listId) throws ApiException {
        ListFollowedResponse localVarResp;
        try{
          localVarResp = listUserUnfollow(id, listId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserUnfollow(retries - 1, id, listId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Unfollow a List
     * Causes a user to unfollow a List.
     * @param id The ID of the authenticated source user that will unfollow the List (required)
     * @param listId The ID of the List to unfollow (required)
     * @return ApiResponse&lt;ListFollowedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListFollowedResponse> listUserUnfollowWithHttpInfo(String id, String listId) throws ApiException {
        okhttp3.Call localVarCall = listUserUnfollowValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Unfollow a List (asynchronously)
     * Causes a user to unfollow a List.
     * @param id The ID of the authenticated source user that will unfollow the List (required)
     * @param listId The ID of the List to unfollow (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserUnfollowAsync(String id, String listId, final ApiCallback<ListFollowedResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserUnfollowValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserUnpin
     * @param id The ID of the authenticated source user that will remove the pinned List (required)
     * @param listId The ID of the List to unpin (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserUnpinCall(String id, String listId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/pinned_lists/{list_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "list_id" + "\\}", localVarApiClient.escapeString(listId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserUnpinValidateBeforeCall(String id, String listId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnpin(Async)");
        }
        
        // verify the required parameter 'listId' is set
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnpin(Async)");
        }
        

        okhttp3.Call localVarCall = listUserUnpinCall(id, listId, _callback);
        return localVarCall;

    }

    /**
     * Unpin a List
     * Causes a user to remove a pinned List.
     * @param id The ID of the authenticated source user that will remove the pinned List (required)
     * @param listId The ID of the List to unpin (required)
     * @return ListPinnedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListPinnedResponse listUserUnpin(String id, String listId) throws ApiException {
      ApiResponse<ListPinnedResponse> localVarResp = listUserUnpinWithHttpInfo(id, listId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListPinnedResponse listUserUnpin(Integer retries, String id, String listId) throws ApiException {
        ListPinnedResponse localVarResp;
        try{
          localVarResp = listUserUnpin(id, listId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listUserUnpin(retries - 1, id, listId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Unpin a List
     * Causes a user to remove a pinned List.
     * @param id The ID of the authenticated source user that will remove the pinned List (required)
     * @param listId The ID of the List to unpin (required)
     * @return ApiResponse&lt;ListPinnedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListPinnedResponse> listUserUnpinWithHttpInfo(String id, String listId) throws ApiException {
        okhttp3.Call localVarCall = listUserUnpinValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Unpin a List (asynchronously)
     * Causes a user to remove a pinned List.
     * @param id The ID of the authenticated source user that will remove the pinned List (required)
     * @param listId The ID of the List to unpin (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserUnpinAsync(String id, String listId, final ApiCallback<ListPinnedResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserUnpinValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for userFollowedLists
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call userFollowedListsCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/followed_lists"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (listFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call userFollowedListsValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling userFollowedLists(Async)");
        }
        

        okhttp3.Call localVarCall = userFollowedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;

    }

    /**
     * Get User&#39;s Followed Lists
     * Returns a user&#39;s followed Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiListResponse userFollowedLists(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
      ApiResponse<MultiListResponse> localVarResp = userFollowedListsWithHttpInfo(id, maxResults, paginationToken, listFields, expansions, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiListResponse userFollowedLists(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        MultiListResponse localVarResp;
        try{
          localVarResp = userFollowedLists(id, maxResults, paginationToken, listFields, expansions, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return userFollowedLists(retries - 1, id, maxResults, paginationToken, listFields, expansions, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Get User&#39;s Followed Lists
     * Returns a user&#39;s followed Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiListResponse> userFollowedListsWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Get User&#39;s Followed Lists (asynchronously)
     * Returns a user&#39;s followed Lists.
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param listFields A comma separated list of List fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call userFollowedListsAsync(String id, Integer maxResults, Long paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, final ApiCallback<MultiListResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
