/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.api;

import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.auth.*;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.Configuration;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.ProgressRequestBody;
import com.twitter.clientlib.ProgressResponseBody;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.MultiSpaceLookupResponse;
import com.twitter.clientlib.model.MultiTweetLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.Problem;
import java.util.Set;
import com.twitter.clientlib.model.SingleSpaceLookupResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.io.InputStream;
import javax.ws.rs.core.GenericType;

import org.apache.commons.lang3.StringUtils;

public class SpacesApi extends ApiCommon {

    /**
     * Build call for findSpaceById
     * @param id The space id to be retrieved (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpaceByIdCall(String id, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findSpaceByIdValidateBeforeCall(String id, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findSpaceById(Async)");
        }
        

        okhttp3.Call localVarCall = findSpaceByIdCall(id, spaceFields, expansions, _callback);
        return localVarCall;

    }

    /**
     * Space lookup by Space ID
     * Returns a variety of information about the Space specified by the requested ID
     * @param id The space id to be retrieved (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return SingleSpaceLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleSpaceLookupResponse findSpaceById(String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
      ApiResponse<SingleSpaceLookupResponse> localVarResp = findSpaceByIdWithHttpInfo(id, spaceFields, expansions);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleSpaceLookupResponse findSpaceById(Integer retries, String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        SingleSpaceLookupResponse localVarResp;
        try{
          localVarResp = findSpaceById(id, spaceFields, expansions);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findSpaceById(retries - 1, id, spaceFields, expansions);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Space lookup by Space ID
     * Returns a variety of information about the Space specified by the requested ID
     * @param id The space id to be retrieved (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return ApiResponse&lt;SingleSpaceLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleSpaceLookupResponse> findSpaceByIdWithHttpInfo(String id, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        okhttp3.Call localVarCall = findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<SingleSpaceLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Space lookup by Space ID (asynchronously)
     * Returns a variety of information about the Space specified by the requested ID
     * @param id The space id to be retrieved (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpaceByIdAsync(String id, Set<String> spaceFields, Set<String> expansions, final ApiCallback<SingleSpaceLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<SingleSpaceLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findSpacesByCreatorIds
     * @param userIds The users to search through (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpacesByCreatorIdsCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/by/creator_ids";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userIds != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "user_ids", userIds));
        }

        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findSpacesByCreatorIdsValidateBeforeCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userIds' is set
        if (userIds == null) {
            throw new ApiException("Missing the required parameter 'userIds' when calling findSpacesByCreatorIds(Async)");
        }
        

        okhttp3.Call localVarCall = findSpacesByCreatorIdsCall(userIds, spaceFields, expansions, _callback);
        return localVarCall;

    }

    /**
     * Space lookup by their creators
     * Returns a variety of information about the Spaces created by the provided User IDs
     * @param userIds The users to search through (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return MultiSpaceLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiSpaceLookupResponse findSpacesByCreatorIds(List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
      ApiResponse<MultiSpaceLookupResponse> localVarResp = findSpacesByCreatorIdsWithHttpInfo(userIds, spaceFields, expansions);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiSpaceLookupResponse findSpacesByCreatorIds(Integer retries, List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try{
          localVarResp = findSpacesByCreatorIds(userIds, spaceFields, expansions);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findSpacesByCreatorIds(retries - 1, userIds, spaceFields, expansions);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Space lookup by their creators
     * Returns a variety of information about the Spaces created by the provided User IDs
     * @param userIds The users to search through (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return ApiResponse&lt;MultiSpaceLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiSpaceLookupResponse> findSpacesByCreatorIdsWithHttpInfo(List<String> userIds, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        okhttp3.Call localVarCall = findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Space lookup by their creators (asynchronously)
     * Returns a variety of information about the Spaces created by the provided User IDs
     * @param userIds The users to search through (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpacesByCreatorIdsAsync(List<String> userIds, Set<String> spaceFields, Set<String> expansions, final ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findSpacesByIds
     * @param ids A list of space ids (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpacesByIdsCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ids != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "ids", ids));
        }

        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findSpacesByIdsValidateBeforeCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findSpacesByIds(Async)");
        }
        

        okhttp3.Call localVarCall = findSpacesByIdsCall(ids, spaceFields, expansions, _callback);
        return localVarCall;

    }

    /**
     * Space lookup up Space IDs
     * Returns a variety of information about the Spaces specified by the requested IDs
     * @param ids A list of space ids (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return MultiSpaceLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiSpaceLookupResponse findSpacesByIds(List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
      ApiResponse<MultiSpaceLookupResponse> localVarResp = findSpacesByIdsWithHttpInfo(ids, spaceFields, expansions);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiSpaceLookupResponse findSpacesByIds(Integer retries, List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try{
          localVarResp = findSpacesByIds(ids, spaceFields, expansions);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findSpacesByIds(retries - 1, ids, spaceFields, expansions);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Space lookup up Space IDs
     * Returns a variety of information about the Spaces specified by the requested IDs
     * @param ids A list of space ids (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return ApiResponse&lt;MultiSpaceLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiSpaceLookupResponse> findSpacesByIdsWithHttpInfo(List<String> ids, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        okhttp3.Call localVarCall = findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Space lookup up Space IDs (asynchronously)
     * Returns a variety of information about the Spaces specified by the requested IDs
     * @param ids A list of space ids (required)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findSpacesByIdsAsync(List<String> ids, Set<String> spaceFields, Set<String> expansions, final ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for searchSpaces
     * @param query The search query (required)
     * @param state The state of spaces to search for (optional, default to all)
     * @param maxResults The number of results to return. The maximum for this value is 100. (optional)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchSpacesCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (state != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("state", state));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchSpacesValidateBeforeCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling searchSpaces(Async)");
        }
        

        okhttp3.Call localVarCall = searchSpacesCall(query, state, maxResults, spaceFields, expansions, _callback);
        return localVarCall;

    }

    /**
     * Search for Spaces
     * Returns Spaces that match the provided query.
     * @param query The search query (required)
     * @param state The state of spaces to search for (optional, default to all)
     * @param maxResults The number of results to return. The maximum for this value is 100. (optional)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return MultiSpaceLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiSpaceLookupResponse searchSpaces(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
      ApiResponse<MultiSpaceLookupResponse> localVarResp = searchSpacesWithHttpInfo(query, state, maxResults, spaceFields, expansions);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiSpaceLookupResponse searchSpaces(Integer retries, String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        MultiSpaceLookupResponse localVarResp;
        try{
          localVarResp = searchSpaces(query, state, maxResults, spaceFields, expansions);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return searchSpaces(retries - 1, query, state, maxResults, spaceFields, expansions);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Search for Spaces
     * Returns Spaces that match the provided query.
     * @param query The search query (required)
     * @param state The state of spaces to search for (optional, default to all)
     * @param maxResults The number of results to return. The maximum for this value is 100. (optional)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @return ApiResponse&lt;MultiSpaceLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiSpaceLookupResponse> searchSpacesWithHttpInfo(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions) throws ApiException {
        okhttp3.Call localVarCall = searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, null);
        try {
            Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Search for Spaces (asynchronously)
     * Returns Spaces that match the provided query.
     * @param query The search query (required)
     * @param state The state of spaces to search for (optional, default to all)
     * @param maxResults The number of results to return. The maximum for this value is 100. (optional)
     * @param spaceFields A comma separated list of Space fields to display. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchSpacesAsync(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, final ApiCallback<MultiSpaceLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, _callback);
        Type localVarReturnType = new TypeToken<MultiSpaceLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for spaceBuyers
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceBuyersCall(String id, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/{id}/buyers"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call spaceBuyersValidateBeforeCall(String id, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        

        okhttp3.Call localVarCall = spaceBuyersCall(id, userFields, _callback);
        return localVarCall;

    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiUserLookupResponse spaceBuyers(String id, Set<String> userFields) throws ApiException {
      ApiResponse<MultiUserLookupResponse> localVarResp = spaceBuyersWithHttpInfo(id, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiUserLookupResponse spaceBuyers(Integer retries, String id, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try{
          localVarResp = spaceBuyers(id, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return spaceBuyers(retries - 1, id, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiUserLookupResponse> spaceBuyersWithHttpInfo(String id, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = spaceBuyersValidateBeforeCall(id, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space (asynchronously)
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceBuyersAsync(String id, Set<String> userFields, final ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = spaceBuyersValidateBeforeCall(id, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for spaceTweets
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceTweetsCall(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/{id}/tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call spaceTweetsValidateBeforeCall(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        

        okhttp3.Call localVarCall = spaceTweetsCall(maxResults, id, tweetFields, _callback);
        return localVarCall;

    }

    /**
     * Retrieve tweets from a Space
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @return MultiTweetLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiTweetLookupResponse spaceTweets(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
      ApiResponse<MultiTweetLookupResponse> localVarResp = spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiTweetLookupResponse spaceTweets(Integer retries, Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try{
          localVarResp = spaceTweets(maxResults, id, tweetFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return spaceTweets(retries - 1, maxResults, id, tweetFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Retrieve tweets from a Space
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @return ApiResponse&lt;MultiTweetLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiTweetLookupResponse> spaceTweetsWithHttpInfo(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        okhttp3.Call localVarCall = spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Retrieve tweets from a Space (asynchronously)
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceTweetsAsync(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
