/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.api;

import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.auth.*;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.Configuration;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.ProgressRequestBody;
import com.twitter.clientlib.ProgressResponseBody;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.GenericMultipleUsersLookupResponse;
import com.twitter.clientlib.model.ListLookupMultipleUsersLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.Problem;
import java.util.Set;
import com.twitter.clientlib.model.SingleUserLookupResponse;
import com.twitter.clientlib.model.UsersBlockingMutationResponse;
import com.twitter.clientlib.model.UsersFollowingCreateResponse;
import com.twitter.clientlib.model.UsersFollowingDeleteResponse;
import com.twitter.clientlib.model.UsersFollowingLookupResponse;
import com.twitter.clientlib.model.UsersIdBlockRequest;
import com.twitter.clientlib.model.UsersIdFollowRequest;
import com.twitter.clientlib.model.UsersIdMuteRequest;
import com.twitter.clientlib.model.UsersMutingMutationResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.io.InputStream;
import javax.ws.rs.core.GenericType;

import org.apache.commons.lang3.StringUtils;

public class UsersApi extends ApiCommon {

    /**
     * Build call for findMyUser
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findMyUserCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/me";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findMyUserValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = findMyUserCall(expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * User lookup me
     * This endpoint returns information about the requesting user.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return SingleUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleUserLookupResponse findMyUser(Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<SingleUserLookupResponse> localVarResp = findMyUserWithHttpInfo(expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleUserLookupResponse findMyUser(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try{
          localVarResp = findMyUser(expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findMyUser(retries - 1, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User lookup me
     * This endpoint returns information about the requesting user.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;SingleUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleUserLookupResponse> findMyUserWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = findMyUserValidateBeforeCall(expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User lookup me (asynchronously)
     * This endpoint returns information about the requesting user.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findMyUserAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findMyUserValidateBeforeCall(expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findUserById
     * @param id Required. A User ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUserByIdCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findUserByIdValidateBeforeCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findUserById(Async)");
        }
        

        okhttp3.Call localVarCall = findUserByIdCall(id, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * User lookup by ID
     * This endpoint returns information about a user. Specify user by ID.
     * @param id Required. A User ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return SingleUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleUserLookupResponse findUserById(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<SingleUserLookupResponse> localVarResp = findUserByIdWithHttpInfo(id, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleUserLookupResponse findUserById(Integer retries, String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try{
          localVarResp = findUserById(id, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findUserById(retries - 1, id, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User lookup by ID
     * This endpoint returns information about a user. Specify user by ID.
     * @param id Required. A User ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;SingleUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleUserLookupResponse> findUserByIdWithHttpInfo(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = findUserByIdValidateBeforeCall(id, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User lookup by ID (asynchronously)
     * This endpoint returns information about a user. Specify user by ID.
     * @param id Required. A User ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUserByIdAsync(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findUserByIdValidateBeforeCall(id, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findUserByUsername
     * @param username Required. A username. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUserByUsernameCall(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/by/username/{username}"
            .replaceAll("\\{" + "username" + "\\}", localVarApiClient.escapeString(username.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findUserByUsernameValidateBeforeCall(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'username' is set
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling findUserByUsername(Async)");
        }
        

        okhttp3.Call localVarCall = findUserByUsernameCall(username, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * User lookup by username
     * This endpoint returns information about a user. Specify user by username.
     * @param username Required. A username. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return SingleUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleUserLookupResponse findUserByUsername(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<SingleUserLookupResponse> localVarResp = findUserByUsernameWithHttpInfo(username, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleUserLookupResponse findUserByUsername(Integer retries, String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        SingleUserLookupResponse localVarResp;
        try{
          localVarResp = findUserByUsername(username, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findUserByUsername(retries - 1, username, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User lookup by username
     * This endpoint returns information about a user. Specify user by username.
     * @param username Required. A username. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;SingleUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleUserLookupResponse> findUserByUsernameWithHttpInfo(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = findUserByUsernameValidateBeforeCall(username, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User lookup by username (asynchronously)
     * This endpoint returns information about a user. Specify user by username.
     * @param username Required. A username. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUserByUsernameAsync(String username, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<SingleUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findUserByUsernameValidateBeforeCall(username, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<SingleUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findUsersById
     * @param ids Required. A list of User IDs, comma-separated. You can specify up to 100 IDs. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUsersByIdCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ids != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "ids", ids));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findUsersByIdValidateBeforeCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findUsersById(Async)");
        }
        

        okhttp3.Call localVarCall = findUsersByIdCall(ids, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * User lookup by IDs
     * This endpoint returns information about users. Specify users by their ID.
     * @param ids Required. A list of User IDs, comma-separated. You can specify up to 100 IDs. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiUserLookupResponse findUsersById(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<MultiUserLookupResponse> localVarResp = findUsersByIdWithHttpInfo(ids, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiUserLookupResponse findUsersById(Integer retries, List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try{
          localVarResp = findUsersById(ids, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findUsersById(retries - 1, ids, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User lookup by IDs
     * This endpoint returns information about users. Specify users by their ID.
     * @param ids Required. A list of User IDs, comma-separated. You can specify up to 100 IDs. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiUserLookupResponse> findUsersByIdWithHttpInfo(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = findUsersByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User lookup by IDs (asynchronously)
     * This endpoint returns information about users. Specify users by their ID.
     * @param ids Required. A list of User IDs, comma-separated. You can specify up to 100 IDs. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUsersByIdAsync(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findUsersByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findUsersByUsername
     * @param usernames Required . A list of usernames, comma-separated. You can specify up to 100 usernames. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUsersByUsernameCall(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/by";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (usernames != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "usernames", usernames));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findUsersByUsernameValidateBeforeCall(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'usernames' is set
        if (usernames == null) {
            throw new ApiException("Missing the required parameter 'usernames' when calling findUsersByUsername(Async)");
        }
        

        okhttp3.Call localVarCall = findUsersByUsernameCall(usernames, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * User lookup by usernames
     * This endpoint returns information about users. Specify users by their username.
     * @param usernames Required . A list of usernames, comma-separated. You can specify up to 100 usernames. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiUserLookupResponse findUsersByUsername(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<MultiUserLookupResponse> localVarResp = findUsersByUsernameWithHttpInfo(usernames, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiUserLookupResponse findUsersByUsername(Integer retries, List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try{
          localVarResp = findUsersByUsername(usernames, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findUsersByUsername(retries - 1, usernames, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User lookup by usernames
     * This endpoint returns information about users. Specify users by their username.
     * @param usernames Required . A list of usernames, comma-separated. You can specify up to 100 usernames. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiUserLookupResponse> findUsersByUsernameWithHttpInfo(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = findUsersByUsernameValidateBeforeCall(usernames, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User lookup by usernames (asynchronously)
     * This endpoint returns information about users. Specify users by their username.
     * @param usernames Required . A list of usernames, comma-separated. You can specify up to 100 usernames. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findUsersByUsernameAsync(List<String> usernames, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findUsersByUsernameValidateBeforeCall(usernames, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listGetFollowers
     * @param id The ID of the List for which to return followers (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGetFollowersCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}/followers"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGetFollowersValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetFollowers(Async)");
        }
        

        okhttp3.Call localVarCall = listGetFollowersCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that follow a List by the provided List ID
     * Returns a list of users that follow a List by the provided List ID
     * @param id The ID of the List for which to return followers (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ListLookupMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListLookupMultipleUsersLookupResponse listGetFollowers(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<ListLookupMultipleUsersLookupResponse> localVarResp = listGetFollowersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListLookupMultipleUsersLookupResponse listGetFollowers(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ListLookupMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = listGetFollowers(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listGetFollowers(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that follow a List by the provided List ID
     * Returns a list of users that follow a List by the provided List ID
     * @param id The ID of the List for which to return followers (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;ListLookupMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListLookupMultipleUsersLookupResponse> listGetFollowersWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that follow a List by the provided List ID (asynchronously)
     * Returns a list of users that follow a List by the provided List ID
     * @param id The ID of the List for which to return followers (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGetFollowersAsync(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<ListLookupMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listGetMembers
     * @param id The ID of the List for which to return members (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGetMembersCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}/members"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGetMembersValidateBeforeCall(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetMembers(Async)");
        }
        

        okhttp3.Call localVarCall = listGetMembersCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that are members of a List by the provided List ID
     * Returns a list of users that are members of a List by the provided List ID
     * @param id The ID of the List for which to return members (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ListLookupMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListLookupMultipleUsersLookupResponse listGetMembers(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
      ApiResponse<ListLookupMultipleUsersLookupResponse> localVarResp = listGetMembersWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListLookupMultipleUsersLookupResponse listGetMembers(Integer retries, String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        ListLookupMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = listGetMembers(id, maxResults, paginationToken, expansions, tweetFields, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listGetMembers(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that are members of a List by the provided List ID
     * Returns a list of users that are members of a List by the provided List ID
     * @param id The ID of the List for which to return members (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;ListLookupMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListLookupMultipleUsersLookupResponse> listGetMembersWithHttpInfo(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = listGetMembersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that are members of a List by the provided List ID (asynchronously)
     * Returns a list of users that are members of a List by the provided List ID
     * @param id The ID of the List for which to return members (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get a specified &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listGetMembersAsync(String id, Integer maxResults, Long paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, final ApiCallback<ListLookupMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGetMembersValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, _callback);
        Type localVarReturnType = new TypeToken<ListLookupMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetsIdLikingUsers
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsIdLikingUsersCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}/liking_users"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetsIdLikingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdLikingUsers(Async)");
        }
        

        okhttp3.Call localVarCall = tweetsIdLikingUsersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that have liked the provided Tweet ID
     * Returns a list of users that have liked the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return GenericMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericMultipleUsersLookupResponse tweetsIdLikingUsers(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GenericMultipleUsersLookupResponse> localVarResp = tweetsIdLikingUsersWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericMultipleUsersLookupResponse tweetsIdLikingUsers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = tweetsIdLikingUsers(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetsIdLikingUsers(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that have liked the provided Tweet ID
     * Returns a list of users that have liked the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return ApiResponse&lt;GenericMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericMultipleUsersLookupResponse> tweetsIdLikingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that have liked the provided Tweet ID (asynchronously)
     * Returns a list of users that have liked the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsIdLikingUsersAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetsIdRetweetingUsers
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsIdRetweetingUsersCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}/retweeted_by"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetsIdRetweetingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdRetweetingUsers(Async)");
        }
        

        okhttp3.Call localVarCall = tweetsIdRetweetingUsersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that have retweeted the provided Tweet ID
     * Returns a list of users that have retweeted the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return GenericMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericMultipleUsersLookupResponse tweetsIdRetweetingUsers(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GenericMultipleUsersLookupResponse> localVarResp = tweetsIdRetweetingUsersWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericMultipleUsersLookupResponse tweetsIdRetweetingUsers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = tweetsIdRetweetingUsers(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetsIdRetweetingUsers(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that have retweeted the provided Tweet ID
     * Returns a list of users that have retweeted the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return ApiResponse&lt;GenericMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericMultipleUsersLookupResponse> tweetsIdRetweetingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that have retweeted the provided Tweet ID (asynchronously)
     * Returns a list of users that have retweeted the provided Tweet ID
     * @param id The ID of the Tweet for which to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsIdRetweetingUsersAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdBlock
     * @param usersIdBlockRequest  (optional)
     * @param id The ID of the user that is requesting to block the target user (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBlockCall(UsersIdBlockRequest usersIdBlockRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = usersIdBlockRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/blocking"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdBlockValidateBeforeCall(UsersIdBlockRequest usersIdBlockRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlock(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdBlockCall(usersIdBlockRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Block User by User ID
     * Causes the user (in the path) to block the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdBlockRequest  (optional)
     * @param id The ID of the user that is requesting to block the target user (required)
     * @return UsersBlockingMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersBlockingMutationResponse usersIdBlock(UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
      ApiResponse<UsersBlockingMutationResponse> localVarResp = usersIdBlockWithHttpInfo(usersIdBlockRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersBlockingMutationResponse usersIdBlock(Integer retries, UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
        UsersBlockingMutationResponse localVarResp;
        try{
          localVarResp = usersIdBlock(usersIdBlockRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdBlock(retries - 1, usersIdBlockRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Block User by User ID
     * Causes the user (in the path) to block the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdBlockRequest  (optional)
     * @param id The ID of the user that is requesting to block the target user (required)
     * @return ApiResponse&lt;UsersBlockingMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersBlockingMutationResponse> usersIdBlockWithHttpInfo(UsersIdBlockRequest usersIdBlockRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = usersIdBlockValidateBeforeCall(usersIdBlockRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Block User by User ID (asynchronously)
     * Causes the user (in the path) to block the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdBlockRequest  (optional)
     * @param id The ID of the user that is requesting to block the target user (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBlockAsync(UsersIdBlockRequest usersIdBlockRequest, String id, final ApiCallback<UsersBlockingMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdBlockValidateBeforeCall(usersIdBlockRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdBlocking
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBlockingCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/blocking"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdBlockingValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlocking(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdBlockingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that are blocked by provided user ID
     * Returns a list of users that are blocked by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return GenericMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericMultipleUsersLookupResponse usersIdBlocking(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GenericMultipleUsersLookupResponse> localVarResp = usersIdBlockingWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericMultipleUsersLookupResponse usersIdBlocking(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = usersIdBlocking(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdBlocking(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that are blocked by provided user ID
     * Returns a list of users that are blocked by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return ApiResponse&lt;GenericMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdBlockingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that are blocked by provided user ID (asynchronously)
     * Returns a list of users that are blocked by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdBlockingAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdFollow
     * @param usersIdFollowRequest  (optional)
     * @param id The ID of the user that is requesting to follow the target user (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowCall(UsersIdFollowRequest usersIdFollowRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = usersIdFollowRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/following"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdFollowValidateBeforeCall(UsersIdFollowRequest usersIdFollowRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollow(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdFollowCall(usersIdFollowRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Follow User
     * Causes the user(in the path) to follow, or “request to follow” for protected users, the target user. The user(in the path) must match the user context authorizing the request
     * @param usersIdFollowRequest  (optional)
     * @param id The ID of the user that is requesting to follow the target user (required)
     * @return UsersFollowingCreateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersFollowingCreateResponse usersIdFollow(UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
      ApiResponse<UsersFollowingCreateResponse> localVarResp = usersIdFollowWithHttpInfo(usersIdFollowRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersFollowingCreateResponse usersIdFollow(Integer retries, UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
        UsersFollowingCreateResponse localVarResp;
        try{
          localVarResp = usersIdFollow(usersIdFollowRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdFollow(retries - 1, usersIdFollowRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Follow User
     * Causes the user(in the path) to follow, or “request to follow” for protected users, the target user. The user(in the path) must match the user context authorizing the request
     * @param usersIdFollowRequest  (optional)
     * @param id The ID of the user that is requesting to follow the target user (required)
     * @return ApiResponse&lt;UsersFollowingCreateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersFollowingCreateResponse> usersIdFollowWithHttpInfo(UsersIdFollowRequest usersIdFollowRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = usersIdFollowValidateBeforeCall(usersIdFollowRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Follow User (asynchronously)
     * Causes the user(in the path) to follow, or “request to follow” for protected users, the target user. The user(in the path) must match the user context authorizing the request
     * @param usersIdFollowRequest  (optional)
     * @param id The ID of the user that is requesting to follow the target user (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowAsync(UsersIdFollowRequest usersIdFollowRequest, String id, final ApiCallback<UsersFollowingCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdFollowValidateBeforeCall(usersIdFollowRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdFollowers
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowersCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/followers"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdFollowersValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowers(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdFollowersCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that follow the provided user ID
     * Returns a list of users that follow the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return GenericMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericMultipleUsersLookupResponse usersIdFollowers(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GenericMultipleUsersLookupResponse> localVarResp = usersIdFollowersWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericMultipleUsersLookupResponse usersIdFollowers(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = usersIdFollowers(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdFollowers(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that follow the provided user ID
     * Returns a list of users that follow the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return ApiResponse&lt;GenericMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdFollowersWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that follow the provided user ID (asynchronously)
     * Returns a list of users that follow the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowersAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdFollowing
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowingCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/following"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdFollowingValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowing(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdFollowingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Following by User ID
     * Returns a list of users that are being followed by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return UsersFollowingLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersFollowingLookupResponse usersIdFollowing(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<UsersFollowingLookupResponse> localVarResp = usersIdFollowingWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersFollowingLookupResponse usersIdFollowing(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        UsersFollowingLookupResponse localVarResp;
        try{
          localVarResp = usersIdFollowing(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdFollowing(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Following by User ID
     * Returns a list of users that are being followed by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @return ApiResponse&lt;UsersFollowingLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersFollowingLookupResponse> usersIdFollowingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Following by User ID (asynchronously)
     * Returns a list of users that are being followed by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; or &#39;previous_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdFollowingAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<UsersFollowingLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdMute
     * @param usersIdMuteRequest  (optional)
     * @param id The ID of the user that is requesting to mute the target user (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMuteCall(UsersIdMuteRequest usersIdMuteRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = usersIdMuteRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/muting"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdMuteValidateBeforeCall(UsersIdMuteRequest usersIdMuteRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMute(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdMuteCall(usersIdMuteRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Mute User by User ID
     * Causes the user (in the path) to mute the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdMuteRequest  (optional)
     * @param id The ID of the user that is requesting to mute the target user (required)
     * @return UsersMutingMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersMutingMutationResponse usersIdMute(UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
      ApiResponse<UsersMutingMutationResponse> localVarResp = usersIdMuteWithHttpInfo(usersIdMuteRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersMutingMutationResponse usersIdMute(Integer retries, UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
        UsersMutingMutationResponse localVarResp;
        try{
          localVarResp = usersIdMute(usersIdMuteRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdMute(retries - 1, usersIdMuteRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Mute User by User ID
     * Causes the user (in the path) to mute the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdMuteRequest  (optional)
     * @param id The ID of the user that is requesting to mute the target user (required)
     * @return ApiResponse&lt;UsersMutingMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersMutingMutationResponse> usersIdMuteWithHttpInfo(UsersIdMuteRequest usersIdMuteRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = usersIdMuteValidateBeforeCall(usersIdMuteRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Mute User by User ID (asynchronously)
     * Causes the user (in the path) to mute the target user. The user (in the path) must match the user context authorizing the request
     * @param usersIdMuteRequest  (optional)
     * @param id The ID of the user that is requesting to mute the target user (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMuteAsync(UsersIdMuteRequest usersIdMuteRequest, String id, final ApiCallback<UsersMutingMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdMuteValidateBeforeCall(usersIdMuteRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdMuting
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMutingCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/muting"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdMutingValidateBeforeCall(String id, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMuting(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdMutingCall(id, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Returns user objects that are muted by the provided user ID
     * Returns a list of users that are muted by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return GenericMultipleUsersLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericMultipleUsersLookupResponse usersIdMuting(String id, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GenericMultipleUsersLookupResponse> localVarResp = usersIdMutingWithHttpInfo(id, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericMultipleUsersLookupResponse usersIdMuting(Integer retries, String id, Integer maxResults, String paginationToken) throws ApiException {
        GenericMultipleUsersLookupResponse localVarResp;
        try{
          localVarResp = usersIdMuting(id, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdMuting(retries - 1, id, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns user objects that are muted by the provided user ID
     * Returns a list of users that are muted by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @return ApiResponse&lt;GenericMultipleUsersLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericMultipleUsersLookupResponse> usersIdMutingWithHttpInfo(String id, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns user objects that are muted by the provided user ID (asynchronously)
     * Returns a list of users that are muted by the provided user ID
     * @param id The ID of the user for whom to return results (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMutingAsync(String id, Integer maxResults, String paginationToken, final ApiCallback<GenericMultipleUsersLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GenericMultipleUsersLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdUnblock
     * @param sourceUserId The ID of the user that is requesting to unblock the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unblock (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnblockCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{source_user_id}/blocking/{target_user_id}"
            .replaceAll("\\{" + "source_user_id" + "\\}", localVarApiClient.escapeString(sourceUserId.toString()))
            .replaceAll("\\{" + "target_user_id" + "\\}", localVarApiClient.escapeString(targetUserId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdUnblockValidateBeforeCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sourceUserId' is set
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnblock(Async)");
        }
        
        // verify the required parameter 'targetUserId' is set
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnblock(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdUnblockCall(sourceUserId, targetUserId, _callback);
        return localVarCall;

    }

    /**
     * Unblock User by User ID
     * Causes the source user to unblock the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unblock the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unblock (required)
     * @return UsersBlockingMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersBlockingMutationResponse usersIdUnblock(String sourceUserId, String targetUserId) throws ApiException {
      ApiResponse<UsersBlockingMutationResponse> localVarResp = usersIdUnblockWithHttpInfo(sourceUserId, targetUserId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersBlockingMutationResponse usersIdUnblock(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersBlockingMutationResponse localVarResp;
        try{
          localVarResp = usersIdUnblock(sourceUserId, targetUserId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdUnblock(retries - 1, sourceUserId, targetUserId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Unblock User by User ID
     * Causes the source user to unblock the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unblock the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unblock (required)
     * @return ApiResponse&lt;UsersBlockingMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersBlockingMutationResponse> usersIdUnblockWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        okhttp3.Call localVarCall = usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Unblock User by User ID (asynchronously)
     * Causes the source user to unblock the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unblock the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unblock (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnblockAsync(String sourceUserId, String targetUserId, final ApiCallback<UsersBlockingMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersBlockingMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdUnfollow
     * @param sourceUserId The ID of the user that is requesting to unfollow the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unfollow (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnfollowCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{source_user_id}/following/{target_user_id}"
            .replaceAll("\\{" + "source_user_id" + "\\}", localVarApiClient.escapeString(sourceUserId.toString()))
            .replaceAll("\\{" + "target_user_id" + "\\}", localVarApiClient.escapeString(targetUserId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdUnfollowValidateBeforeCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sourceUserId' is set
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnfollow(Async)");
        }
        
        // verify the required parameter 'targetUserId' is set
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnfollow(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdUnfollowCall(sourceUserId, targetUserId, _callback);
        return localVarCall;

    }

    /**
     * Unfollow User
     * Causes the source user to unfollow the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unfollow the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unfollow (required)
     * @return UsersFollowingDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersFollowingDeleteResponse usersIdUnfollow(String sourceUserId, String targetUserId) throws ApiException {
      ApiResponse<UsersFollowingDeleteResponse> localVarResp = usersIdUnfollowWithHttpInfo(sourceUserId, targetUserId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersFollowingDeleteResponse usersIdUnfollow(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersFollowingDeleteResponse localVarResp;
        try{
          localVarResp = usersIdUnfollow(sourceUserId, targetUserId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdUnfollow(retries - 1, sourceUserId, targetUserId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Unfollow User
     * Causes the source user to unfollow the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unfollow the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unfollow (required)
     * @return ApiResponse&lt;UsersFollowingDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersFollowingDeleteResponse> usersIdUnfollowWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        okhttp3.Call localVarCall = usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Unfollow User (asynchronously)
     * Causes the source user to unfollow the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unfollow the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unfollow (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnfollowAsync(String sourceUserId, String targetUserId, final ApiCallback<UsersFollowingDeleteResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdUnmute
     * @param sourceUserId The ID of the user that is requesting to unmute the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unmute (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnmuteCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{source_user_id}/muting/{target_user_id}"
            .replaceAll("\\{" + "source_user_id" + "\\}", localVarApiClient.escapeString(sourceUserId.toString()))
            .replaceAll("\\{" + "target_user_id" + "\\}", localVarApiClient.escapeString(targetUserId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdUnmuteValidateBeforeCall(String sourceUserId, String targetUserId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sourceUserId' is set
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnmute(Async)");
        }
        
        // verify the required parameter 'targetUserId' is set
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnmute(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdUnmuteCall(sourceUserId, targetUserId, _callback);
        return localVarCall;

    }

    /**
     * Unmute User by User ID
     * Causes the source user to unmute the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unmute the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unmute (required)
     * @return UsersMutingMutationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersMutingMutationResponse usersIdUnmute(String sourceUserId, String targetUserId) throws ApiException {
      ApiResponse<UsersMutingMutationResponse> localVarResp = usersIdUnmuteWithHttpInfo(sourceUserId, targetUserId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersMutingMutationResponse usersIdUnmute(Integer retries, String sourceUserId, String targetUserId) throws ApiException {
        UsersMutingMutationResponse localVarResp;
        try{
          localVarResp = usersIdUnmute(sourceUserId, targetUserId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdUnmute(retries - 1, sourceUserId, targetUserId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Unmute User by User ID
     * Causes the source user to unmute the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unmute the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unmute (required)
     * @return ApiResponse&lt;UsersMutingMutationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersMutingMutationResponse> usersIdUnmuteWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        okhttp3.Call localVarCall = usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Unmute User by User ID (asynchronously)
     * Causes the source user to unmute the target user. The source user must match the user context authorizing the request
     * @param sourceUserId The ID of the user that is requesting to unmute the target user (required)
     * @param targetUserId The ID of the user that the source user is requesting to unmute (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnmuteAsync(String sourceUserId, String targetUserId, final ApiCallback<UsersMutingMutationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersMutingMutationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
