/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.MultiSpaceLookupResponse;
import com.twitter.clientlib.model.MultiTweetLookupResponse;
import com.twitter.clientlib.model.SingleSpaceLookupResponse;
import com.twitter.clientlib.model.Space;
import com.twitter.clientlib.model.Tweet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiSpacesTester
extends ApiTester {
    private final Set<String> spaceFields = new HashSet<String>(Arrays.asList("creator_id", "id", "created_at", "title"));
    private final Set<String> spaceExpansions = new HashSet<String>(Arrays.asList("invited_user_ids", "speaker_ids", "creator_id", "host_ids"));
    private String spaceId;
    private List<String> spacesIds;
    private final String spaceIdNotFound = "1234567890abcd";
    private final List<String> spacesIdsNotFound = Arrays.asList("1234567890abcd");
    private final String spaceEndedId = "1ZkKzbpRMWdKv";
    private final String querySpaces = "Crypto";
    private final String querySpacesNotFound = "zaqwsx12";
    private final String stateAll = "all";

    public Space randomSpace(String query) throws ApiException {
        Space space = null;
        MultiSpaceLookupResponse result = this.apiInstance.spaces().searchSpaces(query, "all", this.maxResults, this.spaceFields, this.spaceExpansions);
        if (result.getData() != null && result.getData().size() > 0) {
            space = (Space)result.getData().get(0);
        }
        return space;
    }

    @BeforeAll
    public void init() throws ApiException {
        this.initApiInstance();
        Space space = this.randomSpace("Crypto");
        if (space != null) {
            this.spaceId = space.getId();
            this.spacesIds = Arrays.asList(this.spaceId);
        }
    }

    @Test
    public void searchSpacesTest() throws ApiException {
        MultiSpaceLookupResponse result = this.apiInstance.spaces().searchSpaces("Crypto", "all", this.maxResults, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkSpaceData((Space)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void searchSpacesNoSpacesTest() throws ApiException {
        MultiSpaceLookupResponse result = this.apiInstance.spaces().searchSpaces("zaqwsx12", "all", this.maxResults, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
    }

    @Test
    public void findSpacesByIdsTest() throws ApiException {
        MultiSpaceLookupResponse result = this.apiInstance.spaces().findSpacesByIds(this.spacesIds, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkSpaceData((Space)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void findSpacesByIdErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().findSpacesByIds(this.spacesIdsNotFound, this.spaceFields, this.spaceExpansions));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `ids` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void findSpaceByIdTest() throws ApiException {
        SingleSpaceLookupResponse result = this.apiInstance.spaces().findSpaceById(this.spaceId, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        this.checkSpaceData(result.getData());
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void findSpaceByIdErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().findSpaceById("1234567890abcd", this.spaceFields, this.spaceExpansions));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void findSpacesByCreatorIdsTest() throws ApiException {
        MultiSpaceLookupResponse result = this.apiInstance.spaces().findSpacesByCreatorIds(this.usersIds, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        if (result.getData() != null) {
            this.checkSpaceData((Space)result.getData().get(0));
            Assertions.assertNotNull((Object)result.getIncludes());
            Assertions.assertNotNull((Object)result.getIncludes().getUsers());
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
        }
    }

    @Test
    public void findSpacesByCreatorIdsCreatorNotFoundTest() throws ApiException {
        MultiSpaceLookupResponse result = this.apiInstance.spaces().findSpacesByCreatorIds(this.usersIdsNotFound, this.spaceFields, this.spaceExpansions);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
    }

    @Test
    public void spaceBuyersNotSpaceOwnerTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceBuyers(this.spaceId, this.userFields));
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You do not have access to this information as you do not own the space.", "Forbidden", 403);
    }

    @Test
    public void spaceBuyersUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceBuyers("1234567890abcd", this.userFields));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void spaceTweetsTest() throws ApiException {
        MultiTweetLookupResponse result = this.apiInstance.spaces().spaceTweets(this.maxResults, this.spaceId, this.tweetFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        if (result.getData() != null) {
            this.checkTweetData((Tweet)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
        }
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void spaceTweetsSpaceEndedTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceTweets(this.maxResults, "1ZkKzbpRMWdKv", this.tweetFields));
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You cannot access this information because the space has ended.", "Forbidden", 403);
    }

    @Test
    public void spaceTweetsSpaceNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceTweets(this.maxResults, "1234567890abcd", this.tweetFields));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }
}

