/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.GenericMultipleUsersLookupResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.ListAddMemberRequest;
import com.twitter.clientlib.model.ListCreateRequest;
import com.twitter.clientlib.model.ListCreateResponse;
import com.twitter.clientlib.model.ListDeleteResponse;
import com.twitter.clientlib.model.ListFollowRequest;
import com.twitter.clientlib.model.ListFollowedResponse;
import com.twitter.clientlib.model.ListLookupMultipleUsersLookupResponse;
import com.twitter.clientlib.model.ListMemberResponse;
import com.twitter.clientlib.model.ListPinRequest;
import com.twitter.clientlib.model.ListPinnedResponse;
import com.twitter.clientlib.model.ListUpdateRequest;
import com.twitter.clientlib.model.ListUpdateResponse;
import com.twitter.clientlib.model.ListsIdTweetsResponse;
import com.twitter.clientlib.model.ModelList;
import com.twitter.clientlib.model.MultiListResponse;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.SingleListLookupResponse;
import com.twitter.clientlib.model.Tweet;
import com.twitter.clientlib.model.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiListsTester
extends ApiTester {
    private final String listId = "84839422";
    private final String listIdNotFound = "11111112";
    private final String listOwnerUserId = "2244994945";
    private final Set<String> listFields = new HashSet<String>(Arrays.asList("owner_id", "follower_count", "created_at", "description"));
    private final Set<String> listsExpansions = new HashSet<String>(Collections.singletonList("owner_id"));
    private final Set<String> expansionsPinnedTweetId = new HashSet<String>(Collections.singletonList("pinned_tweet_id"));

    public ListCreateResponse listIdCreate() throws ApiException {
        ListCreateRequest request = new ListCreateRequest();
        request.setName("MyList");
        request.setPrivate(Boolean.valueOf(true));
        request.setDescription("MyList description");
        return this.apiInstance.lists().listIdCreate(request);
    }

    private ListDeleteResponse deleteList(String id) throws ApiException {
        return this.apiInstance.lists().listIdDelete(id);
    }

    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void listIdGetTest() throws ApiException {
        SingleListLookupResponse result = this.apiInstance.lists().listIdGet("84839422", this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(false, result.getErrors());
        this.checkListData(result.getData());
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
    }

    @Test
    public void listIdGetListNotFoundTest() throws ApiException {
        SingleListLookupResponse result = this.apiInstance.lists().listIdGet("11111112", this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    @Test
    public void listUserOwnedListsTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().listUserOwnedLists("2244994945", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listUserOwnedListsListNotFoundTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().listUserOwnedLists("9999999999999", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void listIdCreateTest() throws ApiException {
        ListCreateResponse result = null;
        try {
            result = this.listIdCreate();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertNotNull((Object)result.getData().getId());
            Assertions.assertNotNull((Object)result.getData().getName());
        }
        finally {
            if (result != null) {
                this.deleteList(result.getData().getId());
            }
        }
    }

    @Test
    public void listIdCreateEmptyValuesTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listIdCreate(null));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `name` field in the request body can not be empty", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listIdUpdateTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateRequest request = new ListUpdateRequest();
            request.setName("MyNewList Updated");
            request.setDescription("updated description");
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(request, list.getData().getId());
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdUpdateListNotFoundTest() throws ApiException {
        ListUpdateRequest request = new ListUpdateRequest();
        request.setName("MyNewList Updated");
        request.setDescription("updated description");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listIdUpdate(request, "11111112"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot update a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listIdUpdateNullValuesTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(null, list.getData().getId());
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdUpdateListNullTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(null, list.getData().getId());
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdDeleteTest() throws ApiException {
        ListCreateResponse list = this.listIdCreate();
        ListDeleteResponse result = this.deleteList(list.getData().getId());
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getDeleted());
    }

    @Test
    public void listIdDeleteListNotFoundTest() throws ApiException {
        ListDeleteResponse result = this.deleteList("11111112");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getDeleted());
    }

    @Test
    public void listIdDeleteListNotMineTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.deleteList("84839422"));
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You are not allowed to delete this List.", "Forbidden", 403);
    }

    @Test
    public void listsIdTweetsTest() throws ApiException {
        ListsIdTweetsResponse result = this.apiInstance.tweets().listsIdTweets("84839422", this.maxResults, null, this.expansions, this.tweetFields, this.userFields, null, null, null);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listsIdTweetsListNotFoundTest() throws ApiException {
        ListsIdTweetsResponse result = this.apiInstance.tweets().listsIdTweets("11111112", this.maxResults, null, this.expansions, this.tweetFields, this.userFields, null, null, null);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAddMemberTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddMemberRequest request = new ListAddMemberRequest();
            request.setUserId(this.userId);
            ListMemberResponse result = this.apiInstance.lists().listAddMember(request, list.getData().getId());
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAddMemberMemberNotFoundTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            String id = list.getData().getId();
            ListAddMemberRequest request = new ListAddMemberRequest();
            request.setUserId("9999999999999");
            ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listAddMember(request, id));
            this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot add a member that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listRemoveMemberTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddMemberRequest addRrequest = new ListAddMemberRequest();
            addRrequest.setUserId(this.userId);
            this.apiInstance.lists().listAddMember(addRrequest, list.getData().getId());
            ListMemberResponse result = this.apiInstance.lists().listRemoveMember(list.getData().getId(), this.userId);
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertFalse((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listRemoveMemberMemberNotFoundTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddMemberRequest addRrequest = new ListAddMemberRequest();
            addRrequest.setUserId(this.userId);
            this.apiInstance.lists().listAddMember(addRrequest, list.getData().getId());
            ListMemberResponse result = this.apiInstance.lists().listRemoveMember(list.getData().getId(), "9999999999999");
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertFalse((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listGetMembersTest() throws ApiException {
        ListLookupMultipleUsersLookupResponse result = this.apiInstance.users().listGetMembers("84839422", this.maxResults, null, this.expansionsPinnedTweetId, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getTweets());
        this.checkTweetData((Tweet)result.getIncludes().getTweets().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listGetMembersListNotFoundTest() throws ApiException {
        ListLookupMultipleUsersLookupResponse result = this.apiInstance.users().listGetMembers("11111112", this.maxResults, null, this.expansionsPinnedTweetId, this.tweetFields, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    @Test
    public void getUserListMembershipsTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().getUserListMemberships("2244994945", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getUserListMembershipsListNotFoundTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().getUserListMemberships("9999999999999", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void usersIdFollowersTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdFollowers("250831586", this.maxResults, null);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowersUserNotExistsTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdFollowers("9999999999999", this.maxResults, null);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void userFollowedListsTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().userFollowedLists("250831586", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void userFollowedListsUserNotFoundTest() throws ApiException {
        MultiListResponse result = this.apiInstance.lists().userFollowedLists("9999999999999", this.maxResults, null, this.listFields, this.listsExpansions, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void listUserFollowTest() throws ApiException {
        ListFollowRequest request = new ListFollowRequest();
        request.setListId("84839422");
        ListFollowedResponse result = this.apiInstance.lists().listUserFollow(request, this.userId);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getFollowing());
    }

    @Test
    public void listUserFollowListNotFoundTest() throws ApiException {
        ListFollowRequest request = new ListFollowRequest();
        request.setListId("11111112");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserFollow(request, this.userId));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot follow a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserFollowUserNotExistsTest() throws ApiException {
        ListFollowRequest request = new ListFollowRequest();
        request.setListId("84839422");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserFollow(request, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserPinTest() throws ApiException {
        ListPinRequest request = new ListPinRequest();
        request.setListId("84839422");
        ListPinnedResponse result = this.apiInstance.lists().listUserPin(request, this.userId);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getPinned());
    }

    @Test
    public void listUserPinListNotFoundTest() throws ApiException {
        ListPinRequest request = new ListPinRequest();
        request.setListId("11111112");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserPin(request, this.userId));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot pin a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserPinUserNotExistsTest() throws ApiException {
        ListPinRequest request = new ListPinRequest();
        request.setListId("84839422");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserPin(request, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserUnpinTest() throws ApiException {
        ListPinnedResponse result = this.apiInstance.lists().listUserUnpin(this.userId, "84839422");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getPinned());
    }

    @Test
    public void listUserUnpinListNotFoundTest() throws ApiException {
        ListPinnedResponse result = this.apiInstance.lists().listUserUnpin(this.userId, "11111112");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getPinned());
    }

    @Test
    public void listUserUnpinUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserUnpin("9999999999999", "84839422"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }
}

